/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.association;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.openmuc.jdlms.DataDirectory;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.ServerConnectionInfo;
import org.openmuc.jdlms.ServerConnectionListener;
import org.openmuc.jdlms.internal.APdu;
import org.openmuc.jdlms.internal.DataDirectoryImpl;
import org.openmuc.jdlms.internal.ReleaseReqReason;
import org.openmuc.jdlms.internal.ReleaseRespReason;
import org.openmuc.jdlms.internal.ServerConnectionData;
import org.openmuc.jdlms.internal.ServiceError;
import org.openmuc.jdlms.internal.StateError;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.ACSEApdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.RLREApdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.RLRQApdu;
import org.openmuc.jdlms.internal.association.AssociationException;
import org.openmuc.jdlms.internal.association.AssociationMessenger;
import org.openmuc.jdlms.internal.association.GenericAssociationException;
import org.openmuc.jdlms.internal.association.InitiateMessageProcessor;
import org.openmuc.jdlms.internal.association.RequestProcessor;
import org.openmuc.jdlms.internal.association.RequestProcessorData;
import org.openmuc.jdlms.internal.association.ln.ActionRequestProcessor;
import org.openmuc.jdlms.internal.association.ln.GetRequestProcessor;
import org.openmuc.jdlms.internal.association.ln.SetRequestProcessor;
import org.openmuc.jdlms.internal.association.sn.ReadRequestProcessor;
import org.openmuc.jdlms.internal.association.sn.WriteRequestProcessor;
import org.openmuc.jdlms.internal.transportlayer.server.ServerConnectionInformationImpl;
import org.openmuc.jdlms.sessionlayer.server.ServerSessionLayer;
import org.openmuc.jdlms.settings.client.ReferencingMethod;
import org.openmuc.jdlms.settings.server.ServerSettings;

public class Association
implements Runnable {
    private final DataDirectoryImpl directory;
    private final ServerSettings settings;
    private final ServerConnectionInformationImpl serverConnectionInformation;
    protected final ServerConnectionData connectionData;
    protected final AssociationMessenger associationMessenger;

    public Association(DataDirectory directory, ServerSessionLayer sessionLayer, Long connectionId, ServerSettings settings, ServerConnectionInformationImpl serverConnectionInformation) {
        this.settings = settings;
        this.directory = (DataDirectoryImpl)directory;
        this.serverConnectionInformation = serverConnectionInformation;
        this.connectionData = new ServerConnectionData(sessionLayer, connectionId);
        this.directory.addConnection(connectionId, this.connectionData);
        this.associationMessenger = new AssociationMessenger(this.connectionData, this.directory);
    }

    @Override
    public final void run() {
        try {
            this.startAssociation();
        }
        catch (GenericAssociationException e) {
            try {
                this.associationMessenger.encodeAndSend(e.getErrorMessageApdu());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (EOFException eOFException) {
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (IOException iOException) {
        }
        finally {
            this.directory.removeConnection(this.connectionData.getConnectionId());
            try {
                this.sessionLayer().close();
            }
            catch (IOException iOException) {}
            this.notifyListener(ServerConnectionInfo.Status.CLOSED);
        }
    }

    private void startAssociation() throws IOException {
        this.connectionData.getSessionLayer().initialize();
        byte[] payload = this.connectionData.getSessionLayer().readNextMessage();
        this.notifyListener(ServerConnectionInfo.Status.OPEN);
        RequestProcessorData requestProcessorData = new RequestProcessorData(this.sessionLayer().getLogicalDeviceId(), this.directory, this.connectionData);
        this.connectionData.setClientId(this.sessionLayer().getClientId());
        DataDirectoryImpl.CosemLogicalDevice cosemLogicalDevice = this.directory.getLogicalDeviceFor(this.sessionLayer().getLogicalDeviceId());
        this.initSecuritySuite(cosemLogicalDevice);
        InitiateMessageProcessor initialmessageProcessor = new InitiateMessageProcessor(this.connectionData, cosemLogicalDevice);
        APdu aarqAPdu = initialmessageProcessor.processInitialMessage(payload);
        this.associationMessenger.encodeAndSend(aarqAPdu);
        Map<COSEMpdu.Choices, RequestProcessor> requestProcessors = this.setUpRequestProcessors(requestProcessorData, initialmessageProcessor.getContextId().getReferencingMethod());
        while (true) {
            APdu apdu = this.associationMessenger.readNextApdu();
            ACSEApdu acseApdu = apdu.getAcseAPdu();
            COSEMpdu cosemPdu = apdu.getCosemPdu();
            if (acseApdu != null && acseApdu.getRlrq() != null) {
                this.sendDisconnectMessage(acseApdu.getRlrq());
                return;
            }
            if (!this.connectionData.isAuthenticated() && cosemPdu.getChoiceIndex() != COSEMpdu.Choices.ACTION_REQUEST) {
                throw new AssociationException(StateError.SERVICE_NOT_ALLOWED, ServiceError.OPERATION_NOT_POSSIBLE);
            }
            RequestProcessor requestProcessor = requestProcessors.get((Object)cosemPdu.getChoiceIndex());
            if (requestProcessor != null) {
                requestProcessor.processRequest(cosemPdu);
            }
            if (this.connectionData.isAuthenticated()) continue;
        }
    }

    protected Map<COSEMpdu.Choices, RequestProcessor> setUpRequestProcessors(RequestProcessorData requestProcessorData, ReferencingMethod referencingMethod) {
        EnumMap<COSEMpdu.Choices, RequestProcessor> requestProcessors = new EnumMap<COSEMpdu.Choices, RequestProcessor>(COSEMpdu.Choices.class);
        if (referencingMethod == ReferencingMethod.LOGICAL) {
            requestProcessors.put(COSEMpdu.Choices.ACTION_REQUEST, new ActionRequestProcessor(this.associationMessenger, requestProcessorData));
            requestProcessors.put(COSEMpdu.Choices.GET_REQUEST, new GetRequestProcessor(this.associationMessenger, requestProcessorData));
            requestProcessors.put(COSEMpdu.Choices.SET_REQUEST, new SetRequestProcessor(this.associationMessenger, requestProcessorData));
        } else {
            requestProcessors.put(COSEMpdu.Choices.READREQUEST, new ReadRequestProcessor(this.associationMessenger, requestProcessorData));
            requestProcessors.put(COSEMpdu.Choices.WRITEREQUEST, new WriteRequestProcessor(this.associationMessenger, requestProcessorData));
        }
        return requestProcessors;
    }

    private void initSecuritySuite(DataDirectoryImpl.CosemLogicalDevice cosemLogicalDevice) {
        Map<Integer, SecuritySuite> restrictions = cosemLogicalDevice.getLogicalDevice().getRestrictions();
        this.connectionData.setSecuritySuite(restrictions.get(this.connectionData.getClientId()));
    }

    private ServerSessionLayer sessionLayer() {
        return this.connectionData.getSessionLayer();
    }

    private void notifyListener(ServerConnectionInfo.Status status) {
        ServerConnectionListener connectionListener = this.settings.getConnectionListener();
        if (connectionListener == null) {
            return;
        }
        this.serverConnectionInformation.setClientId(this.sessionLayer().getClientId());
        this.serverConnectionInformation.setLogicalDeviceAddress(this.sessionLayer().getLogicalDeviceId());
        this.serverConnectionInformation.setStatus(status);
        connectionListener.connectionChanged(this.serverConnectionInformation);
    }

    private void sendDisconnectMessage(RLRQApdu rlrq) throws IOException {
        ReleaseRespReason respReason;
        ReleaseReqReason reqReason = ReleaseReqReason.reasonFor(rlrq.getReason().value.longValue());
        switch (reqReason) {
            case URGENT: {
                respReason = ReleaseRespReason.NOT_FINISHED;
                break;
            }
            case USER_DEFINED: {
                respReason = ReleaseRespReason.USER_DEFINED;
                break;
            }
            default: {
                respReason = ReleaseRespReason.NORMAL;
            }
        }
        RLREApdu rlre = new RLREApdu();
        rlre.setReason(respReason.toDlmsReason());
        ACSEApdu reAcse = new ACSEApdu();
        reAcse.setRlre(rlre);
        APdu reponseApdu = new APdu(reAcse, null);
        byte[] buffer = new byte[6];
        int length = reponseApdu.encode(buffer, null);
        byte[] data = Arrays.copyOfRange(buffer, buffer.length - length, buffer.length);
        this.associationMessenger.send(data);
        this.sessionLayer().close();
    }
}

