/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.security.authentication;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.macs.GMac;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.internal.security.authentication.HlsSecretProcessor;

public class HlsProcessorGmac
implements HlsSecretProcessor {
    @Override
    public byte[] process(byte[] challenge, SecuritySuite securitySuite, byte[] systemTitle, long frameCounter) throws IOException, UnsupportedOperationException {
        byte[] encryptionKey = securitySuite.getGlobalUnicastEncryptionKey();
        byte[] authenticationKey = securitySuite.getAuthenticationKey();
        byte sc = SecurityControl.AUTHENTICATION.getSecurityControlByte();
        byte[] frameCounterBytes = Arrays.copyOfRange(ByteBuffer.allocate(8).putLong(frameCounter).array(), 4, 8);
        byte[] iv = ByteBuffer.allocate(systemTitle.length + frameCounterBytes.length).put(systemTitle).put(frameCounterBytes).array();
        KeyParameter cipherParameters = new KeyParameter(encryptionKey);
        ParametersWithIV parameterWithIV = new ParametersWithIV((CipherParameters)cipherParameters, iv);
        GMac mac = new GMac(new GCMBlockCipher((BlockCipher)new AESEngine()), 96);
        mac.init((CipherParameters)parameterWithIV);
        byte[] input = ByteBuffer.allocate(1 + authenticationKey.length + challenge.length).put(sc).put(authenticationKey).put(challenge).array();
        mac.update(input, 0, input.length);
        byte[] generatedMac = new byte[mac.getMacSize()];
        mac.doFinal(generatedMac, 0);
        return ByteBuffer.allocate(1 + frameCounterBytes.length + generatedMac.length).put(sc).put(frameCounterBytes).put(generatedMac).array();
    }

    private static enum SecurityControl {
        AUTHENTICATION(16),
        ENCRYPTION(32),
        AUTHENTICATION_ENCRYPTION(48);

        private final byte sc;

        private SecurityControl(int b) {
            this.sc = (byte)b;
        }

        public byte getSecurityControlByte() {
            return this.sc;
        }
    }
}

