/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.security.crypto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.gcm.BasicGCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrLength;

public class GcmModule {
    private static final int FC_LENGTH = 4;
    private static final int IV_LENGTH = 12;
    private static final int IV_LENGTH_BITS = 96;
    private static final int LENGTH_FC_TAG_SC = 6;

    public static byte[] processPlain(byte[] plaintext, int off, int len, byte[] systemTitle, long frameCounter, SecuritySuite securitySuite, byte apduTag) throws IOException {
        byte[] frameCounterBytes = Arrays.copyOfRange(ByteBuffer.allocate(8).putLong(frameCounter).array(), 4, 8);
        byte[] iv = ByteBuffer.allocate(systemTitle.length + 4).put(systemTitle).put(frameCounterBytes).array();
        byte[] additionalAssociationData = GcmModule.createAadIfExists(securitySuite);
        AEADParameters parameters = new AEADParameters(new KeyParameter(securitySuite.getGlobalUnicastEncryptionKey()), 96, iv, additionalAssociationData);
        GCMBlockCipher encCipher = GcmModule.createBlockCipher(true, parameters);
        byte[] chipherText = new byte[encCipher.getOutputSize(len)];
        int length = encCipher.processBytes(plaintext, off, len, chipherText, 0);
        try {
            encCipher.doFinal(chipherText, length);
        }
        catch (IllegalStateException | InvalidCipherTextException e) {
            throw new IOException("Unable to cipher/encrypt xDLMS APDU", e);
        }
        int chipherTextLength = chipherText.length;
        if (!securitySuite.getSecurityPolicy().isAuthenticated()) {
            chipherTextLength -= 12;
        }
        byte[] lengthBytes = AxdrLength.encodeLength(chipherTextLength + 5);
        int cipheredApduLength = chipherTextLength + 6 + lengthBytes.length;
        byte controlByte = GcmModule.securityControlByteFrom(securitySuite);
        return ByteBuffer.allocate(cipheredApduLength).put(apduTag).put(lengthBytes).put(controlByte).put(frameCounterBytes).put(chipherText, 0, chipherTextLength).array();
    }

    private static byte[] createAadIfExists(SecuritySuite securitySuite) {
        if (!securitySuite.getSecurityPolicy().isAuthenticated()) {
            return new byte[0];
        }
        byte[] authenticationKey = securitySuite.getAuthenticationKey();
        byte securityControlByte = GcmModule.securityControlByteFrom(securitySuite);
        return ByteBuffer.allocate(authenticationKey.length + 1).put(securityControlByte).put(authenticationKey).array();
    }

    public static byte[] decrypt(byte[] cipheredApdu, byte[] systemTitle, SecuritySuite securitySuite) throws IOException {
        byte[] iv = ByteBuffer.allocate(12).put(systemTitle).put(cipheredApdu, 1, 4).array();
        byte[] additionalAssociationData = GcmModule.createAadIfExists(securitySuite);
        AEADParameters parameters = new AEADParameters(new KeyParameter(securitySuite.getGlobalUnicastEncryptionKey()), 96, iv, additionalAssociationData);
        GCMBlockCipher decCipher = GcmModule.createBlockCipher(false, parameters);
        byte[] dec = new byte[decCipher.getOutputSize(cipheredApdu.length - 5)];
        int length = decCipher.processBytes(cipheredApdu, 5, cipheredApdu.length - 5, dec, 0);
        try {
            decCipher.doFinal(dec, length);
        }
        catch (IllegalStateException | InvalidCipherTextException e) {
            throw new IOException("Unable to decipher/decrypt xDLMS pdu", e);
        }
        return dec;
    }

    private static GCMBlockCipher createBlockCipher(boolean forEncryption, AEADParameters parameters) {
        GCMBlockCipher decCipher = new GCMBlockCipher((BlockCipher)new AESEngine(), (GCMMultiplier)new BasicGCMMultiplier());
        decCipher.init(forEncryption, (CipherParameters)parameters);
        return decCipher;
    }

    private static byte securityControlByteFrom(SecuritySuite securitySuite) {
        if (securitySuite.getEncryptionMechanism() != SecuritySuite.EncryptionMechanism.AES_GCM_128 || securitySuite.getEncryptionMechanism() != SecuritySuite.EncryptionMechanism.AES_GCM_256) {
            // empty if block
        }
        byte sc = 0;
        sc = GcmModule.setBit(sc, 5, securitySuite.getSecurityPolicy().isEncrypted());
        sc = GcmModule.setBit(sc, 4, securitySuite.getSecurityPolicy().isAuthenticated());
        sc = (byte)((long)sc | securitySuite.getEncryptionMechanism().getCode() & 7L);
        return sc;
    }

    private static byte setBit(byte data, int index, boolean flag) {
        if (!flag) {
            return data;
        }
        byte val = (byte)(1 << index & 0xFF);
        return (byte)(data | val);
    }

    private GcmModule() {
    }
}

