/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.systemclasses;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openmuc.jdlms.AccessResultCode;
import org.openmuc.jdlms.AttributeAccessMode;
import org.openmuc.jdlms.AttributeAddress;
import org.openmuc.jdlms.CosemAttribute;
import org.openmuc.jdlms.CosemClass;
import org.openmuc.jdlms.CosemMethod;
import org.openmuc.jdlms.CosemSnInterfaceObject;
import org.openmuc.jdlms.IllegalAttributeAccessException;
import org.openmuc.jdlms.IllegalMethodAccessException;
import org.openmuc.jdlms.MethodAccessMode;
import org.openmuc.jdlms.MethodResultCode;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.AttributeAccessor;
import org.openmuc.jdlms.internal.BaseNameRange;
import org.openmuc.jdlms.internal.BaseNameRangeSet;
import org.openmuc.jdlms.internal.DataDirectoryImpl;
import org.openmuc.jdlms.internal.MethodAccessor;
import org.openmuc.jdlms.internal.systemclasses.CosemDataDirectory;

@CosemClass(id=12, version=4)
public final class AssociationSnClass
extends CosemSnInterfaceObject {
    private static final int ASSOCIATION_SN_BASE_NAME = 64000;
    private static final int CLASS_ID_ACCESS = 1;
    private static final int CLASS_ID_BASE_NANE_ACCESS = 2;
    private static final int BASE_NAME_ACCESS = 3;
    @CosemAttribute(id=2, accessMode=AttributeAccessMode.READ_ONLY, type=DataObject.Type.ARRAY, selector={1, 2, 3}, snOffset=8)
    private DataObject objectList;
    @CosemAttribute(id=3, accessMode=AttributeAccessMode.READ_ONLY, type=DataObject.Type.ARRAY, selector={3}, snOffset=16)
    private DataObject accessRightsList;
    @CosemAttribute(id=4, accessMode=AttributeAccessMode.READ_ONLY, type=DataObject.Type.OCTET_STRING, snOffset=24)
    private DataObject securitySetupReference;
    @CosemAttribute(id=5, accessMode=AttributeAccessMode.READ_ONLY, type=DataObject.Type.ARRAY, snOffset=32)
    private DataObject userList;
    @CosemAttribute(id=6, accessMode=AttributeAccessMode.READ_ONLY, type=DataObject.Type.STRUCTURE, snOffset=40)
    private DataObject currentUser;
    @CosemDataDirectory
    private DataDirectoryImpl directory;
    private final int logicalDeviceId;

    public AssociationSnClass(int logicalDeviceId) {
        super(64000, "0.0.40.0.0.255");
        this.logicalDeviceId = logicalDeviceId;
    }

    public DataObject getObjectList(SelectiveAccessDescription selectiveAccessDescription) throws IllegalAttributeAccessException {
        if (selectiveAccessDescription == null) {
            if (this.objectList == null) {
                this.initializeObjectList();
            }
            return this.objectList;
        }
        return this.getSelectedObjectListElement(selectiveAccessDescription);
    }

    public DataObject getAccessRightsList(SelectiveAccessDescription selectiveAccessDescription) throws IllegalAttributeAccessException {
        if (selectiveAccessDescription == null) {
            if (this.accessRightsList == null) {
                this.initializeAccessRightList();
            }
            return this.accessRightsList;
        }
        return this.getSelectedAccessRightElement(selectiveAccessDescription);
    }

    @CosemMethod(id=3, accessMode=MethodAccessMode.ACCESS, snOffset=48)
    public DataObject readByLogicalName(DataObject data, Long connectionId) throws IllegalMethodAccessException {
        if (data.getType() != DataObject.Type.ARRAY) {
            throw new IllegalMethodAccessException(MethodResultCode.TYPE_UNMATCHED);
        }
        List attributeIds = (List)data.getValue();
        if (attributeIds.isEmpty()) {
            return DataObject.newNullData();
        }
        if (((DataObject)attributeIds.get(0)).getType() != DataObject.Type.STRUCTURE) {
            throw new IllegalMethodAccessException(MethodResultCode.TYPE_UNMATCHED);
        }
        LinkedList<DataObject> res = new LinkedList<DataObject>();
        for (DataObject attributeId : attributeIds) {
            boolean typesDontMatch;
            List struct = (List)attributeId.getValue();
            if (struct.size() != 3) {
                throw new IllegalMethodAccessException(MethodResultCode.TYPE_UNMATCHED);
            }
            DataObject classIdDo = (DataObject)struct.get(0);
            DataObject logicalNameDo = (DataObject)struct.get(1);
            DataObject attributeIndexDo = (DataObject)struct.get(2);
            boolean bl = typesDontMatch = classIdDo.getType() != DataObject.Type.LONG_UNSIGNED || logicalNameDo.getType() != DataObject.Type.OCTET_STRING || attributeIndexDo.getType() != DataObject.Type.INTEGER;
            if (typesDontMatch) {
                throw new IllegalMethodAccessException(MethodResultCode.TYPE_UNMATCHED);
            }
            int classId = (Integer)classIdDo.getValue();
            byte[] obis = (byte[])logicalNameDo.getValue();
            ObisCode instanceId = new ObisCode(obis);
            byte attId = (Byte)attributeIndexDo.getValue();
            if ((attId = (byte)(attId & 0xFF)) == 0) {
                DataDirectoryImpl.CosemLogicalDevice logicalDevice = this.directory.getLogicalDeviceFor(this.logicalDeviceId);
                DataDirectoryImpl.CosemClassInstance cosemClassInstance = logicalDevice.get(instanceId);
                for (AttributeAccessor a : cosemClassInstance.getSortedAttributes()) {
                    AttributeAddress attributeAddress = new AttributeAddress(classId, instanceId, (int)a.getCosemAttribute().id());
                    res.add(this.callGet(connectionId, attributeAddress));
                }
                continue;
            }
            AttributeAddress attributeAddress = new AttributeAddress(classId, instanceId, (int)attId);
            res.add(this.callGet(connectionId, attributeAddress));
        }
        return DataObject.newStructureData(res);
    }

    private DataObject callGet(Long connectionId, AttributeAddress attributeAddress) throws IllegalMethodAccessException {
        try {
            return this.directory.get(this.logicalDeviceId, attributeAddress, connectionId);
        }
        catch (IllegalAttributeAccessException e) {
            throw new IllegalMethodAccessException(MethodResultCode.SCOPE_OF_ACCESS_VIOLATION);
        }
    }

    private DataObject getSelectedObjectListElement(SelectiveAccessDescription selectiveAccessDescription) throws IllegalAttributeAccessException {
        DataObject accessParameter = selectiveAccessDescription.getAccessParameter();
        switch (selectiveAccessDescription.getAccessSelector()) {
            case 1: {
                return this.findClassesForId(accessParameter);
            }
            case 2: {
                return this.findClassForIdAndBaseName(accessParameter);
            }
            case 3: {
                return this.findClassForBaseName(accessParameter);
            }
        }
        throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
    }

    private DataObject findClassForIdAndBaseName(DataObject accessParameter) throws IllegalAttributeAccessException {
        if (accessParameter.getType() != DataObject.Type.STRUCTURE) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        int numberOfParameters = 2;
        List struct = (List)accessParameter.getValue();
        if (struct.size() != 2) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        DataObject classIdDo = (DataObject)struct.get(0);
        DataObject instanceIdDo = (DataObject)struct.get(1);
        if (instanceIdDo.getType() != DataObject.Type.OCTET_STRING) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        byte[] bytes = (byte[])instanceIdDo.getValue();
        final ObisCode exInstanceId = new ObisCode(bytes);
        if (classIdDo.getType() != DataObject.Type.LONG_UNSIGNED) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        final Number exClassId = (Number)classIdDo.getValue();
        DataObject objects = this.findObjects(new Filter(){

            @Override
            public boolean passes(BaseNameRange baseNameRange) {
                DataDirectoryImpl.CosemSnClassInstance classInstance = baseNameRange.getClassInstance();
                int classId = classInstance.getCosemClass().id();
                return classId == exClassId.intValue() && exInstanceId.equals(classInstance.getInstance().getInstanceId());
            }
        });
        List value = (List)objects.getValue();
        if (value.isEmpty()) {
            throw new IllegalAttributeAccessException(AccessResultCode.OBJECT_UNDEFINED);
        }
        return (DataObject)value.get(0);
    }

    private DataObject findClassForBaseName(DataObject accessParameter) throws IllegalAttributeAccessException {
        BaseNameRange baseNameRange = this.baseNameRangeFor(accessParameter);
        if (baseNameRange == null) {
            throw new IllegalAttributeAccessException(AccessResultCode.OBJECT_UNDEFINED);
        }
        return this.objectListElementFor(baseNameRange);
    }

    private DataObject findClassesForId(DataObject accessParameter) throws IllegalAttributeAccessException {
        if (accessParameter.getType() != DataObject.Type.LONG_UNSIGNED) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        Number value = (Number)accessParameter.getValue();
        final int exptClassId = value.intValue();
        return this.findObjects(new Filter(){

            @Override
            public boolean passes(BaseNameRange baseNameRange) {
                return baseNameRange.getClassInstance().getCosemClass().id() == exptClassId;
            }
        });
    }

    private DataObject getSelectedAccessRightElement(SelectiveAccessDescription selectiveAccessDescription) throws IllegalAttributeAccessException {
        int accessSelector = selectiveAccessDescription.getAccessSelector();
        if (accessSelector != 3) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        BaseNameRange baseNameRange = this.baseNameRangeFor(selectiveAccessDescription.getAccessParameter());
        if (baseNameRange == null) {
            throw new IllegalAttributeAccessException(AccessResultCode.OBJECT_UNDEFINED);
        }
        return this.accessRightFor(baseNameRange);
    }

    private BaseNameRange baseNameRangeFor(DataObject accessParameter) throws IllegalAttributeAccessException {
        if (accessParameter.getType() != DataObject.Type.LONG_INTEGER) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        BaseNameRangeSet baseNameRangeSet = this.directory.baseNameRangesFor(this.logicalDeviceId);
        Number basename = (Number)accessParameter.getValue();
        return (BaseNameRange)baseNameRangeSet.getIntersectingRange(basename.shortValue() & 0xFFFF);
    }

    private void initializeAccessRightList() {
        List baseNameRanges = this.directory.baseNameRangesFor(this.logicalDeviceId).toList();
        ArrayList<DataObject> accessRightListElements = new ArrayList<DataObject>(baseNameRanges.size());
        for (BaseNameRange baseNameRange : baseNameRanges) {
            DataObject accessRightListElement = this.accessRightFor(baseNameRange);
            accessRightListElements.add(accessRightListElement);
        }
        this.accessRightsList = DataObject.newArrayData(accessRightListElements);
    }

    private DataObject accessRightFor(BaseNameRange baseNameRange) {
        DataDirectoryImpl.CosemSnClassInstance classInstance = baseNameRange.getClassInstance();
        DataObject baseName = DataObject.newInteger16Data((short)baseNameRange.getBaseName());
        DataObject attribueAccess = AssociationSnClass.attribueAccessFrom(classInstance);
        DataObject methodAccess = AssociationSnClass.methodAccessFrom(classInstance);
        return DataObject.newStructureData(baseName, attribueAccess, methodAccess);
    }

    private static DataObject methodAccessFrom(DataDirectoryImpl.CosemClassInstance classInstance) {
        Collection<MethodAccessor> sortedMethods = classInstance.getSortedMethods();
        ArrayList<DataObject> methodAccessDes = new ArrayList<DataObject>(sortedMethods.size());
        for (MethodAccessor methodAccessor : sortedMethods) {
            CosemMethod cosemMethod = methodAccessor.getCosemMethod();
            DataObject methodId = DataObject.newInteger8Data(cosemMethod.id());
            DataObject accessMode = DataObject.newEnumerateData((int)cosemMethod.accessMode().getCode());
            DataObject methodAccessItem = DataObject.newStructureData(methodId, accessMode);
            methodAccessDes.add(methodAccessItem);
        }
        return DataObject.newArrayData(methodAccessDes);
    }

    private static DataObject attribueAccessFrom(DataDirectoryImpl.CosemClassInstance classInstance) {
        Collection<AttributeAccessor> sortedAttributes = classInstance.getSortedAttributes();
        ArrayList<DataObject> attributeAccessDes = new ArrayList<DataObject>(sortedAttributes.size());
        for (AttributeAccessor attribute : sortedAttributes) {
            CosemAttribute attributeProperties = attribute.getCosemAttribute();
            DataObject attributeId = DataObject.newInteger16Data(attributeProperties.id());
            DataObject accessMode = DataObject.newEnumerateData((int)attributeProperties.accessMode().getCode());
            DataObject accessSelector = AssociationSnClass.createAccessSelector(attributeProperties);
            DataObject attributeAccessItem = DataObject.newStructureData(attributeId, accessMode, accessSelector);
            attributeAccessDes.add(attributeAccessItem);
        }
        return DataObject.newArrayData(attributeAccessDes);
    }

    private static DataObject createAccessSelector(CosemAttribute attributeProperties) {
        int[] selectors = attributeProperties.selector();
        if (selectors.length == 0) {
            return DataObject.newNullData();
        }
        ArrayList<DataObject> selData = new ArrayList<DataObject>(selectors.length);
        for (int selector : selectors) {
            selData.add(DataObject.newInteger8Data((byte)selector));
        }
        return DataObject.newArrayData(selData);
    }

    private void initializeObjectList() {
        this.objectList = this.findObjects(new Filter(){

            @Override
            public boolean passes(BaseNameRange baseNameRange) {
                return true;
            }
        });
    }

    private DataObject findObjects(Filter filter) {
        List baseNameRanges = this.directory.baseNameRangesFor(this.logicalDeviceId).toList();
        ArrayList<DataObject> objectListelements = new ArrayList<DataObject>(baseNameRanges.size());
        for (BaseNameRange baseNameRange : baseNameRanges) {
            if (!filter.passes(baseNameRange)) continue;
            DataObject objectListElement = this.objectListElementFor(baseNameRange);
            objectListelements.add(objectListElement);
        }
        return DataObject.newArrayData(objectListelements);
    }

    private DataObject objectListElementFor(BaseNameRange baseNameRange) {
        DataDirectoryImpl.CosemSnClassInstance classInstance = baseNameRange.getClassInstance();
        CosemClass cosemClass = classInstance.getCosemClass();
        DataObject baseName = DataObject.newInteger16Data((short)baseNameRange.getBaseName());
        DataObject classId = DataObject.newUInteger16Data(cosemClass.id());
        DataObject version = DataObject.newUInteger8Data((short)cosemClass.version());
        DataObject logicalName = DataObject.newOctetStringData(classInstance.getInstance().getInstanceId().bytes());
        List<DataObject> element = Arrays.asList(baseName, classId, version, logicalName);
        return DataObject.newStructureData(element);
    }

    private static interface Filter {
        public boolean passes(BaseNameRange var1);
    }
}

