/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import org.openmuc.jdlms.sessionlayer.hdlc.FcsCalc;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameInvalidException;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameRejectReason;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameType;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcAddress;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcAddressPair;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcParameters;

public class HdlcFrame {
    private static final byte[] LLC_REQUEST;
    private static final byte FLAG = 126;
    private final FrameType frameType;
    private final byte[] informationField;
    private int sendSequence;
    private int receiveSequence;
    private boolean segmented;
    private byte controlField;
    private final HdlcAddressPair addressPair;
    private int length;

    private HdlcFrame(FrameType frameType, byte[] informationField, int sendSequence, int receiveSequence, boolean segmented, byte controlField, HdlcAddressPair addressPair, int length) {
        this.frameType = frameType;
        this.informationField = informationField;
        this.sendSequence = sendSequence;
        this.receiveSequence = receiveSequence;
        this.segmented = segmented;
        this.controlField = controlField;
        this.addressPair = addressPair;
        this.length = length;
    }

    private HdlcFrame(HdlcAddressPair addressPair, FrameType frameType) {
        this(addressPair, frameType, null);
    }

    private HdlcFrame(HdlcAddressPair addressPair, FrameType frameType, byte[] informationField) {
        this.segmented = false;
        this.sendSequence = -1;
        this.receiveSequence = -1;
        this.frameType = frameType;
        this.addressPair = addressPair;
        this.informationField = informationField;
        this.length = 2 + this.getDestinationAddress().getLength() + this.getSourceAddress().getLength() + 1 + 2;
        if (informationField != null) {
            this.length += informationField.length + 2;
        }
    }

    public static HdlcFrame decode(byte[] frame) throws FrameInvalidException {
        FcsCalc fcsCalc = new FcsCalc();
        ByteBuffer buffer = ByteBuffer.wrap(frame);
        byte frameFormatH = buffer.get();
        if ((frameFormatH & 0xF0) != 160) {
            throw new FrameInvalidException("Illegal frame format");
        }
        boolean segmented = (8 & frameFormatH) == 8;
        fcsCalc.update(frameFormatH);
        byte frameFormatL = buffer.get();
        int length = frame.length;
        fcsCalc.update(frameFormatL);
        HdlcAddress destination = HdlcFrame.readAddress(fcsCalc, buffer);
        HdlcAddress source = HdlcFrame.readAddress(fcsCalc, buffer);
        byte controlField = buffer.get();
        fcsCalc.update(controlField);
        FrameType frameType = HdlcFrame.readFrameType(controlField);
        HdlcFrame.verifyFcsCalc(fcsCalc, buffer);
        int sendSequence = 0;
        int receiveSequence = 0;
        switch (frameType) {
            case INFORMATION: {
                sendSequence = (controlField & 0xE) >> 1;
                receiveSequence = (controlField & 0xE0) >> 5;
                break;
            }
            case RECEIVE_READY: 
            case RECEIVE_NOT_READY: {
                receiveSequence = (controlField & 0xE0) >> 5;
                break;
            }
        }
        byte[] informationField = buffer.hasRemaining() ? HdlcFrame.readInformationField(fcsCalc, buffer) : new byte[]{};
        HdlcAddressPair addressPair = new HdlcAddressPair(source, destination);
        return new HdlcFrame(frameType, informationField, sendSequence, receiveSequence, segmented, controlField, addressPair, length);
    }

    private static byte[] readInformationField(FcsCalc fcsCalc, ByteBuffer buffer) throws FrameInvalidException {
        int infoLength = buffer.remaining() - 2;
        byte[] informationField = new byte[infoLength];
        for (int i = 0; i < infoLength; ++i) {
            byte data = buffer.get();
            fcsCalc.update(data);
            informationField[i] = data;
        }
        HdlcFrame.verifyFcsCalc(fcsCalc, buffer);
        return informationField;
    }

    private static void verifyFcsCalc(FcsCalc fcsCalc, ByteBuffer buffer) throws FrameInvalidException {
        fcsCalc.update(buffer.get());
        fcsCalc.update(buffer.get());
        fcsCalc.validateCurrentFcsValue();
    }

    private static FrameType readFrameType(byte controlField) throws FrameInvalidException {
        FrameType frameType = FrameType.frameTypeFor(controlField & 0xFF);
        if (frameType == FrameType.ERR_INVALID_TYPE) {
            FrameRejectReason reason = new FrameRejectReason(controlField);
            throw new FrameInvalidException(MessageFormat.format("Control field unknown {0}", controlField), reason);
        }
        return frameType;
    }

    private static HdlcAddress readAddress(FcsCalc fcsCalc, ByteBuffer buffer) throws FrameInvalidException {
        byte[] data = new byte[4];
        byte currentByte = 0;
        int length = 0;
        while (!(currentByte & true)) {
            if (length == 4) {
                throw new FrameInvalidException("HLDC address is illegal in frame.");
            }
            currentByte = buffer.get();
            fcsCalc.update(currentByte);
            data[length++] = currentByte;
        }
        return HdlcAddress.decode(data, length);
    }

    public static HdlcFrame newInformationFrame(HdlcAddressPair addressPair, int sendSequence, int receiveSequence, byte[] data, boolean segmented, boolean addLcc) {
        byte[] informationField = data;
        if (addLcc) {
            informationField = ByteBuffer.allocate(LLC_REQUEST.length + data.length).put(LLC_REQUEST).put(data).array();
        }
        HdlcFrame hdlcFrame = new HdlcFrame(addressPair, FrameType.INFORMATION, informationField);
        hdlcFrame.sendSequence = sendSequence;
        hdlcFrame.receiveSequence = receiveSequence;
        hdlcFrame.segmented = segmented;
        hdlcFrame.controlField = hdlcFrame.frameType.value();
        hdlcFrame.controlField = (byte)(hdlcFrame.controlField | sendSequence % 8 << 1);
        hdlcFrame.controlField = (byte)(hdlcFrame.controlField | receiveSequence % 8 << 5);
        if (!segmented) {
            hdlcFrame.controlField = (byte)(hdlcFrame.controlField | 0x10);
        }
        return hdlcFrame;
    }

    public static HdlcFrame newReceiveReadyFrame(HdlcAddressPair addressPair, int receiveSeq, boolean poll) {
        HdlcFrame hdlcFrame = new HdlcFrame(addressPair, FrameType.RECEIVE_READY);
        hdlcFrame.segmented = false;
        hdlcFrame.controlField = hdlcFrame.frameType.value();
        hdlcFrame.controlField = (byte)(hdlcFrame.controlField | receiveSeq % 8 << 5);
        if (poll) {
            hdlcFrame.controlField = (byte)(hdlcFrame.controlField | 0x10);
        }
        return hdlcFrame;
    }

    public static HdlcFrame newSetNormalResponseModeFrame(HdlcAddressPair addressPair, HdlcParameters negotiationParams, boolean poll) {
        byte[] info = null;
        if (negotiationParams != null) {
            info = negotiationParams.encode();
        }
        HdlcFrame hdlcFrame = new HdlcFrame(addressPair, FrameType.SET_NORMAL_RESPONSEMODE, info);
        hdlcFrame.segmented = false;
        hdlcFrame.controlField = hdlcFrame.frameType.value();
        if (poll) {
            hdlcFrame.controlField = (byte)(hdlcFrame.controlField | 0x10);
        }
        return hdlcFrame;
    }

    public static HdlcFrame newUnnumberedInformationFrame(HdlcAddressPair addressPair, byte[] information, boolean poll) {
        HdlcFrame hdlcFrame = new HdlcFrame(addressPair, FrameType.UNNUMBERED_INFORMATION, information);
        hdlcFrame.segmented = false;
        hdlcFrame.controlField = hdlcFrame.frameType.value();
        if (poll) {
            hdlcFrame.controlField = (byte)(hdlcFrame.controlField | 0x10);
        }
        return hdlcFrame;
    }

    public static HdlcFrame newDisconnectFrame(HdlcAddressPair addressPair, boolean poll) {
        HdlcFrame hdlcFrame = new HdlcFrame(addressPair, FrameType.DISCONNECT);
        hdlcFrame.controlField = hdlcFrame.frameType.value();
        if (poll) {
            hdlcFrame.controlField = (byte)(hdlcFrame.controlField | 0x10);
        }
        return hdlcFrame;
    }

    public static HdlcFrame newReceiveNotReadyFrame(HdlcAddressPair addressPair, int receiveSeq, boolean poll) {
        HdlcFrame hdlcFrame = new HdlcFrame(addressPair, FrameType.RECEIVE_NOT_READY);
        hdlcFrame.segmented = false;
        hdlcFrame.controlField = hdlcFrame.frameType.value();
        hdlcFrame.controlField = (byte)(hdlcFrame.controlField | receiveSeq % 8 << 5);
        if (poll) {
            hdlcFrame.controlField = (byte)(hdlcFrame.controlField | 0x10);
        }
        return hdlcFrame;
    }

    public static HdlcFrame newUnnumberedAcknowledgeFrame(HdlcAddressPair addressPair, HdlcParameters negotiationParams, boolean poll) throws IOException {
        byte[] info = negotiationParams != null ? negotiationParams.encode() : new byte[]{};
        HdlcFrame hdlcFrame = new HdlcFrame(addressPair, FrameType.UNNUMBERED_ACKNOWLEDGE, info);
        hdlcFrame.segmented = false;
        hdlcFrame.controlField = hdlcFrame.frameType.value();
        if (poll) {
            hdlcFrame.controlField = (byte)(hdlcFrame.controlField | 0x10);
        }
        return hdlcFrame;
    }

    public static HdlcFrame newDisconnectModeFrame(HdlcAddressPair addressPair, byte[] information, boolean poll) {
        HdlcFrame hdlcFrame = new HdlcFrame(addressPair, FrameType.DISCONNECT_MODE, information);
        hdlcFrame.segmented = false;
        hdlcFrame.controlField = hdlcFrame.frameType.value();
        if (poll) {
            hdlcFrame.controlField = (byte)(hdlcFrame.controlField | 0x10);
        }
        return hdlcFrame;
    }

    public static HdlcFrame newFrameRejectFrame(HdlcAddressPair addressPair, FrameRejectReason reason, boolean poll) {
        HdlcFrame hdlcFrame = new HdlcFrame(addressPair, FrameType.FRAME_REJECT, reason.encode());
        hdlcFrame.segmented = false;
        hdlcFrame.controlField = hdlcFrame.frameType.value();
        if (poll) {
            hdlcFrame.controlField = (byte)(hdlcFrame.controlField | 0x10);
        }
        return hdlcFrame;
    }

    public HdlcAddress getDestinationAddress() {
        return this.addressPair.destination();
    }

    public HdlcAddress getSourceAddress() {
        return this.addressPair.source();
    }

    public HdlcAddressPair getAddressPair() {
        return this.addressPair;
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public byte[] getInformationField() {
        return this.informationField;
    }

    public byte[] getInformationFieldWithoutLlc() {
        if (this.hasInformationField() && this.informationField.length > 0) {
            return Arrays.copyOfRange(this.informationField, LLC_REQUEST.length, this.informationField.length);
        }
        return this.informationField;
    }

    public int getLength() {
        return this.length;
    }

    public int getSendSequence() {
        return this.sendSequence;
    }

    public int getReceiveSequence() {
        return this.receiveSequence;
    }

    public boolean isSegmented() {
        return this.segmented;
    }

    public byte[] encode() {
        byte[] data = this.encodeWithoutFlags();
        return ByteBuffer.allocate(data.length + 2).put((byte)126).put(data).put((byte)126).array();
    }

    public byte[] encodeWithoutFlags() {
        ByteBuffer codeBuffer = ByteBuffer.allocate(this.length);
        short frameFormat = (short)(0xA000 | this.length);
        if (this.segmented) {
            frameFormat = (short)(frameFormat | 0x800);
        }
        codeBuffer.putShort(frameFormat);
        codeBuffer.put(this.getDestinationAddress().encode());
        codeBuffer.put(this.getSourceAddress().encode());
        codeBuffer.put(this.controlField);
        FcsCalc fcsCalc = new FcsCalc();
        fcsCalc.update(codeBuffer.array(), codeBuffer.position());
        codeBuffer.put(fcsCalc.fcsValueInBytes());
        if (this.hasInformationField()) {
            fcsCalc.update(fcsCalc.fcsValueInBytes());
            codeBuffer.put(this.informationField);
            fcsCalc.update(this.informationField);
            codeBuffer.put(fcsCalc.fcsValueInBytes());
        }
        return codeBuffer.array();
    }

    private boolean hasInformationField() {
        return this.informationField != null;
    }

    static {
        byte destinationLsap = -26;
        byte sourceLsap = -26;
        byte quality = 0;
        LLC_REQUEST = new byte[]{destinationLsap, sourceLsap, quality};
    }
}

