/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class HdlcMessageQueue
implements Iterable<byte[]> {
    private BlockingQueue<HdlcMessage> sendQueue;
    private int capacity;

    public HdlcMessageQueue(int capacity) {
        this.sendQueue = new ArrayBlockingQueue<HdlcMessage>(capacity);
        this.capacity = capacity;
    }

    public void reszize(int newSize) {
        BlockingQueue<HdlcMessage> oldQueue = this.sendQueue;
        this.sendQueue = new ArrayBlockingQueue<HdlcMessage>(newSize);
        this.sendQueue.addAll(oldQueue);
        this.capacity = newSize;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void clearTil(int sendSeq) {
        while (!this.sendQueue.isEmpty() && ((HdlcMessage)this.sendQueue.poll()).sequenceCounter < sendSeq) {
        }
    }

    public int size() {
        return this.sendQueue.size();
    }

    public void clear() {
        this.sendQueue.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void offerMessage(byte[] dataToSend, int sendSequence) {
        HdlcMessage newHdlcMessage = new HdlcMessage(dataToSend, sendSequence);
        try {
            if (this.sendQueue.offer(newHdlcMessage, 10L, TimeUnit.SECONDS)) return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new ByteArrayIter();
    }

    private class ByteArrayIter
    implements Iterator<byte[]> {
        private final Iterator<HdlcMessage> iterator;

        public ByteArrayIter() {
            this.iterator = HdlcMessageQueue.this.sendQueue.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public byte[] next() {
            return this.iterator.next().data();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private class HdlcMessage {
        private final byte[] data;
        private final int sequenceCounter;

        public HdlcMessage(byte[] data, int sequenceCounter) {
            this.data = data;
            this.sequenceCounter = sequenceCounter;
        }

        public byte[] data() {
            return this.data;
        }
    }
}

