/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.transportlayer.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.openmuc.jdlms.settings.client.TcpSettings;
import org.openmuc.jdlms.transportlayer.client.TransportLayer;

public class UdpLayer
implements TransportLayer {
    public static final int MAX_UDP_PAYLOAD_SIZE = 65507;
    private final TcpSettings settings;
    private DatagramSocket socket;
    private boolean closed;
    private IStream inputStream;
    private OStream outputStream;

    public UdpLayer(TcpSettings settings) {
        this.settings = settings;
        this.closed = true;
    }

    @Override
    public void open() throws IOException {
        this.socket = new DatagramSocket();
        this.closed = false;
        this.inputStream = new IStream();
        this.outputStream = new OStream();
    }

    @Override
    public void setTimeout(int timeout) throws IOException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public DataInputStream getInputStream() throws IOException {
        return new DataInputStream(this.inputStream);
    }

    @Override
    public DataOutputStream getOutpuStream() throws IOException {
        return new DataOutputStream(this.outputStream);
    }

    @Override
    public void close() throws IOException {
        try {
            this.socket.close();
            this.inputStream.closeStream();
            this.outputStream.closeStream();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private class IStream
    extends InputStream {
        private InputStream is = new ByteArrayInputStream(new byte[0]);
        private final Object lock = new Object();

        public void closeStream() throws IOException {
            this.is.close();
        }

        @Override
        public void close() throws IOException {
            UdpLayer.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            this.readIfEmpty();
            Object object = this.lock;
            synchronized (object) {
                return this.is.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readIfEmpty() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.is.available() == 0) {
                    this.readNextPacket();
                }
            }
        }

        @Override
        public int available() throws IOException {
            this.readIfEmpty();
            return this.is.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                this.readIfEmpty();
            }
            catch (IOException e) {
                return 0;
            }
            int remaining = len;
            while (true) {
                DatagramSocket datagramSocket = UdpLayer.this.socket;
                synchronized (datagramSocket) {
                    remaining -= this.is.read(b, len - remaining, Math.min(this.is.available(), remaining));
                }
                if (remaining == 0) {
                    return len;
                }
                try {
                    this.readIfEmpty();
                }
                catch (IOException e) {
                    return len - remaining;
                }
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void readNextPacket() throws IOException {
            byte[] buf = new byte[65507];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            UdpLayer.this.socket.receive(packet);
            InetAddress address = packet.getAddress();
            int port = packet.getPort();
            if (!address.equals(UdpLayer.this.settings.inetAddress()) || port != UdpLayer.this.settings.port()) {
                this.readNextPacket();
                return;
            }
            int len = packet.getLength();
            byte[] data = packet.getData();
            Object object = this.lock;
            synchronized (object) {
                this.is = new ByteArrayInputStream(data, 0, len);
            }
        }
    }

    private class OStream
    extends OutputStream {
        private final ByteArrayOutputStream os = new ByteArrayOutputStream(65507);

        public void closeStream() throws IOException {
            this.os.close();
        }

        @Override
        public void close() throws IOException {
            UdpLayer.this.close();
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
            if (this.os.size() == 65507) {
                this.flush();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int remaining = len;
            while (true) {
                int newLen;
                if ((newLen = Math.min(len, 65507 - this.os.size())) != 0) {
                    this.os.write(b, off + (len - remaining), newLen);
                    remaining -= newLen;
                }
                if (remaining == 0) break;
                this.flush();
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.os.size() == 0) {
                return;
            }
            byte[] data = this.os.toByteArray();
            this.os.reset();
            DatagramPacket packet = new DatagramPacket(data, 0, data.length, UdpLayer.this.settings.inetAddress(), UdpLayer.this.settings.port());
            UdpLayer.this.socket.send(packet);
        }
    }
}

