/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.IOException;
import java.text.MessageFormat;

public abstract class JDlmsException
extends IOException {
    private static final long serialVersionUID = -1656925204526742049L;
    private final ExceptionId exceptionId;
    private final Fault assumedFault;

    public JDlmsException(ExceptionId exceptionId, Fault assumedFault, String message) {
        this(exceptionId, assumedFault, message, null);
    }

    public JDlmsException(ExceptionId exceptionId, Fault assumedFault, String message, Throwable cause) {
        super(message, cause);
        this.exceptionId = exceptionId;
        this.assumedFault = assumedFault;
    }

    @Override
    public String getMessage() {
        return MessageFormat.format("{0}: {2} Assumed fault: {1}.", this.exceptionId.name(), this.assumedFault.name().toLowerCase(), super.getMessage());
    }

    public ExceptionId getExceptionId() {
        return this.exceptionId;
    }

    public Fault getAssumedFault() {
        return this.assumedFault;
    }

    public static enum ExceptionId {
        CONNECTION_ESTABLISH_ERROR,
        ILLEGAL_RESPONSE,
        AUTHENTICATION_ERROR,
        AUTHENTICATION_REQUIRED,
        WRONG_REFERENCING_METHOD,
        UNKNOWN,
        RESPONSE_TIMEOUT,
        CONNECTION_ALREADY_CLOSED,
        CONNECTION_CLOSED,
        CONNECTION_DISCONNECT_ERROR,
        UNKNOWN_ASSOCIATION_RESULT,
        GET_REQUEST_TOO_LARGE,
        JRXTX_NO_SUCH_PORT,
        JRXTX_PORT_IN_USE,
        JRXTX_PORT_NOT_SERIAL,
        JRXTX_INCOMPATIBLE_TO_OS,
        WRAPPER_HEADER_INVALID,
        WRAPPER_HEADER_INVALID_VERSION,
        WRAPPER_HEADER_INVALID_SRC_DEST_ADDR,
        WRAPPER_HEADER_INVALID_PAYLOAD_LENGTH,
        HDLC_MSG_INVALID_FLAG,
        HDLC_CONNECTION_ESTABLISH_ERROR,
        HDLC_CONNECTION_CLOSE_ERROR,
        HDLC_SEND_FRAME_SIZE_EXCEEDED,
        HDLC_KEY_PAIR_ERR,
        IEC_21_UNKNOWN_ACK_MSG,
        IEC_21_WRONG_BAUD_RATE_CHANGE_DELAY,
        IEC_21_CONNECTION_ESTABLISH_ERROR;

    }

    public static enum Fault {
        USER,
        SYSTEM;

    }
}

