/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.util.Map;
import org.openmuc.jdlms.AuthenticationMechanism;
import org.openmuc.jdlms.SecuritySuiteImpl;
import org.openmuc.jdlms.datatypes.DlmsEnumeration;
import org.openmuc.jdlms.internal.DlmsEnumFunctions;

public class SecuritySuite {
    byte[] globalUnicastEncryptionKey;
    byte[] authenticationKey;
    byte[] password;
    private final EncryptionMechanism encryptionMechanism;
    private final AuthenticationMechanism authenticationMechanism;
    private final SecurityPolicy securityPolicy;

    SecuritySuite(byte[] globalUnicastEncryptionKey, byte[] authenticationKey, byte[] password, EncryptionMechanism cryptographicAlgorithm, AuthenticationMechanism authenticationLevel, SecurityPolicy securityPolicy) {
        this.globalUnicastEncryptionKey = globalUnicastEncryptionKey;
        this.authenticationKey = authenticationKey;
        this.password = password;
        this.encryptionMechanism = cryptographicAlgorithm;
        this.authenticationMechanism = authenticationLevel;
        this.securityPolicy = securityPolicy;
    }

    public byte[] getGlobalUnicastEncryptionKey() {
        return this.globalUnicastEncryptionKey;
    }

    public byte[] getAuthenticationKey() {
        return this.authenticationKey;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public EncryptionMechanism getEncryptionMechanism() {
        return this.encryptionMechanism;
    }

    public AuthenticationMechanism getAuthenticationMechanism() {
        return this.authenticationMechanism;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public static SecuritySuiteBuilder builder() {
        return new SecuritySuiteBuilder();
    }

    private static byte[] saveArrayClone(byte[] data) {
        return data != null ? (byte[])data.clone() : null;
    }

    public static SecuritySuite newSecuritySuiteFrom(SecuritySuite securitySuite) {
        return new SecuritySuiteImpl(SecuritySuite.saveArrayClone(securitySuite.globalUnicastEncryptionKey), SecuritySuite.saveArrayClone(securitySuite.authenticationKey), SecuritySuite.saveArrayClone(securitySuite.password), securitySuite.encryptionMechanism, securitySuite.authenticationMechanism, securitySuite.securityPolicy);
    }

    public static enum EncryptionMechanism implements DlmsEnumeration
    {
        NONE(-1, -1),
        AES_GCM_128(0, 128),
        AES_GCM_256(1, 256);

        private final int id;
        private final int keyLength;
        private static final Map<Long, EncryptionMechanism> idMap;

        private EncryptionMechanism(int id, int keyLength) {
            this.id = id;
            this.keyLength = keyLength;
        }

        private void checkKeyLength(byte[] encryptionKey, byte[] authenticationKey) {
            if (this == NONE) {
                return;
            }
            if (encryptionKey == null) {
                throw new IllegalArgumentException("The key is not allowed to be null.");
            }
            if (authenticationKey != null && authenticationKey.length != encryptionKey.length) {
                throw new IllegalArgumentException("Authentication key length does not match encryption key length.");
            }
            if (encryptionKey.length * 8 != this.keyLength) {
                throw new IllegalArgumentException("The key has an invalid length.");
            }
        }

        @Override
        public long getCode() {
            return this.id;
        }

        public static EncryptionMechanism getInstance(long id) {
            EncryptionMechanism enumInstance = idMap.get(id);
            if (enumInstance == null) {
                throw new IllegalArgumentException("invalid ID: " + id);
            }
            return enumInstance;
        }

        static {
            idMap = DlmsEnumFunctions.generateEnumMap(EncryptionMechanism.class);
        }
    }

    public static enum SecurityPolicy {
        NOTHING(0),
        AUTHENTICATED(1),
        ENCRYPTED(2),
        AUTHENTICATED_AND_ENCRYPTED(3);

        private final int id;

        private SecurityPolicy(int id) {
            this.id = id;
        }

        public String keyName() {
            return this.name();
        }

        public boolean isAuthenticated() {
            return this == AUTHENTICATED || this == AUTHENTICATED_AND_ENCRYPTED;
        }

        public boolean isEncrypted() {
            return this == ENCRYPTED || this == AUTHENTICATED_AND_ENCRYPTED;
        }

        public int getId() {
            return this.id;
        }
    }

    public static class SecuritySuiteBuilder {
        private AuthenticationMechanism authenticationMechanism = AuthenticationMechanism.NONE;
        private EncryptionMechanism encryptionMechanism = EncryptionMechanism.NONE;
        private byte[] globalUnicastEncryptionKey = null;
        private byte[] authenticationKey = null;
        private byte[] password = null;
        private SecurityPolicy securityPolicy;

        private SecuritySuiteBuilder() {
        }

        public SecuritySuiteBuilder setSecurityPolicy(SecurityPolicy securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        public SecuritySuiteBuilder setEncryptionMechanism(EncryptionMechanism encryptionMechanism) {
            if (encryptionMechanism == null) {
                throw new IllegalArgumentException("The cryptographic algorithm is not allowed to be null!");
            }
            this.encryptionMechanism = encryptionMechanism;
            return this;
        }

        public SecuritySuiteBuilder setAuthenticationMechanism(AuthenticationMechanism authenticationMechanism) {
            if (authenticationMechanism == null) {
                throw new IllegalArgumentException("The authentication mechanism is not allowed to be null!");
            }
            this.authenticationMechanism = authenticationMechanism;
            return this;
        }

        public SecuritySuiteBuilder setGlobalUnicastEncryptionKey(byte[] key) {
            this.globalUnicastEncryptionKey = key;
            return this;
        }

        public SecuritySuiteBuilder setPassword(byte[] password) {
            this.password = password;
            return this;
        }

        public SecuritySuiteBuilder setAuthenticationKey(byte[] key) {
            this.authenticationKey = key;
            return this;
        }

        public SecuritySuite build() {
            if (this.securityPolicy == null) {
                this.securityPolicy = this.authenticationMechanism.isHlsMechanism() || this.authenticationMechanism == AuthenticationMechanism.LOW && this.authenticationKey != null ? (this.encryptionMechanism != EncryptionMechanism.NONE ? SecurityPolicy.AUTHENTICATED_AND_ENCRYPTED : SecurityPolicy.AUTHENTICATED) : (this.encryptionMechanism != EncryptionMechanism.NONE ? SecurityPolicy.ENCRYPTED : SecurityPolicy.NOTHING);
            }
            this.validateFields();
            return new SecuritySuiteImpl(SecuritySuite.saveArrayClone(this.globalUnicastEncryptionKey), SecuritySuite.saveArrayClone(this.authenticationKey), SecuritySuite.saveArrayClone(this.password), this.encryptionMechanism, this.authenticationMechanism, this.securityPolicy);
        }

        private void validateFields() {
            this.validateSecurityPolicy();
            this.encryptionMechanism.checkKeyLength(this.globalUnicastEncryptionKey, this.authenticationKey);
            switch (this.authenticationMechanism) {
                case HLS5_GMAC: {
                    if (this.authenticationKey != null && this.globalUnicastEncryptionKey != null && this.globalUnicastEncryptionKey.length == this.authenticationKey.length) break;
                    throw new IllegalArgumentException("Authentication/Encryption key either not supplied or don't match in length.");
                }
                case LOW: {
                    if (this.password != null) break;
                    throw new IllegalArgumentException("Password is not set for the security level low.");
                }
            }
        }

        private void validateSecurityPolicy() {
            if ((this.securityPolicy == SecurityPolicy.ENCRYPTED || this.securityPolicy == SecurityPolicy.AUTHENTICATED_AND_ENCRYPTED) && this.encryptionMechanism == EncryptionMechanism.NONE) {
                throw new IllegalArgumentException("Select a cryptographical algorithm to encrypt messages.");
            }
            if (!(this.securityPolicy != SecurityPolicy.AUTHENTICATED && this.securityPolicy != SecurityPolicy.AUTHENTICATED_AND_ENCRYPTED || this.authenticationMechanism.isHlsMechanism() || this.authenticationMechanism == AuthenticationMechanism.LOW && this.authenticationKey != null)) {
                throw new IllegalArgumentException("Select an LLS or HLS authentication, to authenticate messages.");
            }
        }
    }
}

