/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import org.openmuc.jdlms.datatypes.CosemDateFormat;

public class CosemDate
implements CosemDateFormat {
    private static final int NOT_SPECIFIED = 255;
    static final int LENGTH = 5;
    private static final int DAYLIGHT_SAVINGS_END = 253;
    private static final int DAYLIGHT_SAVINGS_BEGIN = 254;
    private static final int LAST_DAY_OF_MONTH = 254;
    private static final int SECOND_LAST_DAY_OF_MONTH = 253;
    private byte[] octetString;

    public CosemDate(int year, int month, int dayOfMonth) {
        this(year, month, dayOfMonth, 255);
    }

    public CosemDate(int year, Month month, int dayOfMonth) {
        this(year, month.value, dayOfMonth, 255);
    }

    public CosemDate(int year, int month, int dayOfMonth, int dayOfWeek) {
        CosemDate.verifyYear(year);
        CosemDate.verifyMonth(month);
        CosemDate.verifyDayOfWeek(dayOfWeek);
        CosemDate.verifyDayOfMonth(dayOfMonth);
        this.init(year, month, dayOfMonth, dayOfWeek);
    }

    private void init(int year, int month, int dayOfMonth, int dayOfWeek) {
        this.octetString = new byte[this.length()];
        this.octetString[0] = (byte)((year & 0xFF00) >> 8);
        this.octetString[1] = (byte)(year & 0xFF);
        this.octetString[2] = (byte)(month & 0xFF);
        this.octetString[3] = (byte)(dayOfMonth & 0xFF);
        this.octetString[4] = (byte)(dayOfWeek & 0xFF);
    }

    private CosemDate(byte[] octetString) {
        this.octetString = octetString;
    }

    public static CosemDate decode(InputStream stream) throws IOException {
        byte[] octetString = new byte[5];
        if (stream.read(octetString) != 5) {
            throw new IOException("Stream was too short.");
        }
        return CosemDate.decode(octetString);
    }

    public static CosemDate decode(byte[] octetString) {
        if (octetString.length != 5) {
            throw new IllegalArgumentException("Wrong size.");
        }
        return new CosemDate(octetString);
    }

    private static void verifyYear(int year) {
        if (year < 0 || year > 65535) {
            throw new IllegalArgumentException("Parameter year is out of range [0, 0xffff]");
        }
    }

    private static void verifyMonth(int month) {
        boolean monthTooLarge;
        boolean monthTooSmall = month < 1;
        boolean isNotStatusFlag = month != 253 && month != 254 && month != 255;
        boolean bl = monthTooLarge = month > 12 && isNotStatusFlag;
        if (monthTooSmall || monthTooLarge) {
            throw new IllegalArgumentException("Parameter month is out of range.");
        }
    }

    private static void verifyDayOfMonth(int dayOfMonth) {
        boolean isNotStatusFlag;
        boolean monthTooSmall = dayOfMonth < 1;
        boolean montTooLarge = dayOfMonth > 31;
        boolean bl = isNotStatusFlag = dayOfMonth != 253 && dayOfMonth != 254 && dayOfMonth != 255;
        if (monthTooSmall || montTooLarge && isNotStatusFlag) {
            throw new IllegalArgumentException("Parameter day of month is out of range.");
        }
    }

    private static void verifyDayOfWeek(int dayOfWeek) {
        if (dayOfWeek < 1 || dayOfWeek > 7 && dayOfWeek != 255) {
            throw new IllegalArgumentException("Parameter day of week is out of range.");
        }
    }

    @Override
    public byte[] encode() {
        return Arrays.copyOf(this.octetString, this.length());
    }

    void initCalendar(Calendar calendar) {
        int month;
        int year = this.get(CosemDateFormat.Field.YEAR);
        if (year != 65535) {
            calendar.set(1, year);
        }
        if ((month = this.get(CosemDateFormat.Field.MONTH)) != 255) {
            calendar.set(2, month - 1);
        }
        int dayOfMonth = this.get(CosemDateFormat.Field.DAY_OF_MONTH);
        int dayOfWeek = this.get(CosemDateFormat.Field.DAY_OF_WEEK);
        if (dayOfMonth == 254) {
            if (dayOfWeek == 255) {
                this.dayOfMonthToLastDay(calendar);
            } else {
                this.lastWeekDayInMonth(calendar, dayOfWeek);
            }
        } else if (dayOfMonth == 253) {
            dayOfMonth = this.lastDayOfMonth(calendar) - 1;
            calendar.set(5, dayOfMonth);
        } else {
            calendar.set(5, dayOfMonth);
        }
    }

    private void lastWeekDayInMonth(Calendar calendar, int dayOfWeek) {
        calendar.set(7, dayOfWeek + 1);
        calendar.set(8, -1);
    }

    private void dayOfMonthToLastDay(Calendar calendar) {
        int dayOfMonth = this.lastDayOfMonth(calendar);
        calendar.set(5, dayOfMonth);
    }

    private int lastDayOfMonth(Calendar calendar) {
        return calendar.getActualMaximum(5);
    }

    @Override
    public int length() {
        return 5;
    }

    @Override
    public int get(CosemDateFormat.Field field) {
        switch (field) {
            case YEAR: {
                int year = this.octetString[0] << 8;
                return year |= this.octetString[1] & 0xFF;
            }
            case MONTH: {
                return this.octetString[2] & 0xFF;
            }
            case DAY_OF_MONTH: {
                return this.octetString[3] & 0xFF;
            }
            case DAY_OF_WEEK: {
                return this.octetString[4] & 0xFF;
            }
        }
        throw new IllegalArgumentException(String.format("Field %s found in %s.", field.name(), this.getClass().getSimpleName()));
    }

    public static enum Month {
        JANUARY(1),
        FEBRUARY(2),
        MARCH(3),
        APRIL(4),
        MAY(5),
        JUNE(6),
        JULY(7),
        AUGUST(8),
        SEPTEMBER(9),
        OCTOBER(10),
        NOVEMBER(11),
        DECEMBER(12);

        private int value;

        private Month(int value) {
            this.value = value;
        }
    }
}

