/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.openmuc.jdlms.AuthenticationMechanism;
import org.openmuc.jdlms.FatalJDlmsException;
import org.openmuc.jdlms.JDlmsException;
import org.openmuc.jdlms.RawMessageData;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.internal.AssociateSourceDiagnostic;
import org.openmuc.jdlms.internal.AssociationResult;
import org.openmuc.jdlms.internal.ContextId;
import org.openmuc.jdlms.internal.ObjectIdentifier;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrLength;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.ACSEApdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.AssociateSourceDiagnostic;
import org.openmuc.jdlms.internal.asn1.iso.acse.AssociationInformation;
import org.openmuc.jdlms.internal.association.AssociatRequestException;
import org.openmuc.jdlms.internal.security.crypto.GcmModule;

public class APdu {
    private static final SecuritySuite DEFAULT_SECURITY_SUITE = SecuritySuite.builder().build();
    private ACSEApdu acseAPdu;
    private COSEMpdu cosemPdu;

    private APdu() {
    }

    public APdu(ACSEApdu acseAPdu, COSEMpdu cosemPdu) {
        this.acseAPdu = acseAPdu;
        this.cosemPdu = cosemPdu;
    }

    public ACSEApdu getAcseAPdu() {
        return this.acseAPdu;
    }

    public COSEMpdu getCosemPdu() {
        return this.cosemPdu;
    }

    public static APdu decode(byte[] bytes, byte[] serverSystemTitle, SecuritySuite securitySuite, RawMessageData.RawMessageDataBuilder rawMessageBuilder) throws IOException {
        return APdu.decode(bytes, true, serverSystemTitle, securitySuite, rawMessageBuilder);
    }

    public static APdu decode(byte[] bytes, RawMessageData.RawMessageDataBuilder rawMessageBuilder) throws IOException {
        return APdu.decode(bytes, false, null, DEFAULT_SECURITY_SUITE, rawMessageBuilder);
    }

    public boolean isEncrypted() {
        switch (this.cosemPdu.getChoiceIndex()) {
            case GLO_ACTION_REQUEST: 
            case GLO_ACTION_RESPONSE: 
            case GLO_EVENT_NOTIFICATION_REQUEST: 
            case GLO_GET_REQUEST: 
            case GLO_GET_RESPONSE: 
            case GLO_INITIATEREQUEST: 
            case GLO_INITIATERESPONSE: 
            case GLO_READREQUEST: 
            case GLO_READRESPONSE: 
            case GLO_SET_REQUEST: 
            case GLO_SET_RESPONSE: 
            case GLO_WRITEREQUEST: 
            case GLO_WRITERESPONSE: 
            case DED_ACTIONREQUEST: 
            case DED_ACTION_RESPONSE: 
            case DED_EVENT_NOTIFICATION_REQUEST: 
            case DED_GET_REQUEST: 
            case DED_GET_RESPONSE: 
            case DED_SET_REQUEST: 
            case DED_SET_RESPONSE: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static APdu decode(byte[] bytes, boolean encrypt, byte[] provServerSysT, SecuritySuite securitySuite, RawMessageData.RawMessageDataBuilder rawMessageBuilder) throws IOException {
        try (DataInputStream is = new DataInputStream(new ByteArrayInputStream(bytes));){
            int size;
            APdu aPdu = new APdu();
            byte[] serverSysT = provServerSysT;
            int tag = bytes[0] & 0xFF;
            if (tag >= 96 && tag <= 99) {
                Object contextId;
                ACSEApdu acseAPdu;
                aPdu.acseAPdu = acseAPdu = new ACSEApdu();
                acseAPdu.decode(is, null);
                APdu.validateAssociateResult(aPdu);
                is = APdu.setupInputStream(is, acseAPdu);
                if (encrypt) {
                    if (acseAPdu.getAare() != null && acseAPdu.getAare().getRespondingAPTitle() != null) {
                        serverSysT = acseAPdu.getAare().getRespondingAPTitle().getApTitleForm2().value;
                    } else if (acseAPdu.getAarq() != null) {
                        contextId = ObjectIdentifier.applicationContextIdFrom(acseAPdu.getAarq().getApplicationContextName());
                        if (!((ContextId)((Object)contextId)).isCiphered() && securitySuite.getAuthenticationMechanism() != AuthenticationMechanism.LOW) {
                            throw new AssociatRequestException(AssociateSourceDiagnostic.AcseServiceUser.APPLICATION_CONTEXT_NAME_NOT_SUPPORTED);
                        }
                        if (acseAPdu.getAarq().getCallingAPTitle() != null) {
                            serverSysT = acseAPdu.getAarq().getCallingAPTitle().getApTitleForm2().value;
                        }
                    }
                }
                if (acseAPdu.getRlrq() != null || acseAPdu.getRlre() != null) {
                    contextId = aPdu;
                    return contextId;
                }
            }
            byte[] ciphertext = null;
            byte[] plaintext = null;
            InputStream cosemPduIs = is;
            if (encrypt && (tag != 96 || securitySuite.getAuthenticationMechanism() != AuthenticationMechanism.LOW)) {
                is.read();
                AxdrLength axdrLength = new AxdrLength();
                axdrLength.decode(is);
                int encLength = axdrLength.getValue();
                ciphertext = new byte[encLength];
                is.readFully(ciphertext);
                plaintext = GcmModule.decrypt(ciphertext, serverSysT, securitySuite);
                cosemPduIs = new ByteArrayInputStream(plaintext);
            }
            if ((size = ((InputStream)cosemPduIs).available()) > 0) {
                aPdu.cosemPdu = new COSEMpdu();
                aPdu.cosemPdu.decode(cosemPduIs);
            }
            APdu.setDataToBuilder(aPdu, rawMessageBuilder, ciphertext, plaintext);
            APdu aPdu2 = aPdu;
            return aPdu2;
        }
    }

    private static DataInputStream setupInputStream(DataInputStream is, ACSEApdu acseAPdu) throws IOException {
        if (acseAPdu.getAarq() != null) {
            return new DataInputStream(new ByteArrayInputStream(acseAPdu.getAarq().getUserInformation().value));
        }
        if (acseAPdu.getAare() != null) {
            byte[] userInfo = acseAPdu.getAare().getUserInformation().value;
            if (is.available() > 0) {
                byte[] remaining = new byte[is.available()];
                is.readFully(remaining);
                userInfo = ByteBuffer.allocate(userInfo.length + remaining.length).put(userInfo).put(remaining).array();
            }
            return new DataInputStream(new ByteArrayInputStream(userInfo));
        }
        return is;
    }

    private static void validateAssociateResult(APdu aPdu) throws FatalJDlmsException {
        JDlmsException.ExceptionId exceptionId;
        JDlmsException.Fault faut;
        ACSEApdu acseAPdu = aPdu.acseAPdu;
        if (acseAPdu.getAare() == null) {
            return;
        }
        AssociationResult associationResult = AssociationResult.associationResultFor(acseAPdu.getAare().getResult().value.longValue());
        if (associationResult == AssociationResult.ACCEPTED) {
            return;
        }
        AssociateSourceDiagnostic resultSourceDiagnostic = acseAPdu.getAare().getResultSourceDiagnostic();
        if (resultSourceDiagnostic.getAcseServiceUser() != null) {
            faut = JDlmsException.Fault.USER;
            AssociateSourceDiagnostic.AcseServiceUser serviceUser = AssociateSourceDiagnostic.AcseServiceUser.acseServiceUserFor(resultSourceDiagnostic.getAcseServiceUser().value.longValue());
            switch (serviceUser) {
                case APPLICATION_CONTEXT_NAME_NOT_SUPPORTED: {
                    exceptionId = JDlmsException.ExceptionId.WRONG_REFERENCING_METHOD;
                    break;
                }
                case AUTHENTICATION_FAILURE: 
                case AUTHENTICATION_MECHANISM_NAME_NOT_RECOGNISED: 
                case AUTHENTICATION_MECHANISM_NAME_REQUIRED: {
                    exceptionId = JDlmsException.ExceptionId.AUTHENTICATION_ERROR;
                    break;
                }
                case AUTHENTICATION_REQUIRED: {
                    exceptionId = JDlmsException.ExceptionId.AUTHENTICATION_REQUIRED;
                    break;
                }
                default: {
                    exceptionId = JDlmsException.ExceptionId.UNKNOWN;
                    break;
                }
            }
        } else {
            faut = JDlmsException.Fault.SYSTEM;
            AssociateSourceDiagnostic.AcseServiceProvider acseServiceProvider = AssociateSourceDiagnostic.AcseServiceProvider.acseServiceProviderFor(resultSourceDiagnostic.getAcseServiceProvider().value.longValue());
            switch (acseServiceProvider) {
                default: 
            }
            exceptionId = JDlmsException.ExceptionId.UNKNOWN;
        }
        String message = MessageFormat.format("Received an association response (AARE) with an error message. Result name {0}.", new Object[]{associationResult});
        throw new FatalJDlmsException(exceptionId, faut, message);
    }

    public int encode(byte[] buffer, long frameCounter, byte[] systemTitle, SecuritySuite securitySuite, RawMessageData.RawMessageDataBuilder rawMessageBuilder) throws IOException {
        ReverseByteArrayOutputStream baos = new ReverseByteArrayOutputStream(buffer, buffer.length - 1);
        int numBytesEncoded = this.encodeCosemPdu(baos);
        byte tag = (byte)this.mapCosemPduTypeToGloType();
        byte[] ciphertext = GcmModule.processPlain(buffer, buffer.length - numBytesEncoded, numBytesEncoded, systemTitle, frameCounter, securitySuite, tag);
        numBytesEncoded = ciphertext.length;
        System.arraycopy(ciphertext, 0, buffer, buffer.length - numBytesEncoded, ciphertext.length);
        baos = new ReverseByteArrayOutputStream(buffer, buffer.length - numBytesEncoded - 1);
        numBytesEncoded = this.encodeAcsePdu(numBytesEncoded, baos);
        APdu.setDataToBuilder(this, rawMessageBuilder, ciphertext, null);
        return numBytesEncoded;
    }

    private int mapCosemPduTypeToGloType() {
        int cosemPduType = this.cosemPdu.getChoiceIndex().getValue();
        if (cosemPduType <= COSEMpdu.Choices.INFORMATIONREPORTREQUEST.getValue()) {
            return cosemPduType + 32;
        }
        if (cosemPduType >= COSEMpdu.Choices.GET_REQUEST.getValue() && cosemPduType <= COSEMpdu.Choices.ACTION_RESPONSE.getValue()) {
            return cosemPduType + 8;
        }
        return cosemPduType;
    }

    public int encode(byte[] buffer, RawMessageData.RawMessageDataBuilder rawMessageBuilder) throws IOException {
        ReverseByteArrayOutputStream baos = new ReverseByteArrayOutputStream(buffer, buffer.length - 1);
        int numBytesEncoded = this.encodeCosemPdu(baos);
        numBytesEncoded = this.encodeAcsePdu(numBytesEncoded, baos);
        APdu.setDataToBuilder(this, rawMessageBuilder, null, null);
        return numBytesEncoded;
    }

    private int encodeCosemPdu(ReverseByteArrayOutputStream baos) throws IOException {
        return this.cosemPdu == null ? 0 : this.cosemPdu.encode(baos);
    }

    private static void setDataToBuilder(APdu apdu, RawMessageData.RawMessageDataBuilder rawMessageBuilder, byte[] ciphertext, byte[] provPlaintext) {
        if (rawMessageBuilder == null) {
            return;
        }
        byte[] plaintext = provPlaintext;
        try {
            if (provPlaintext == null && apdu.cosemPdu != null) {
                ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(50, true);
                apdu.cosemPdu.encode(axdrOStream);
                plaintext = axdrOStream.getArray();
            }
            byte[] acseAPduData = null;
            if (apdu.acseAPdu != null) {
                try (ReverseByteArrayOutputStream axdrOStream2 = new ReverseByteArrayOutputStream(50, true);){
                    apdu.acseAPdu.encode((OutputStream)axdrOStream2);
                    acseAPduData = axdrOStream2.getArray();
                }
            }
            RawMessageData.CosemPdu rawCosemPdu = null;
            if (apdu.cosemPdu != null) {
                rawCosemPdu = new RawMessageData.CosemPdu(ciphertext, plaintext);
            }
            RawMessageData.Apdu rawApdu = new RawMessageData.Apdu(rawCosemPdu, acseAPduData);
            rawMessageBuilder.setApdu(rawApdu);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int encodeAcsePdu(int numBytesEncoded, ReverseByteArrayOutputStream baos) throws IOException {
        if (this.acseAPdu == null) {
            return numBytesEncoded;
        }
        if (this.acseAPdu.getAarq() != null) {
            this.acseAPdu.getAarq().setUserInformation(new AssociationInformation(baos.getArray()));
        } else if (this.acseAPdu.getAare() != null) {
            this.acseAPdu.getAare().setUserInformation(new AssociationInformation(baos.getArray()));
        }
        baos.reset();
        return this.acseAPdu.encode((OutputStream)baos);
    }

    public String toString() {
        return "ACSE PDU: " + this.acseAPdu + ", " + "COSEM xDLMS PDU:" + this.cosemPdu;
    }
}

