/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.axdr;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class AxdrLength {
    private int length;

    public AxdrLength() {
    }

    public AxdrLength(int length) {
        this.length = length;
    }

    public static int encodeLength(ReverseByteArrayOutputStream axdrOStream, int length) throws IOException {
        int codeLength = 0;
        if (length == 0) {
            axdrOStream.write(0);
            ++codeLength;
        } else {
            int lengthOfLength = 0;
            int i = 0;
            while (length >> 8 * i != 0) {
                axdrOStream.write(length >> 8 * i & 0xFF);
                ++lengthOfLength;
                ++codeLength;
                ++i;
            }
            if (length >= 128) {
                axdrOStream.write((byte)(lengthOfLength & 0xFF | 0x80));
                ++codeLength;
            }
        }
        return codeLength;
    }

    public static byte[] encodeLength(int length) {
        byte[] buffer;
        if (length == 0) {
            return new byte[]{0};
        }
        int lengthOfLength = 1;
        while (length >> 8 * lengthOfLength != 0) {
            ++lengthOfLength;
        }
        int offset = 0;
        if (length >= 128) {
            buffer = new byte[lengthOfLength + 1];
            buffer[0] = (byte)(lengthOfLength | 0x80);
            ++offset;
        } else {
            buffer = new byte[lengthOfLength];
        }
        for (int i = 0; i < lengthOfLength; ++i) {
            buffer[offset + i] = (byte)(length >> 8 * (lengthOfLength - 1 - i));
        }
        return buffer;
    }

    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        return AxdrLength.encodeLength(axdrOStream, this.length);
    }

    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.length = iStream.read();
        ++codeLength;
        if ((this.length & 0x80) == 128) {
            int encodedLength = this.length ^ 0x80;
            codeLength += encodedLength;
            this.length = 0;
            byte[] byteCode = new byte[encodedLength];
            if (iStream.read(byteCode, 0, encodedLength) < encodedLength) {
                throw new IOException("Error Decoding AxdrLength");
            }
            for (int i = 0; i < encodedLength; ++i) {
                this.length |= (byteCode[i] & 0xFF) << 8 * (encodedLength - i - 1);
            }
        }
        return codeLength;
    }

    public int getValue() {
        return this.length;
    }
}

