/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.axdr.types;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrLength;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;

public class AxdrOctetString
implements AxdrType {
    private byte[] octetString = new byte[0];
    private int length = 0;

    public AxdrOctetString() {
    }

    public AxdrOctetString(int length) {
        this.length = length;
        this.octetString = new byte[length];
    }

    public AxdrOctetString(byte[] octetString) {
        if (octetString != null) {
            this.octetString = octetString;
        }
    }

    public AxdrOctetString(int length, byte[] octetString) {
        if (length != 0 && length != octetString.length) {
            throw new IllegalArgumentException("octetString of wrong size");
        }
        this.length = length;
        this.octetString = octetString;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength = 0;
        axdrOStream.write(this.octetString);
        codeLength = this.octetString.length;
        if (this.length == 0) {
            AxdrLength codelength = new AxdrLength(this.octetString.length);
            codeLength += codelength.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        int len = this.length;
        if (len == 0) {
            AxdrLength l = new AxdrLength();
            codeLength += l.decode(iStream);
            len = l.getValue();
            this.octetString = new byte[len];
        }
        if (len != 0) {
            if (iStream.read(this.octetString, 0, len) < len) {
                throw new IOException("Error Decoding AxdrOctetString");
            }
            codeLength += len;
        }
        return codeLength;
    }

    public byte[] getValue() {
        return this.octetString;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (byte element : this.octetString) {
            String hexString = Integer.toHexString(element & 0xFF);
            if (hexString.length() == 1) {
                builder.append('0');
            }
            builder.append(hexString);
        }
        return builder.toString();
    }
}

