/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.ServiceError;

public class ConfirmedServiceError
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public ServiceError initiateError = null;
    public ServiceError getStatus = null;
    public ServiceError getNameList = null;
    public ServiceError getVariableAttribute = null;
    public ServiceError read = null;
    public ServiceError write = null;
    public ServiceError getDataSetAttribute = null;
    public ServiceError getTIAttribute = null;
    public ServiceError changeScope = null;
    public ServiceError start = null;
    public ServiceError stop = null;
    public ServiceError resume = null;
    public ServiceError makeUsable = null;
    public ServiceError initiateLoad = null;
    public ServiceError loadSegment = null;
    public ServiceError terminateLoad = null;
    public ServiceError initiateUpLoad = null;
    public ServiceError upLoadSegment = null;
    public ServiceError terminateUpLoad = null;

    public ConfirmedServiceError() {
    }

    public ConfirmedServiceError(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.TERMINATEUPLOAD) {
            codeLength += this.terminateUpLoad.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(19L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.UPLOADSEGMENT) {
            codeLength += this.upLoadSegment.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(18L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.INITIATEUPLOAD) {
            codeLength += this.initiateUpLoad.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(17L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.TERMINATELOAD) {
            codeLength += this.terminateLoad.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(16L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.LOADSEGMENT) {
            codeLength += this.loadSegment.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(15L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.INITIATELOAD) {
            codeLength += this.initiateLoad.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(14L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.MAKEUSABLE) {
            codeLength += this.makeUsable.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(13L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.RESUME) {
            codeLength += this.resume.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(12L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.STOP) {
            codeLength += this.stop.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(11L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.START) {
            codeLength += this.start.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(10L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.CHANGESCOPE) {
            codeLength += this.changeScope.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(9L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GETTIATTRIBUTE) {
            codeLength += this.getTIAttribute.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(8L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GETDATASETATTRIBUTE) {
            codeLength += this.getDataSetAttribute.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(7L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.WRITE) {
            codeLength += this.write.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(6L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.READ) {
            codeLength += this.read.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(5L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GETVARIABLEATTRIBUTE) {
            codeLength += this.getVariableAttribute.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(4L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GETNAMELIST) {
            codeLength += this.getNameList.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GETSTATUS) {
            codeLength += this.getStatus.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.INITIATEERROR) {
            codeLength += this.initiateError.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.INITIATEERROR) {
            this.initiateError = new ServiceError();
            return codeLength += this.initiateError.decode(iStream);
        }
        if (this.choice == Choices.GETSTATUS) {
            this.getStatus = new ServiceError();
            return codeLength += this.getStatus.decode(iStream);
        }
        if (this.choice == Choices.GETNAMELIST) {
            this.getNameList = new ServiceError();
            return codeLength += this.getNameList.decode(iStream);
        }
        if (this.choice == Choices.GETVARIABLEATTRIBUTE) {
            this.getVariableAttribute = new ServiceError();
            return codeLength += this.getVariableAttribute.decode(iStream);
        }
        if (this.choice == Choices.READ) {
            this.read = new ServiceError();
            return codeLength += this.read.decode(iStream);
        }
        if (this.choice == Choices.WRITE) {
            this.write = new ServiceError();
            return codeLength += this.write.decode(iStream);
        }
        if (this.choice == Choices.GETDATASETATTRIBUTE) {
            this.getDataSetAttribute = new ServiceError();
            return codeLength += this.getDataSetAttribute.decode(iStream);
        }
        if (this.choice == Choices.GETTIATTRIBUTE) {
            this.getTIAttribute = new ServiceError();
            return codeLength += this.getTIAttribute.decode(iStream);
        }
        if (this.choice == Choices.CHANGESCOPE) {
            this.changeScope = new ServiceError();
            return codeLength += this.changeScope.decode(iStream);
        }
        if (this.choice == Choices.START) {
            this.start = new ServiceError();
            return codeLength += this.start.decode(iStream);
        }
        if (this.choice == Choices.STOP) {
            this.stop = new ServiceError();
            return codeLength += this.stop.decode(iStream);
        }
        if (this.choice == Choices.RESUME) {
            this.resume = new ServiceError();
            return codeLength += this.resume.decode(iStream);
        }
        if (this.choice == Choices.MAKEUSABLE) {
            this.makeUsable = new ServiceError();
            return codeLength += this.makeUsable.decode(iStream);
        }
        if (this.choice == Choices.INITIATELOAD) {
            this.initiateLoad = new ServiceError();
            return codeLength += this.initiateLoad.decode(iStream);
        }
        if (this.choice == Choices.LOADSEGMENT) {
            this.loadSegment = new ServiceError();
            return codeLength += this.loadSegment.decode(iStream);
        }
        if (this.choice == Choices.TERMINATELOAD) {
            this.terminateLoad = new ServiceError();
            return codeLength += this.terminateLoad.decode(iStream);
        }
        if (this.choice == Choices.INITIATEUPLOAD) {
            this.initiateUpLoad = new ServiceError();
            return codeLength += this.initiateUpLoad.decode(iStream);
        }
        if (this.choice == Choices.UPLOADSEGMENT) {
            this.upLoadSegment = new ServiceError();
            return codeLength += this.upLoadSegment.decode(iStream);
        }
        if (this.choice == Choices.TERMINATEUPLOAD) {
            this.terminateUpLoad = new ServiceError();
            return codeLength += this.terminateUpLoad.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setInitiateError(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.INITIATEERROR;
        this.initiateError = newVal;
    }

    public void setGetStatus(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.GETSTATUS;
        this.getStatus = newVal;
    }

    public void setGetNameList(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.GETNAMELIST;
        this.getNameList = newVal;
    }

    public void setGetVariableAttribute(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.GETVARIABLEATTRIBUTE;
        this.getVariableAttribute = newVal;
    }

    public void setRead(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.READ;
        this.read = newVal;
    }

    public void setWrite(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.WRITE;
        this.write = newVal;
    }

    public void setGetDataSetAttribute(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.GETDATASETATTRIBUTE;
        this.getDataSetAttribute = newVal;
    }

    public void setGetTIAttribute(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.GETTIATTRIBUTE;
        this.getTIAttribute = newVal;
    }

    public void setChangeScope(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.CHANGESCOPE;
        this.changeScope = newVal;
    }

    public void setStart(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.START;
        this.start = newVal;
    }

    public void setStop(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.STOP;
        this.stop = newVal;
    }

    public void setResume(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.RESUME;
        this.resume = newVal;
    }

    public void setMakeUsable(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.MAKEUSABLE;
        this.makeUsable = newVal;
    }

    public void setInitiateLoad(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.INITIATELOAD;
        this.initiateLoad = newVal;
    }

    public void setLoadSegment(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.LOADSEGMENT;
        this.loadSegment = newVal;
    }

    public void setTerminateLoad(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.TERMINATELOAD;
        this.terminateLoad = newVal;
    }

    public void setInitiateUpLoad(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.INITIATEUPLOAD;
        this.initiateUpLoad = newVal;
    }

    public void setUpLoadSegment(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.UPLOADSEGMENT;
        this.upLoadSegment = newVal;
    }

    public void setTerminateUpLoad(ServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.TERMINATEUPLOAD;
        this.terminateUpLoad = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.initiateError = null;
        this.getStatus = null;
        this.getNameList = null;
        this.getVariableAttribute = null;
        this.read = null;
        this.write = null;
        this.getDataSetAttribute = null;
        this.getTIAttribute = null;
        this.changeScope = null;
        this.start = null;
        this.stop = null;
        this.resume = null;
        this.makeUsable = null;
        this.initiateLoad = null;
        this.loadSegment = null;
        this.terminateLoad = null;
        this.initiateUpLoad = null;
        this.upLoadSegment = null;
        this.terminateUpLoad = null;
    }

    public String toString() {
        if (this.choice == Choices.INITIATEERROR) {
            return "choice: {initiateError: " + this.initiateError + "}";
        }
        if (this.choice == Choices.GETSTATUS) {
            return "choice: {getStatus: " + this.getStatus + "}";
        }
        if (this.choice == Choices.GETNAMELIST) {
            return "choice: {getNameList: " + this.getNameList + "}";
        }
        if (this.choice == Choices.GETVARIABLEATTRIBUTE) {
            return "choice: {getVariableAttribute: " + this.getVariableAttribute + "}";
        }
        if (this.choice == Choices.READ) {
            return "choice: {read: " + this.read + "}";
        }
        if (this.choice == Choices.WRITE) {
            return "choice: {write: " + this.write + "}";
        }
        if (this.choice == Choices.GETDATASETATTRIBUTE) {
            return "choice: {getDataSetAttribute: " + this.getDataSetAttribute + "}";
        }
        if (this.choice == Choices.GETTIATTRIBUTE) {
            return "choice: {getTIAttribute: " + this.getTIAttribute + "}";
        }
        if (this.choice == Choices.CHANGESCOPE) {
            return "choice: {changeScope: " + this.changeScope + "}";
        }
        if (this.choice == Choices.START) {
            return "choice: {start: " + this.start + "}";
        }
        if (this.choice == Choices.STOP) {
            return "choice: {stop: " + this.stop + "}";
        }
        if (this.choice == Choices.RESUME) {
            return "choice: {resume: " + this.resume + "}";
        }
        if (this.choice == Choices.MAKEUSABLE) {
            return "choice: {makeUsable: " + this.makeUsable + "}";
        }
        if (this.choice == Choices.INITIATELOAD) {
            return "choice: {initiateLoad: " + this.initiateLoad + "}";
        }
        if (this.choice == Choices.LOADSEGMENT) {
            return "choice: {loadSegment: " + this.loadSegment + "}";
        }
        if (this.choice == Choices.TERMINATELOAD) {
            return "choice: {terminateLoad: " + this.terminateLoad + "}";
        }
        if (this.choice == Choices.INITIATEUPLOAD) {
            return "choice: {initiateUpLoad: " + this.initiateUpLoad + "}";
        }
        if (this.choice == Choices.UPLOADSEGMENT) {
            return "choice: {upLoadSegment: " + this.upLoadSegment + "}";
        }
        if (this.choice == Choices.TERMINATEUPLOAD) {
            return "choice: {terminateUpLoad: " + this.terminateUpLoad + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        INITIATEERROR(1),
        GETSTATUS(2),
        GETNAMELIST(3),
        GETVARIABLEATTRIBUTE(4),
        READ(5),
        WRITE(6),
        GETDATASETATTRIBUTE(7),
        GETTIATTRIBUTE(8),
        CHANGESCOPE(9),
        START(10),
        STOP(11),
        RESUME(12),
        MAKEUSABLE(13),
        INITIATELOAD(14),
        LOADSEGMENT(15),
        TERMINATELOAD(16),
        INITIATEUPLOAD(17),
        UPLOADSEGMENT(18),
        TERMINATEUPLOAD(19);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

