/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;
import org.openmuc.jdlms.internal.asn1.cosem.NotificationBody;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned32;

public class DataNotification
implements AxdrType {
    public byte[] code = null;
    public Unsigned32 longInvokeIdAndPriority = null;
    public AxdrOctetString dateTime = null;
    public NotificationBody notificationBody = null;

    public DataNotification() {
    }

    public DataNotification(byte[] code) {
        this.code = code;
    }

    public DataNotification(Unsigned32 longInvokeIdAndPriority, AxdrOctetString dateTime, NotificationBody notificationBody) {
        this.longInvokeIdAndPriority = longInvokeIdAndPriority;
        this.dateTime = dateTime;
        this.notificationBody = notificationBody;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.notificationBody.encode(axdrOStream);
            codeLength += this.dateTime.encode(axdrOStream);
            codeLength += this.longInvokeIdAndPriority.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.longInvokeIdAndPriority = new Unsigned32();
        codeLength += this.longInvokeIdAndPriority.decode(iStream);
        this.dateTime = new AxdrOctetString();
        codeLength += this.dateTime.decode(iStream);
        this.notificationBody = new NotificationBody();
        return codeLength += this.notificationBody.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {longInvokeIdAndPriority: " + this.longInvokeIdAndPriority + ", dateTime: " + this.dateTime + ", notificationBody: " + this.notificationBody + "}";
    }
}

