/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponseNormal;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponseWithDatablock;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponseWithList;

public class GetResponse
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public GetResponseNormal getResponseNormal = null;
    public GetResponseWithDatablock getResponseWithDatablock = null;
    public GetResponseWithList getResponseWithList = null;

    public GetResponse() {
    }

    public GetResponse(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.GET_RESPONSE_WITH_LIST) {
            codeLength += this.getResponseWithList.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GET_RESPONSE_WITH_DATABLOCK) {
            codeLength += this.getResponseWithDatablock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GET_RESPONSE_NORMAL) {
            codeLength += this.getResponseNormal.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.GET_RESPONSE_NORMAL) {
            this.getResponseNormal = new GetResponseNormal();
            return codeLength += this.getResponseNormal.decode(iStream);
        }
        if (this.choice == Choices.GET_RESPONSE_WITH_DATABLOCK) {
            this.getResponseWithDatablock = new GetResponseWithDatablock();
            return codeLength += this.getResponseWithDatablock.decode(iStream);
        }
        if (this.choice == Choices.GET_RESPONSE_WITH_LIST) {
            this.getResponseWithList = new GetResponseWithList();
            return codeLength += this.getResponseWithList.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setGetResponseNormal(GetResponseNormal newVal) {
        this.resetChoices();
        this.choice = Choices.GET_RESPONSE_NORMAL;
        this.getResponseNormal = newVal;
    }

    public void setGetResponseWithDatablock(GetResponseWithDatablock newVal) {
        this.resetChoices();
        this.choice = Choices.GET_RESPONSE_WITH_DATABLOCK;
        this.getResponseWithDatablock = newVal;
    }

    public void setGetResponseWithList(GetResponseWithList newVal) {
        this.resetChoices();
        this.choice = Choices.GET_RESPONSE_WITH_LIST;
        this.getResponseWithList = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.getResponseNormal = null;
        this.getResponseWithDatablock = null;
        this.getResponseWithList = null;
    }

    public String toString() {
        if (this.choice == Choices.GET_RESPONSE_NORMAL) {
            return "choice: {getResponseNormal: " + this.getResponseNormal + "}";
        }
        if (this.choice == Choices.GET_RESPONSE_WITH_DATABLOCK) {
            return "choice: {getResponseWithDatablock: " + this.getResponseWithDatablock + "}";
        }
        if (this.choice == Choices.GET_RESPONSE_WITH_LIST) {
            return "choice: {getResponseWithList: " + this.getResponseWithList + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        GET_RESPONSE_NORMAL(1),
        GET_RESPONSE_WITH_DATABLOCK(2),
        GET_RESPONSE_WITH_LIST(3);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

