/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrGeneralizedTime;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrSequenceOf;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.VariableAccessSpecification;

public class InformationReportRequest
implements AxdrType {
    public byte[] code = null;
    public AxdrOptional<AxdrGeneralizedTime> currentTime = new AxdrOptional<AxdrGeneralizedTime>(new AxdrGeneralizedTime(), false);
    public SubSeqOfVariableAccessSpecification variableAccessSpecification = null;
    public SubSeqOfListOfData listOfData = null;

    public InformationReportRequest() {
    }

    public InformationReportRequest(byte[] code) {
        this.code = code;
    }

    public InformationReportRequest(AxdrGeneralizedTime currentTime, SubSeqOfVariableAccessSpecification variableAccessSpecification, SubSeqOfListOfData listOfData) {
        this.currentTime.setValue(currentTime);
        this.variableAccessSpecification = variableAccessSpecification;
        this.listOfData = listOfData;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.listOfData.encode(axdrOStream);
            codeLength += this.variableAccessSpecification.encode(axdrOStream);
            codeLength += this.currentTime.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.currentTime = new AxdrOptional<AxdrGeneralizedTime>(new AxdrGeneralizedTime(), false);
        codeLength += this.currentTime.decode(iStream);
        this.variableAccessSpecification = new SubSeqOfVariableAccessSpecification();
        codeLength += this.variableAccessSpecification.decode(iStream);
        this.listOfData = new SubSeqOfListOfData();
        return codeLength += this.listOfData.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {currentTime: " + this.currentTime + ", variableAccessSpecification: " + this.variableAccessSpecification + ", listOfData: " + this.listOfData + "}";
    }

    public static class SubSeqOfListOfData
    extends AxdrSequenceOf<Data> {
        @Override
        protected Data createListElement() {
            return new Data();
        }

        protected SubSeqOfListOfData(int length) {
            super(length);
        }

        public SubSeqOfListOfData() {
        }
    }

    public static class SubSeqOfVariableAccessSpecification
    extends AxdrSequenceOf<VariableAccessSpecification> {
        @Override
        protected VariableAccessSpecification createListElement() {
            return new VariableAccessSpecification();
        }

        protected SubSeqOfVariableAccessSpecification(int length) {
            super(length);
        }

        public SubSeqOfVariableAccessSpecification() {
        }
    }
}

