/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.cosem.Conformance;
import org.openmuc.jdlms.internal.asn1.cosem.Integer16;
import org.openmuc.jdlms.internal.asn1.cosem.Integer8;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned16;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned8;

public class InitiateResponse
implements AxdrType {
    public byte[] code = null;
    public AxdrOptional<Integer8> negotiatedQualityOfService = new AxdrOptional<Integer8>(new Integer8(), false);
    public Unsigned8 negotiatedDlmsVersionNumber = null;
    public Conformance negotiatedConformance = null;
    public Unsigned16 serverMaxReceivePduSize = null;
    public Integer16 vaaName = null;

    public InitiateResponse() {
    }

    public InitiateResponse(byte[] code) {
        this.code = code;
    }

    public InitiateResponse(Integer8 negotiatedQualityOfService, Unsigned8 negotiatedDlmsVersionNumber, Conformance negotiatedConformance, Unsigned16 serverMaxReceivePduSize, Integer16 vaaName) {
        this.negotiatedQualityOfService.setValue(negotiatedQualityOfService);
        this.negotiatedDlmsVersionNumber = negotiatedDlmsVersionNumber;
        this.negotiatedConformance = negotiatedConformance;
        this.serverMaxReceivePduSize = serverMaxReceivePduSize;
        this.vaaName = vaaName;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.vaaName.encode(axdrOStream);
            codeLength += this.serverMaxReceivePduSize.encode(axdrOStream);
            codeLength += this.negotiatedConformance.encode(axdrOStream);
            codeLength += this.negotiatedDlmsVersionNumber.encode(axdrOStream);
            codeLength += this.negotiatedQualityOfService.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.negotiatedQualityOfService = new AxdrOptional<Integer8>(new Integer8(), false);
        codeLength += this.negotiatedQualityOfService.decode(iStream);
        this.negotiatedDlmsVersionNumber = new Unsigned8();
        codeLength += this.negotiatedDlmsVersionNumber.decode(iStream);
        this.negotiatedConformance = new Conformance();
        codeLength += this.negotiatedConformance.decode(iStream);
        this.serverMaxReceivePduSize = new Unsigned16();
        codeLength += this.serverMaxReceivePduSize.decode(iStream);
        this.vaaName = new Integer16();
        return codeLength += this.vaaName.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {negotiatedQualityOfService: " + this.negotiatedQualityOfService + ", negotiatedDlmsVersionNumber: " + this.negotiatedDlmsVersionNumber + ", negotiatedConformance: " + (Object)((Object)this.negotiatedConformance) + ", serverMaxReceivePduSize: " + this.serverMaxReceivePduSize + ", vaaName: " + this.vaaName + "}";
    }
}

