/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.AgreedKey;
import org.openmuc.jdlms.internal.asn1.cosem.IdentifiedKey;
import org.openmuc.jdlms.internal.asn1.cosem.WrappedKey;

public class KeyInfo
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public IdentifiedKey identifiedKey = null;
    public WrappedKey wrappedKey = null;
    public AgreedKey agreedKey = null;

    public KeyInfo() {
    }

    public KeyInfo(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.AGREED_KEY) {
            codeLength += this.agreedKey.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.WRAPPED_KEY) {
            codeLength += this.wrappedKey.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.IDENTIFIED_KEY) {
            codeLength += this.identifiedKey.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(0L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.IDENTIFIED_KEY) {
            this.identifiedKey = new IdentifiedKey();
            return codeLength += this.identifiedKey.decode(iStream);
        }
        if (this.choice == Choices.WRAPPED_KEY) {
            this.wrappedKey = new WrappedKey();
            return codeLength += this.wrappedKey.decode(iStream);
        }
        if (this.choice == Choices.AGREED_KEY) {
            this.agreedKey = new AgreedKey();
            return codeLength += this.agreedKey.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setIdentifiedKey(IdentifiedKey newVal) {
        this.resetChoices();
        this.choice = Choices.IDENTIFIED_KEY;
        this.identifiedKey = newVal;
    }

    public void setWrappedKey(WrappedKey newVal) {
        this.resetChoices();
        this.choice = Choices.WRAPPED_KEY;
        this.wrappedKey = newVal;
    }

    public void setAgreedKey(AgreedKey newVal) {
        this.resetChoices();
        this.choice = Choices.AGREED_KEY;
        this.agreedKey = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.identifiedKey = null;
        this.wrappedKey = null;
        this.agreedKey = null;
    }

    public String toString() {
        if (this.choice == Choices.IDENTIFIED_KEY) {
            return "choice: {identifiedKey: " + this.identifiedKey + "}";
        }
        if (this.choice == Choices.WRAPPED_KEY) {
            return "choice: {wrappedKey: " + this.wrappedKey + "}";
        }
        if (this.choice == Choices.AGREED_KEY) {
            return "choice: {agreedKey: " + this.agreedKey + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        IDENTIFIED_KEY(0),
        WRAPPED_KEY(1),
        AGREED_KEY(2);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

