/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.Integer16;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned8;

public class ParameterizedAccess
implements AxdrType {
    public byte[] code = null;
    public Integer16 variableName = null;
    public Unsigned8 selector = null;
    public Data parameter = null;

    public ParameterizedAccess() {
    }

    public ParameterizedAccess(byte[] code) {
        this.code = code;
    }

    public ParameterizedAccess(Integer16 variableName, Unsigned8 selector, Data parameter) {
        this.variableName = variableName;
        this.selector = selector;
        this.parameter = parameter;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.parameter.encode(axdrOStream);
            codeLength += this.selector.encode(axdrOStream);
            codeLength += this.variableName.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.variableName = new Integer16();
        codeLength += this.variableName.decode(iStream);
        this.selector = new Unsigned8();
        codeLength += this.selector.decode(iStream);
        this.parameter = new Data();
        return codeLength += this.parameter.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {variableName: " + this.variableName + ", selector: " + this.selector + ", parameter: " + this.parameter + "}";
    }
}

