/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrNull;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrSequenceOf;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned16;

public class WriteResponse
extends AxdrSequenceOf<SubChoice> {
    @Override
    protected SubChoice createListElement() {
        return new SubChoice();
    }

    protected WriteResponse(int length) {
        super(length);
    }

    public WriteResponse() {
    }

    public static class SubChoice
    implements AxdrType {
        public byte[] code = null;
        private Choices choice;
        public AxdrNull success = null;
        public AxdrEnum dataAccessError = null;
        public Unsigned16 blockNumber = null;

        public SubChoice() {
        }

        public SubChoice(byte[] code) {
            this.code = code;
        }

        @Override
        public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    axdrOStream.write(this.code[i]);
                }
                return this.code.length;
            }
            if (this.choice == Choices._ERR_NONE_SELECTED) {
                throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
            }
            int codeLength = 0;
            if (this.choice == Choices.BLOCK_NUMBER) {
                codeLength += this.blockNumber.encode(axdrOStream);
                AxdrEnum c = new AxdrEnum(2L);
                return codeLength += c.encode(axdrOStream);
            }
            if (this.choice == Choices.DATA_ACCESS_ERROR) {
                codeLength += this.dataAccessError.encode(axdrOStream);
                AxdrEnum c = new AxdrEnum(1L);
                return codeLength += c.encode(axdrOStream);
            }
            if (this.choice == Choices.SUCCESS) {
                codeLength += this.success.encode(axdrOStream);
                AxdrEnum c = new AxdrEnum(0L);
                return codeLength += c.encode(axdrOStream);
            }
            throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
        }

        @Override
        public int decode(InputStream iStream) throws IOException {
            int codeLength = 0;
            AxdrEnum choosen = new AxdrEnum();
            codeLength += choosen.decode(iStream);
            this.resetChoices();
            this.choice = Choices.valueOf(choosen.getValue());
            if (this.choice == Choices.SUCCESS) {
                this.success = new AxdrNull();
                return codeLength += this.success.decode(iStream);
            }
            if (this.choice == Choices.DATA_ACCESS_ERROR) {
                this.dataAccessError = new AxdrEnum();
                return codeLength += this.dataAccessError.decode(iStream);
            }
            if (this.choice == Choices.BLOCK_NUMBER) {
                this.blockNumber = new Unsigned16();
                return codeLength += this.blockNumber.decode(iStream);
            }
            throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode(axdrOStream);
            this.code = axdrOStream.getArray();
        }

        public Choices getChoiceIndex() {
            return this.choice;
        }

        public void setSuccess(AxdrNull newVal) {
            this.resetChoices();
            this.choice = Choices.SUCCESS;
            this.success = newVal;
        }

        public void setDataAccessError(AxdrEnum newVal) {
            this.resetChoices();
            this.choice = Choices.DATA_ACCESS_ERROR;
            this.dataAccessError = newVal;
        }

        public void setBlockNumber(Unsigned16 newVal) {
            this.resetChoices();
            this.choice = Choices.BLOCK_NUMBER;
            this.blockNumber = newVal;
        }

        private void resetChoices() {
            this.choice = Choices._ERR_NONE_SELECTED;
            this.success = null;
            this.dataAccessError = null;
            this.blockNumber = null;
        }

        public String toString() {
            if (this.choice == Choices.SUCCESS) {
                return "choice: {success: " + this.success + "}";
            }
            if (this.choice == Choices.DATA_ACCESS_ERROR) {
                return "choice: {dataAccessError: " + this.dataAccessError + "}";
            }
            if (this.choice == Choices.BLOCK_NUMBER) {
                return "choice: {blockNumber: " + this.blockNumber + "}";
            }
            return "unknown";
        }

        public static enum Choices {
            _ERR_NONE_SELECTED(-1),
            SUCCESS(0),
            DATA_ACCESS_ERROR(1),
            BLOCK_NUMBER(2);

            private int value;

            private Choices(int value) {
                this.value = value;
            }

            public int getValue() {
                return this.value;
            }

            public static Choices valueOf(long tagValue) {
                Choices[] values;
                for (Choices c : values = Choices.values()) {
                    if ((long)c.value != tagValue) continue;
                    return c;
                }
                return _ERR_NONE_SELECTED;
            }
        }
    }
}

