/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.association;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openmuc.jdlms.AuthenticationMechanism;
import org.openmuc.jdlms.ConformanceSetting;
import org.openmuc.jdlms.LogicalDevice;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.internal.APdu;
import org.openmuc.jdlms.internal.AssociateSourceDiagnostic;
import org.openmuc.jdlms.internal.ConformanceSettingConverter;
import org.openmuc.jdlms.internal.ContextId;
import org.openmuc.jdlms.internal.DataDirectoryImpl;
import org.openmuc.jdlms.internal.ObjectIdentifier;
import org.openmuc.jdlms.internal.ServerConnectionData;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.cosem.Conformance;
import org.openmuc.jdlms.internal.asn1.cosem.InitiateRequest;
import org.openmuc.jdlms.internal.asn1.iso.acse.AARQApdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.ACSEApdu;
import org.openmuc.jdlms.internal.asn1.iso.acse.MechanismName;
import org.openmuc.jdlms.internal.association.AssociatRequestException;
import org.openmuc.jdlms.internal.association.InitiateResponseBuilder;
import org.openmuc.jdlms.internal.security.RandomSequenceGenerator;

class InitiateMessageProcessor {
    private final ServerConnectionData connectionData;
    private final DataDirectoryImpl.CosemLogicalDevice cosemLogicalDevice;
    private final LogicalDevice logicalDevice;
    private ContextId contextId;

    public InitiateMessageProcessor(ServerConnectionData connectionData, DataDirectoryImpl.CosemLogicalDevice cosemLogicalDevice) {
        this.connectionData = connectionData;
        this.cosemLogicalDevice = cosemLogicalDevice;
        this.logicalDevice = cosemLogicalDevice.getLogicalDevice();
        Map<Integer, SecuritySuite> restrictions = cosemLogicalDevice.getLogicalDevice().getRestrictions();
        this.connectionData.setSecuritySuite(restrictions.get(this.connectionData.getClientId()));
    }

    public ContextId getContextId() {
        return this.contextId;
    }

    public APdu processInitialMessage(byte[] messageData) throws IOException {
        SecuritySuite securitySuite = this.connectionData.getSecuritySuite();
        if (this.cosemLogicalDevice == null) {
            throw new AssociatRequestException(AssociateSourceDiagnostic.AcseServiceUser.NO_REASON_GIVEN);
        }
        Map<Integer, SecuritySuite> restrictions = this.logicalDevice.getRestrictions();
        APdu aPdu = APdu.decode(messageData, null);
        this.contextId = ObjectIdentifier.applicationContextIdFrom(aPdu.getAcseAPdu().getAarq().getApplicationContextName());
        if (restrictions.isEmpty()) {
            this.connectionData.setAuthenticated();
            this.connectionData.setSecuritySuite(SecuritySuite.builder().build());
            return new InitiateResponseBuilder(ConformanceSettingConverter.conformanceFor(this.logicalDevice.getConformance())).setContextId(this.contextId).build();
        }
        if (securitySuite == null) {
            throw new AssociatRequestException(AssociateSourceDiagnostic.AcseServiceUser.NO_REASON_GIVEN);
        }
        if (securitySuite.getEncryptionMechanism() != SecuritySuite.EncryptionMechanism.NONE) {
            this.connectionData.setClientSystemTitle(this.systemTitle());
            aPdu = APdu.decode(messageData, this.connectionData.getClientSystemTitle(), securitySuite, null);
        }
        if (aPdu.getCosemPdu() == null) {
            throw new AssociatRequestException(AssociateSourceDiagnostic.AcseServiceUser.NO_REASON_GIVEN);
        }
        COSEMpdu cosemPdu = aPdu.getCosemPdu();
        if (cosemPdu.getChoiceIndex() != COSEMpdu.Choices.INITIATEREQUEST) {
            throw new AssociatRequestException(AssociateSourceDiagnostic.AcseServiceUser.NO_REASON_GIVEN);
        }
        InitiateRequest initiateRequest = cosemPdu.initiateRequest;
        this.connectionData.setClientMaxReceivePduSize(initiateRequest.clientMaxReceivePduSize.getValue() & 0xFFFFL);
        Conformance negotiatedConformance = this.negotiateConformance(initiateRequest);
        ACSEApdu acseAPdu = aPdu.getAcseAPdu();
        if (acseAPdu == null) {
            throw new AssociatRequestException(AssociateSourceDiagnostic.AcseServiceUser.NO_REASON_GIVEN);
        }
        AARQApdu aarq = acseAPdu.getAarq();
        return this.tryToAuthenticate(aarq, securitySuite, negotiatedConformance);
    }

    private Conformance negotiateConformance(InitiateRequest initiateRequest) {
        Set<ConformanceSetting> proposedConformance = ConformanceSettingConverter.conformanceSettingFor(initiateRequest.proposedConformance);
        HashSet<ConformanceSetting> negotiatedConformance = new HashSet<ConformanceSetting>(this.logicalDevice.getConformance());
        negotiatedConformance.retainAll(proposedConformance);
        return ConformanceSettingConverter.conformanceFor(negotiatedConformance);
    }

    private static void checkChallangeLength(int challengeLength) throws AssociatRequestException {
        if (challengeLength < 8 || challengeLength > 64) {
            throw new AssociatRequestException(AssociateSourceDiagnostic.AcseServiceUser.AUTHENTICATION_FAILURE);
        }
    }

    private APdu tryToAuthenticate(AARQApdu aarq, SecuritySuite securitySuite, Conformance negotiatedConformance) throws IOException {
        InitiateResponseBuilder responseBuilder = new InitiateResponseBuilder(negotiatedConformance);
        MechanismName mechanismName = aarq.getMechanismName();
        AuthenticationMechanism authLevel = AuthenticationMechanism.NONE;
        if (mechanismName != null) {
            authLevel = ObjectIdentifier.mechanismIdFrom(mechanismName);
        }
        if (authLevel != securitySuite.getAuthenticationMechanism()) {
            throw new AssociatRequestException(AssociateSourceDiagnostic.AcseServiceUser.AUTHENTICATION_FAILURE);
        }
        if (authLevel == AuthenticationMechanism.NONE && securitySuite.getAuthenticationMechanism() == AuthenticationMechanism.NONE) {
            this.connectionData.setAuthenticated();
            return responseBuilder.setContextId(this.contextId).build();
        }
        this.connectionData.setClientToServerChallenge(aarq.getCallingAuthenticationValue().getCharstring().value);
        switch (authLevel) {
            case LOW: {
                return this.processLowAuthentciationRequest(responseBuilder, aarq, securitySuite.getPassword(), securitySuite.getEncryptionMechanism() != SecuritySuite.EncryptionMechanism.NONE);
            }
            case HLS5_GMAC: {
                return this.processHls5GmacAuthentciationRequest(responseBuilder, aarq);
            }
        }
        throw new AssociatRequestException(AssociateSourceDiagnostic.AcseServiceUser.APPLICATION_CONTEXT_NAME_NOT_SUPPORTED);
    }

    private APdu processHls5GmacAuthentciationRequest(InitiateResponseBuilder responseBuilder, AARQApdu aarq) throws IOException {
        byte[] clientToServerChallenge = this.connectionData.getClientToServerChallenge();
        this.connectionData.setClientSystemTitle(aarq.getCallingAPTitle().getApTitleForm2().value);
        int challengeLength = clientToServerChallenge.length;
        InitiateMessageProcessor.checkChallangeLength(challengeLength);
        byte[] serverToClientChallenge = RandomSequenceGenerator.generateNewChallenge(challengeLength);
        this.connectionData.setServerToClientChallenge(serverToClientChallenge);
        return responseBuilder.setContextId(this.contextId).setAuthenticationValue(serverToClientChallenge).setSystemTitle(this.systemTitle()).build();
    }

    private APdu processLowAuthentciationRequest(InitiateResponseBuilder responseBuilder, AARQApdu aarq, byte[] authenticationKey, boolean addSystemTitle) throws AssociatRequestException {
        byte[] clientAuthenticaionValue = aarq.getCallingAuthenticationValue().getCharstring().value;
        if (addSystemTitle) {
            this.connectionData.setClientSystemTitle(aarq.getCallingAPTitle().getApTitleForm2().value);
            responseBuilder.setSystemTitle(this.systemTitle());
        }
        if (Arrays.equals(clientAuthenticaionValue, authenticationKey)) {
            this.connectionData.setAuthenticated();
            return responseBuilder.build();
        }
        throw new AssociatRequestException(AssociateSourceDiagnostic.AcseServiceUser.AUTHENTICATION_FAILURE);
    }

    private byte[] systemTitle() {
        return this.logicalDevice.getSystemTitle();
    }
}

