/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.association.sn;

import java.io.IOException;
import java.util.Iterator;
import org.openmuc.jdlms.IllegalAttributeAccessException;
import org.openmuc.jdlms.IllegalMethodAccessException;
import org.openmuc.jdlms.internal.APdu;
import org.openmuc.jdlms.internal.DlmsEnumFunctions;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrNull;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.VariableAccessSpecification;
import org.openmuc.jdlms.internal.asn1.cosem.WriteRequest;
import org.openmuc.jdlms.internal.asn1.cosem.WriteResponse;
import org.openmuc.jdlms.internal.association.AssociationMessenger;
import org.openmuc.jdlms.internal.association.RequestProcessorData;
import org.openmuc.jdlms.internal.association.sn.SnRequestProcessorBase;

public class WriteRequestProcessor
extends SnRequestProcessorBase {
    public WriteRequestProcessor(AssociationMessenger associationMessenger, RequestProcessorData requestProcessorData) {
        super(associationMessenger, requestProcessorData);
    }

    @Override
    public void processRequest(COSEMpdu request) throws IOException {
        WriteRequest writeRequest = request.writeRequest;
        Iterator varAccessSpecIter = writeRequest.variableAccessSpecification.iterator();
        Iterator dataIter = writeRequest.listOfData.iterator();
        WriteResponse writeResponse = new WriteResponse();
        while (varAccessSpecIter.hasNext() && dataIter.hasNext()) {
            VariableAccessSpecification vas = (VariableAccessSpecification)varAccessSpecIter.next();
            Data data = (Data)dataIter.next();
            switch (vas.getChoiceIndex()) {
                case VARIABLE_NAME: {
                    writeResponse.add(this.varNameReq(vas, data));
                    break;
                }
                case PARAMETERIZED_ACCESS: {
                    break;
                }
                case WRITE_DATA_BLOCK_ACCESS: {
                    break;
                }
            }
        }
        APdu aPdu = this.newAPdu();
        aPdu.getCosemPdu().setWriteResponse(writeResponse);
        this.associationMessenger.encodeAndSend(aPdu);
    }

    private WriteResponse.SubChoice varNameReq(VariableAccessSpecification vas, Data data) {
        int varName = (int)vas.variableName.getValue() & 0xFFFF;
        WriteResponse.SubChoice res = new WriteResponse.SubChoice();
        try {
            this.requestProcessorData.getDirectory().snSetOrInvoke(this.logicalDeviceId(), varName, data, this.connectionId());
            res.setSuccess(new AxdrNull());
        }
        catch (IllegalAttributeAccessException e) {
            res.setDataAccessError(DlmsEnumFunctions.enumToAxdrEnum(e.getAccessResultCode()));
        }
        catch (IllegalMethodAccessException e) {
            res.setDataAccessError(DlmsEnumFunctions.enumToAxdrEnum(e.getMethodResultCode()));
        }
        return res;
    }
}

