/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.systemclasses;

import java.util.List;
import java.util.Map;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.openmuc.jdlms.AttributeAccessMode;
import org.openmuc.jdlms.CosemAttribute;
import org.openmuc.jdlms.CosemClass;
import org.openmuc.jdlms.CosemMethod;
import org.openmuc.jdlms.CosemSnInterfaceObject;
import org.openmuc.jdlms.IllegalMethodAccessException;
import org.openmuc.jdlms.LogicalDevice;
import org.openmuc.jdlms.MethodAccessMode;
import org.openmuc.jdlms.MethodResultCode;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.SecurityUtils;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.DataDirectoryImpl;
import org.openmuc.jdlms.internal.DlmsEnumFunctions;
import org.openmuc.jdlms.internal.SecSuiteAccessor;
import org.openmuc.jdlms.internal.ServerConnectionData;
import org.openmuc.jdlms.internal.systemclasses.CosemDataDirectory;

@CosemClass(id=64, version=0)
public class SecuritySetup
extends CosemSnInterfaceObject {
    @CosemAttribute(id=2, accessMode=AttributeAccessMode.AUTHENTICATED_READ_ONLY, snOffset=8)
    private DataObject securityPolicy;
    @CosemAttribute(id=3, accessMode=AttributeAccessMode.AUTHENTICATED_READ_ONLY, snOffset=16)
    private DataObject securitySuite;
    @CosemAttribute(id=4, accessMode=AttributeAccessMode.AUTHENTICATED_READ_ONLY, snOffset=24)
    private DataObject clientSystemTitle;
    @CosemAttribute(id=5, accessMode=AttributeAccessMode.AUTHENTICATED_READ_ONLY, snOffset=32)
    private final DataObject serverSystemTitle;
    @CosemDataDirectory
    private DataDirectoryImpl dataDirectory;
    private final byte[] masterKey;
    private final LogicalDevice logicalDevice;

    public SecuritySetup(LogicalDevice logicalDevice) {
        super(0, "0.0.43.0.0.255");
        this.logicalDevice = logicalDevice;
        this.masterKey = logicalDevice.getMasterKey();
        this.serverSystemTitle = DataObject.newOctetStringData(logicalDevice.getSystemTitle());
    }

    public DataObject getSecurityPolicy(Long connectionId) {
        ServerConnectionData connectionData = this.connectionDataFor(connectionId);
        return DataObject.newEnumerateData(connectionData.getSecuritySuite().getSecurityPolicy().getId());
    }

    public DataObject getSecuritySuite(Long connectionId) {
        ServerConnectionData connectionData = this.connectionDataFor(connectionId);
        return DataObject.newEnumerateData((int)connectionData.getSecuritySuite().getEncryptionMechanism().getCode());
    }

    private ServerConnectionData connectionDataFor(Long connectionId) {
        return this.dataDirectory.getConnectionData(connectionId);
    }

    public DataObject getClientSystemTitle(Long connectionId) {
        ServerConnectionData connectionData = this.connectionDataFor(connectionId);
        return DataObject.newOctetStringData(connectionData.getClientSystemTitle());
    }

    public DataObject getServerSystemTitle() {
        return this.serverSystemTitle;
    }

    @CosemMethod(id=2, consumes=DataObject.Type.ARRAY, accessMode=MethodAccessMode.AUTHENTICATED_ACCESS, snOffset=48)
    public void globalKeyTransfer(DataObject keyDatas, Long connectionId) throws IllegalMethodAccessException {
        List keyDataList = (List)keyDatas.getValue();
        if (((DataObject)keyDataList.get(0)).getType() != DataObject.Type.STRUCTURE) {
            throw new IllegalMethodAccessException(MethodResultCode.TYPE_UNMATCHED);
        }
        int clientId = this.dataDirectory.getConnectionData(connectionId).getClientId();
        for (DataObject dataObject : keyDataList) {
            this.updateKey(dataObject, clientId);
        }
    }

    private void updateKey(DataObject keyData, int clientId) throws IllegalMethodAccessException {
        byte[] unwrappedKey;
        List keyDataL = (List)keyData.getValue();
        if (keyDataL.size() != 2) {
            throw new IllegalMethodAccessException(MethodResultCode.TYPE_UNMATCHED);
        }
        DataObject keyIdDo = (DataObject)keyDataL.get(0);
        DataObject keyWrappedDo = (DataObject)keyDataL.get(1);
        if (keyIdDo.getType() != DataObject.Type.ENUMERATE || keyWrappedDo.getType() != DataObject.Type.OCTET_STRING) {
            throw new IllegalMethodAccessException(MethodResultCode.TYPE_UNMATCHED);
        }
        Number keyIdNum = (Number)keyIdDo.getValue();
        SecurityUtils.KeyId keyId = DlmsEnumFunctions.enumValueFrom((long)keyIdNum.intValue(), SecurityUtils.KeyId.class);
        if (keyId == SecurityUtils.KeyId.GLOBAL_BROADCAST_ENCRYPTION_KEY) {
            throw new IllegalMethodAccessException(MethodResultCode.OTHER_REASON);
        }
        byte[] wrappedKey = (byte[])keyWrappedDo.getValue();
        try {
            unwrappedKey = SecurityUtils.unwrapAesRFC3394Key(this.masterKey, wrappedKey);
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalMethodAccessException(MethodResultCode.OTHER_REASON);
        }
        Map<Integer, SecuritySuite> restrictions = this.logicalDevice.getRestrictions();
        SecSuiteAccessor secAccessor = (SecSuiteAccessor)((Object)restrictions.get(clientId));
        switch (keyId) {
            case AUTHENTICATION_KEY: {
                secAccessor.updateAuthentciationKey(unwrappedKey);
                break;
            }
            case GLOBAL_UNICAST_ENCRYPTION_KEY: {
                secAccessor.updateGlobalUnicastEncryptionKey(unwrappedKey);
                break;
            }
            default: {
                throw new IllegalMethodAccessException(MethodResultCode.OTHER_REASON);
            }
        }
    }
}

