/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class FrameRejectReason
implements Serializable {
    private byte rejectedControlField;
    private int nextSendSequence;
    private int nextReceiveSequence;
    private List<RejectReason> rejectReasons;

    FrameRejectReason(byte controlField) {
        this.rejectedControlField = controlField;
        this.rejectReasons = RejectReason.reasonsFor(controlField);
    }

    private FrameRejectReason() {
    }

    static FrameRejectReason decode(byte[] data) throws IOException {
        FrameRejectReason frameRejectReason = new FrameRejectReason();
        ByteArrayInputStream iStream = new ByteArrayInputStream(data);
        int buffer = iStream.read();
        frameRejectReason.rejectedControlField = (byte)buffer;
        buffer = iStream.read();
        frameRejectReason.nextSendSequence = (buffer & 0x40) >> 6 | (buffer & 0x20) >> 4 | (buffer & 0x10) >> 2;
        frameRejectReason.nextReceiveSequence = (buffer & 4) >> 2 | buffer & 2 | (buffer & 1) << 2;
        buffer = iStream.read();
        frameRejectReason.rejectReasons = RejectReason.reasonsFor((byte)buffer);
        return frameRejectReason;
    }

    public List<RejectReason> rejectReasons() {
        return this.rejectReasons;
    }

    byte[] encode() {
        byte[] result = new byte[3];
        result[0] = this.rejectedControlField;
        byte encodedSendSequence = (byte)((this.nextSendSequence & 1) << 6 | (this.nextSendSequence & 2) << 4 | (this.nextSendSequence & 4) << 2);
        byte encodedReceiveSequence = (byte)((this.nextReceiveSequence & 1) << 2 | this.nextReceiveSequence & 2 | (this.nextReceiveSequence & 4) >> 2);
        result[1] = (byte)(encodedReceiveSequence | encodedSendSequence);
        result[1] = (byte)(result[1] | this.rejectedControlField & 8);
        result[2] = 0;
        for (RejectReason reason : this.rejectReasons) {
            result[2] = (byte)(result[2] | reason.mask());
        }
        return result;
    }

    public static enum RejectReason {
        CONTOL_FIELD_UNDEFINED(128),
        INVALID_INFORMATION(64),
        INFORMATION_SIZE_EXCEEDED(32),
        INVALID_RECEIVE_SEQUENCE(16);

        private static final RejectReason[] VALUES;
        private byte mask;

        private RejectReason(int mask) {
            this.mask = (byte)mask;
        }

        public byte mask() {
            return this.mask;
        }

        public static List<RejectReason> reasonsFor(byte bits) {
            LinkedList<RejectReason> reasons = new LinkedList<RejectReason>();
            for (RejectReason reason : VALUES) {
                if ((reason.mask & bits) != reason.mask) continue;
                reasons.add(reason);
            }
            return reasons;
        }

        static {
            VALUES = RejectReason.values();
        }
    }
}

