/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

import java.text.MessageFormat;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameInvalidException;

public class HdlcAddress {
    private static final int ONE_BYTE_UPPER_BOUND = 127;
    private static final int TWO_BYTE_UPPER_BOUND = 16383;
    private final int byteLength;
    private final int logicalId;
    private int physicalId;

    public HdlcAddress(int logicalId) {
        if (logicalId > 127) {
            throw new IllegalArgumentException(String.format("One byte address exceeded upper bound of 0x%02x.", 127));
        }
        this.byteLength = 1;
        this.logicalId = logicalId;
    }

    public HdlcAddress(int logicalId, int physicalId) {
        int byteLen = Math.max(HdlcAddress.addressSizeOf(logicalId), HdlcAddress.addressSizeOf(physicalId));
        this.byteLength = physicalId == 0 ? byteLen : byteLen * 2;
        this.logicalId = logicalId;
        this.physicalId = physicalId;
    }

    private static int addressSizeOf(int address) {
        if (address <= 127) {
            return 1;
        }
        if (address <= 16383) {
            return 2;
        }
        throw new IllegalArgumentException(String.format("Address 0x%x is out of upper bound 0x%x.", address, 16383));
    }

    public int getLogicalId() {
        return this.logicalId;
    }

    public int getPhysicalId() {
        return this.physicalId;
    }

    public int getLength() {
        return this.byteLength;
    }

    public byte[] encode() {
        int shift;
        int i;
        this.validateAddress();
        int upperLength = (this.byteLength + 1) / 2;
        int lowerLength = this.byteLength / 2;
        byte[] result = new byte[this.byteLength];
        for (i = 0; i < upperLength; ++i) {
            shift = 7 * (upperLength - i - 1);
            result[i] = (byte)((this.logicalId & 127 << shift) >> shift << 1);
        }
        for (i = 0; i < lowerLength; ++i) {
            shift = 7 * (upperLength - i - 1);
            result[upperLength + i] = (byte)((this.physicalId & 127 << shift) >> shift << 1);
        }
        int n = this.byteLength - 1;
        result[n] = (byte)(result[n] | 1);
        return result;
    }

    public static HdlcAddress decode(byte[] data, int length) throws FrameInvalidException {
        int logicalDeviceAddr = 0;
        int physicalDevAddr = 0;
        switch (length) {
            case 1: {
                logicalDeviceAddr = (data[0] & 0xFF) >> 1;
                break;
            }
            case 2: {
                logicalDeviceAddr = (data[0] & 0xFF) >> 1;
                physicalDevAddr = (data[1] & 0xFF) >> 1;
                break;
            }
            case 4: {
                logicalDeviceAddr = (data[0] & 0xFF) >> 1 << 7;
                logicalDeviceAddr |= (data[1] & 0xFF) >> 1;
                physicalDevAddr = (data[2] & 0xFF) >> 1 << 7;
                physicalDevAddr |= (data[3] & 0xFF) >> 1;
                break;
            }
            default: {
                throw new FrameInvalidException("Received HdlcAddress has a invalid bytelength of " + length);
            }
        }
        return new HdlcAddress(logicalDeviceAddr, physicalDevAddr);
    }

    private void validateAddress() throws IllegalArgumentException {
        if (this.byteLength == 1 || this.byteLength == 2 || this.byteLength == 4) {
            int upperLength = (this.byteLength + 1) / 2;
            int lowerLength = this.byteLength / 2;
            if (!((double)this.logicalId >= Math.pow(2.0, 7.0 * (double)upperLength)) && !((double)this.physicalId >= Math.pow(2.0, 7.0 * (double)lowerLength)) && this.logicalId >= 0 && this.physicalId >= 0) {
                return;
            }
        }
        throw new IllegalArgumentException("HdlcAddress has a invalid bytelength");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int ldLength = (this.byteLength + 1) / 2 * 2;
        int phLength = this.byteLength / 2 * 2;
        String formatStr = MessageFormat.format("%0{0}X", ldLength);
        sb.append(String.format(formatStr, this.logicalId));
        if (phLength > 0) {
            sb.append(String.format(MessageFormat.format("-%0{0}X", phLength), this.physicalId));
        }
        return sb.toString();
    }

    public boolean isAllStation() {
        if (this.byteLength == 1 || this.byteLength == 2) {
            return this.logicalId == 127;
        }
        if (this.byteLength == 4) {
            return this.logicalId == 16383;
        }
        return false;
    }

    public boolean isNoStation() {
        return this.logicalId == 0 && this.physicalId == 0;
    }

    public boolean isCalling() {
        if (this.byteLength == 2) {
            return this.physicalId == 126;
        }
        if (this.byteLength == 4) {
            return this.physicalId == 16382;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HdlcAddress)) {
            return false;
        }
        HdlcAddress other = (HdlcAddress)o;
        return this.byteLength == other.byteLength && this.logicalId == other.logicalId && this.physicalId == other.physicalId;
    }

    public int hashCode() {
        return this.logicalId << 16 | this.physicalId;
    }

    public static class ReservedAddresses {
        public static final int NO_STATION = 0;
        public static final HdlcAddress CLIENT_NO_STATION = new HdlcAddress(0);
        public static final HdlcAddress CLIENT_MANAGEMENT_PROCESS = new HdlcAddress(1);
        public static final HdlcAddress CLIENT_PUBLIC_CLIENT = new HdlcAddress(16);
        public static final HdlcAddress CLIENT_ALL_STATION = new HdlcAddress(127);
        public static final int SERVER_UPPER_MANAGEMENT_LOGICAL_DEVICE = 1;
        public static final int SERVER_UPPER_ALL_STATIONS_1BYTE = 127;
        public static final int SERVER_UPPER_ALL_STATIONS_2BYTE = 16383;
        public static final int SERVER_LOWER_CALLING_1BYTE = 126;
        public static final int SERVER_LOWER_CALLING_2BYTE = 16382;

        private ReservedAddresses() {
        }
    }
}

