/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.openmuc.jdlms.FatalJDlmsException;
import org.openmuc.jdlms.JDlmsException;
import org.openmuc.jdlms.RawMessageData;
import org.openmuc.jdlms.RawMessageListener;
import org.openmuc.jdlms.TcpConnectionBuilder;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameInvalidException;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameType;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcAddressPair;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcFrame;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcMessageDecoder;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcParameters;
import org.openmuc.jdlms.settings.client.HdlcSettings;
import org.openmuc.jdlms.settings.client.HdlcTcpSettings;
import org.openmuc.jdlms.settings.client.SerialSettings;
import org.openmuc.jdlms.settings.client.Settings;
import org.openmuc.jdlms.transportlayer.client.Iec21Layer;
import org.openmuc.jdlms.transportlayer.client.TcpLayer;
import org.openmuc.jdlms.transportlayer.client.TransportLayer;
import org.openmuc.jdlms.transportlayer.client.UdpLayer;

public class HdlcDispatcher {
    private static HdlcDispatcher instance;
    private final Map<Object, HdlcConnection> hdlcConnectionMap = new HashMap<Object, HdlcConnection>();

    private HdlcDispatcher() {
    }

    public static synchronized HdlcDispatcher instance() {
        if (instance == null) {
            instance = new HdlcDispatcher();
        }
        return instance;
    }

    public synchronized HdlcConnection connect(HdlcSettings settings, HdlcConnectionListener listener) {
        HdlcConnection hdlcConnection;
        if (settings instanceof HdlcTcpSettings) {
            HdlcTcpSettings inetSettings = (HdlcTcpSettings)settings;
            hdlcConnection = this.hdlcConnectionMap.get(new InetEntry(inetSettings.inetAddress(), inetSettings.port()));
            if (hdlcConnection == null) {
                TransportLayer transportLayer = inetSettings.tranportProtocol() == TcpConnectionBuilder.InetTransportProtocol.TCP ? new TcpLayer(inetSettings) : new UdpLayer(inetSettings);
                hdlcConnection = new HdlcConnection(settings, transportLayer);
            }
        } else if (settings instanceof SerialSettings) {
            SerialSettings serialSettings = (SerialSettings)settings;
            hdlcConnection = this.hdlcConnectionMap.get(serialSettings.serialPortName());
            if (hdlcConnection == null) {
                Iec21Layer transportLayer = new Iec21Layer(serialSettings);
                hdlcConnection = new HdlcConnection(settings, transportLayer);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        hdlcConnection.registerNewListener(settings.addressPair(), listener);
        return hdlcConnection;
    }

    public static interface HdlcConnectionListener {
        public void dataReceived(RawMessageData.RawMessageDataBuilder var1, HdlcFrame var2);

        public void connectionInterrupted(IOException var1);
    }

    public class HdlcConnection {
        private final TransportLayer transportLayer;
        private final Settings settings;
        private final Map<HdlcAddressPair, HdlcConnectionListener> listeners;
        private HdlcAddressPair connectionKey;
        private final BlockingQueue<HdlcFrame> incommingQueue;
        private ExecutorService connectionreaderExecutor;

        private HdlcConnection(Settings settings, TransportLayer transportLayer) {
            this.settings = settings;
            this.transportLayer = transportLayer;
            this.listeners = new LinkedHashMap<HdlcAddressPair, HdlcConnectionListener>();
            this.incommingQueue = new ArrayBlockingQueue<HdlcFrame>(1);
        }

        public synchronized void send(byte[] data) throws IOException {
            this.transportLayer.getOutpuStream().write(data);
            this.transportLayer.getOutpuStream().flush();
        }

        public synchronized HdlcParameters open(HdlcSettings settings) throws IOException {
            if (this.transportLayer.isClosed()) {
                this.transportLayer.open();
                this.connectionreaderExecutor = Executors.newSingleThreadExecutor();
                this.connectionreaderExecutor.execute(new ConnectionReader());
            }
            this.connectionKey = settings.addressPair();
            try {
                HdlcParameters hdlcParameters = this.connectSequence(settings);
                return hdlcParameters;
            }
            catch (IOException ex) {
                this.removeListenerAndTryClosePhysicalLayer(settings);
                throw ex;
            }
            finally {
                this.connectionKey = null;
            }
        }

        public synchronized void disconnect(HdlcSettings settings) throws IOException {
            this.connectionKey = settings.addressPair();
            try {
                this.sendDisconnectSequence(settings);
            }
            finally {
                this.closeAndShutdown(settings);
            }
        }

        private void closeAndShutdown(HdlcSettings settings) throws IOException {
            this.removeListenerAndTryClosePhysicalLayer(settings);
            this.connectionKey = null;
            this.connectionreaderExecutor.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeListenerAndTryClosePhysicalLayer(HdlcSettings settings) throws IOException {
            Map<HdlcAddressPair, HdlcConnectionListener> map = this.listeners;
            synchronized (map) {
                this.listeners.remove(settings.addressPair());
                if (this.listeners.isEmpty()) {
                    this.transportLayer.close();
                }
            }
        }

        private void sendDisconnectSequence(HdlcSettings settings) throws IOException {
            boolean poll = true;
            byte[] dfData = HdlcFrame.newDisconnectFrame(settings.addressPair(), poll).encode();
            this.send(dfData);
            RawMessageListener rawMessageListener = settings.rawMessageListener();
            this.notifyListener(dfData, RawMessageData.MessageSource.CLIENT, rawMessageListener);
            HdlcFrame disconnectAckFrame = this.waitForFrame(settings.responseTimeout());
            if (disconnectAckFrame == null) {
                throw new FatalJDlmsException(JDlmsException.ExceptionId.HDLC_CONNECTION_CLOSE_ERROR, JDlmsException.Fault.SYSTEM, "Didn't receive answer on connection close.");
            }
            this.notifyListener(disconnectAckFrame, RawMessageData.MessageSource.CLIENT, rawMessageListener);
            if (disconnectAckFrame.getFrameType() == FrameType.UNNUMBERED_ACKNOWLEDGE || disconnectAckFrame.getFrameType() == FrameType.DISCONNECT_MODE) {
                // empty if block
            }
        }

        private HdlcFrame waitForFrame(long responseTimeout) {
            HdlcFrame receivedFrame = null;
            try {
                receivedFrame = this.incommingQueue.poll(responseTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return receivedFrame;
        }

        private HdlcParameters connectSequence(HdlcSettings settings) throws IOException {
            boolean pollFinalBit;
            int windowSize;
            int informationLength = settings.hdlcMaxInformationLength();
            HdlcParameters dNegotiation = new HdlcParameters(informationLength, windowSize = 1, informationLength, windowSize);
            HdlcFrame answerFrame = this.sendNRMF(settings, dNegotiation, pollFinalBit = true);
            if (answerFrame.getFrameType() == FrameType.DISCONNECT_MODE) {
                answerFrame = this.sendNRMF(settings, null, pollFinalBit);
            }
            switch (answerFrame.getFrameType()) {
                case UNNUMBERED_ACKNOWLEDGE: {
                    return this.handleUnnumberedAckResponse(answerFrame);
                }
            }
            throw this.handleDisconnectResponse(settings, answerFrame);
        }

        private HdlcFrame sendNRMF(HdlcSettings settings, HdlcParameters dNegotiation, boolean pollFinalBit) throws IOException {
            byte[] snrmData = HdlcFrame.newSetNormalResponseModeFrame(settings.addressPair(), dNegotiation, pollFinalBit).encode();
            RawMessageListener rawMessageListener = settings.rawMessageListener();
            this.notifyListener(snrmData, RawMessageData.MessageSource.CLIENT, rawMessageListener);
            this.send(snrmData);
            HdlcFrame answerFrame = this.waitForFrame(settings.responseTimeout());
            if (answerFrame == null) {
                throw new FatalJDlmsException(JDlmsException.ExceptionId.HDLC_CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, "Didn't receive answer in connection establish process.");
            }
            this.notifyListener(answerFrame, RawMessageData.MessageSource.SERVER, rawMessageListener);
            return answerFrame;
        }

        private void notifyListener(byte[] data, RawMessageData.MessageSource client, RawMessageListener rawMessageListener) {
            if (rawMessageListener == null) {
                return;
            }
            RawMessageData rawMessageData = RawMessageData.builder().setMessageSource(client).setMessage(data).build();
            rawMessageListener.messageCaptured(rawMessageData);
        }

        private void notifyListener(HdlcFrame frame, RawMessageData.MessageSource client, RawMessageListener rawMessageListener) {
            if (rawMessageListener == null) {
                return;
            }
            this.notifyListener(frame.encode(), client, rawMessageListener);
        }

        private FatalJDlmsException handleDisconnectResponse(HdlcSettings settings, HdlcFrame receiveFrame) throws IOException {
            this.closeAndShutdown(settings);
            return new FatalJDlmsException(JDlmsException.ExceptionId.HDLC_CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, MessageFormat.format("Received a {0} frame, while connecting. Connection has been shot down.", new Object[]{receiveFrame.getFrameType()}));
        }

        private HdlcParameters handleUnnumberedAckResponse(HdlcFrame receiveFrame) throws IOException {
            if (receiveFrame.getInformationField() == null) {
                throw new FatalJDlmsException(JDlmsException.ExceptionId.HDLC_CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, "Remote meter didn't return a parameter negotioation.");
            }
            try {
                return HdlcParameters.decode(receiveFrame.getInformationField());
            }
            catch (FrameInvalidException e) {
                throw new FatalJDlmsException(JDlmsException.ExceptionId.HDLC_CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, "Received parameter negotiation, contains errors. Evaluate cause for details.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerNewListener(HdlcAddressPair key, HdlcConnectionListener listener) {
            Map<HdlcAddressPair, HdlcConnectionListener> map = this.listeners;
            synchronized (map) {
                this.listeners.put(key, listener);
            }
        }

        private class ConnectionReader
        implements Runnable {
            private ConnectionReader() {
            }

            @Override
            public void run() {
                Thread.currentThread().setName("HDLC CONNECTION READER");
                try {
                    this.mainLoop();
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (IOException e) {
                    this.notifyAllListners(e);
                }
                finally {
                    this.closeAll();
                }
            }

            private void closeAll() {
                try {
                    HdlcConnection.this.transportLayer.close();
                    HdlcConnection.this.listeners.clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            private void notifyAllListners(IOException e) {
                for (HdlcConnectionListener listener : HdlcConnection.this.listeners.values()) {
                    listener.connectionInterrupted(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void mainLoop() throws IOException {
                while (!HdlcConnection.this.transportLayer.isClosed()) {
                    RawMessageData.RawMessageDataBuilder rawMessageBuilder = null;
                    if (HdlcConnection.this.settings.rawMessageListener() != null) {
                        rawMessageBuilder = RawMessageData.builder();
                    }
                    List<HdlcFrame> frames = HdlcMessageDecoder.decode(rawMessageBuilder, HdlcConnection.this.transportLayer, HdlcConnection.this.settings.responseTimeout());
                    for (HdlcFrame hdlcFrame : frames) {
                        HdlcAddressPair switchedPair = hdlcFrame.getAddressPair().switchedPair();
                        if (HdlcConnection.this.connectionKey != null && HdlcConnection.this.connectionKey.equals(switchedPair)) {
                            try {
                                HdlcConnection.this.incommingQueue.put(hdlcFrame);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        Map map = HdlcConnection.this.listeners;
                        synchronized (map) {
                            HdlcConnectionListener listener = (HdlcConnectionListener)HdlcConnection.this.listeners.get(switchedPair);
                            if (listener != null) {
                                listener.dataReceived(rawMessageBuilder, hdlcFrame);
                            }
                        }
                    }
                }
            }
        }
    }

    private class InetEntry {
        private final int port;
        private final InetAddress inetAddress;

        private InetEntry(InetAddress inetAddress, int port) {
            this.inetAddress = inetAddress;
            this.port = port;
        }

        public int hashCode() {
            return this.inetAddress.hashCode() ^ this.port;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof InetEntry)) {
                return false;
            }
            InetEntry other = (InetEntry)obj;
            return this.port == other.port && this.inetAddress.equals(other.inetAddress);
        }
    }
}

