/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameInvalidException;

public class HdlcParameters {
    private static final byte NUM_WINDOW_SIZE_BYTES = 4;
    public static final int MAX_INFORMATION_LENGTH = 2030;
    public static final int MIN_INFORMATION_LENGTH = 128;
    public static final int MIN_WINDOW_SIZE = 1;
    public static final int MAX_WINDOW_SIZE = 7;
    private static final byte MAX_TRANS_INFO_LENGTH_ID = 5;
    private static final byte MAX_REC_INFO_LENGTH_ID = 6;
    private static final byte TRANS_WINDOW_SIZE_ID = 7;
    private static final byte REC_WINDOW_SIZE_ID = 8;
    private static final byte FORMAT_IDENTIFIER = -127;
    private static final byte HDLC_PARAM_IDENTIFIER = -128;
    private static final byte USER_PARAM_IDENTIFIER = -16;
    private int maxTransmitInformationLength;
    private int maxReceiveInformationLength;
    private int transmitWindowSize;
    private int receiveWindowSize;

    public HdlcParameters() {
        this.maxTransmitInformationLength = 2030;
        this.maxReceiveInformationLength = 2030;
        this.transmitWindowSize = 1;
        this.receiveWindowSize = 1;
    }

    public HdlcParameters(int transmitInformationLength, int transmitWindowSize) {
        this(128, 1, transmitInformationLength, transmitWindowSize);
    }

    public HdlcParameters(int receiveInformationLength, int receiveWindowSize, int transmitInformationLength, int transmitWindowSize) {
        this.maxReceiveInformationLength = HdlcParameters.valueConsiderInformationLength(receiveInformationLength);
        this.receiveWindowSize = HdlcParameters.valueConsiderWindowSize(receiveWindowSize);
        this.maxTransmitInformationLength = HdlcParameters.valueConsiderInformationLength(transmitInformationLength);
        this.transmitWindowSize = HdlcParameters.valueConsiderWindowSize(transmitWindowSize);
    }

    public int getTransmitInformationLength() {
        return this.maxTransmitInformationLength;
    }

    public int getTransmitWindowSize() {
        return this.transmitWindowSize;
    }

    public int getReceiveInformationLength() {
        return this.maxReceiveInformationLength;
    }

    public int getReceiveWindowSize() {
        return this.receiveWindowSize;
    }

    public String toString() {
        return MessageFormat.format("'{'\"maxTransmitInformationLength\": {0}, \"transmitWindowSize\": {1}, \"maxReceiveInformationLength\": {2}, \"receiveWindowSize\": {3}'}'", this.maxTransmitInformationLength, this.transmitWindowSize, this.maxReceiveInformationLength, this.receiveWindowSize);
    }

    private static int valueConsiderWindowSize(int value) {
        return HdlcParameters.valueConsiderRange(1, 7, value);
    }

    private static int valueConsiderInformationLength(int value) {
        return HdlcParameters.valueConsiderRange(128, 2030, value);
    }

    private static int valueConsiderRange(int lowerBound, int upperBound, int value) {
        int maxLowValue = Math.max(lowerBound, value);
        return Math.min(maxLowValue, upperBound);
    }

    public static HdlcParameters decode(byte[] data) throws FrameInvalidException {
        ByteBuffer bBuf = ByteBuffer.wrap(data);
        HdlcParameters parameterNegotiation = new HdlcParameters();
        byte nextByte = bBuf.get();
        if (nextByte != -127) {
            throw new FrameInvalidException("Information field is no HDLC parameter negotiation");
        }
        nextByte = bBuf.get();
        while (bBuf.hasRemaining()) {
            if (nextByte == -16) {
                HdlcParameters.readUserId(bBuf);
                continue;
            }
            if (nextByte != -128) continue;
            HdlcParameters.readParamId(bBuf, parameterNegotiation);
        }
        return parameterNegotiation;
    }

    private static void readUserId(ByteBuffer bBuf) {
        byte length = bBuf.get();
        bBuf.position(bBuf.position() + length);
    }

    private static void readParamId(ByteBuffer bBuf, HdlcParameters parameterNegotiation) throws FrameInvalidException {
        byte paramLength;
        block6: for (int numOfRemainingBytes = bBuf.get(); numOfRemainingBytes > 0; numOfRemainingBytes -= 2 + paramLength) {
            byte paramIdent = bBuf.get();
            paramLength = bBuf.get();
            int val = HdlcParameters.readData(bBuf, paramLength);
            switch (paramIdent) {
                case 5: {
                    HdlcParameters.checkLength(val);
                    parameterNegotiation.maxTransmitInformationLength = val;
                    continue block6;
                }
                case 6: {
                    HdlcParameters.checkLength(val);
                    parameterNegotiation.maxReceiveInformationLength = val;
                    continue block6;
                }
                case 7: {
                    HdlcParameters.checkWindowSize(val);
                    parameterNegotiation.transmitWindowSize = val;
                    continue block6;
                }
                case 8: {
                    HdlcParameters.checkWindowSize(val);
                    parameterNegotiation.receiveWindowSize = val;
                    continue block6;
                }
                default: {
                    throw new FrameInvalidException("Hdlc parameter unknown");
                }
            }
        }
    }

    private static void checkWindowSize(int val) throws FrameInvalidException {
        if (val < 1 || val > 7) {
            throw new FrameInvalidException("Window size is out of range: " + val);
        }
    }

    private static void checkLength(int val) throws FrameInvalidException {
        if (val < 32 || val > 2030) {
            throw new FrameInvalidException("Max info length is out of range: " + val);
        }
    }

    private static int readData(ByteBuffer bBuf, int length) {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result = result << 8 | bBuf.get() & 0xFF;
        }
        return result;
    }

    public byte[] encode() {
        byte[] maxReceiveInformationData;
        byte[] maxTransmitInformationData;
        byte numInfoLengthBytes;
        if (this.maxTransmitInformationLength <= 255 && this.maxReceiveInformationLength <= 255) {
            numInfoLengthBytes = 1;
            maxTransmitInformationData = ByteBuffer.allocate(numInfoLengthBytes).put((byte)this.maxTransmitInformationLength).array();
            maxReceiveInformationData = ByteBuffer.allocate(numInfoLengthBytes).put((byte)this.maxReceiveInformationLength).array();
        } else {
            numInfoLengthBytes = 2;
            maxTransmitInformationData = ByteBuffer.allocate(numInfoLengthBytes).putShort((short)this.maxTransmitInformationLength).array();
            maxReceiveInformationData = ByteBuffer.allocate(numInfoLengthBytes).putShort((short)this.maxReceiveInformationLength).array();
        }
        int numOfBytes = 11 + numInfoLengthBytes * 2 + 8;
        byte infoLength = (byte)(numOfBytes - 3);
        return ByteBuffer.allocate(numOfBytes).put((byte)-127).put((byte)-128).put(infoLength).put((byte)5).put(numInfoLengthBytes).put(maxTransmitInformationData).put((byte)6).put(numInfoLengthBytes).put(maxReceiveInformationData).put((byte)7).put((byte)4).putInt(this.transmitWindowSize).put((byte)8).put((byte)4).putInt(this.receiveWindowSize).array();
    }
}

