/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.transportlayer.client;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.openmuc.jdlms.FatalJDlmsException;
import org.openmuc.jdlms.HexConverter;
import org.openmuc.jdlms.JDlmsException;
import org.openmuc.jdlms.settings.client.SerialSettings;
import org.openmuc.jdlms.transportlayer.client.TransportLayer;
import org.openmuc.jrxtx.DataBits;
import org.openmuc.jrxtx.Parity;
import org.openmuc.jrxtx.SerialPort;
import org.openmuc.jrxtx.SerialPortBuilder;
import org.openmuc.jrxtx.StopBits;

public class Iec21Layer
implements TransportLayer {
    private static final int CR = 13;
    private static final int LF = 10;
    private static final byte[] REQUEST_MSG_1 = new byte[]{47, 63};
    private static final byte[] REQUEST_MSG_3 = new byte[]{33, 13, 10};
    private static final byte[] ACKNOWLEDGE = new byte[]{6, 50, 48, 50, 13, 10};
    private SerialPort serialPort;
    private final SerialSettings settings;
    private boolean closed;
    private DataInputStream is;
    private DataOutputStream os;

    public Iec21Layer(SerialSettings settings) {
        this.settings = settings;
        this.closed = true;
    }

    @Override
    public void setTimeout(int timeout) throws IOException {
        try {
            this.serialPort.setSerialPortTimeout(timeout);
        }
        catch (IOException e) {
            throw new FatalJDlmsException(JDlmsException.ExceptionId.JRXTX_INCOMPATIBLE_TO_OS, JDlmsException.Fault.SYSTEM, "RXTX is not compatible to your OS.", e);
        }
    }

    @Override
    public DataInputStream getInputStream() throws IOException {
        return this.is;
    }

    @Override
    public DataOutputStream getOutpuStream() throws IOException {
        return this.os;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void open() throws IOException {
        if (this.isClosed()) {
            try {
                if (this.settings.iec21Handshake() == DataFlowControl.ENABLED) {
                    this.connectWithHandshake();
                } else {
                    this.serialPort = Iec21Layer.connectWithoutHandshake(this.settings);
                    this.setStreams();
                }
            }
            catch (IOException e) {
                if (this.serialPort != null) {
                    this.serialPort.close();
                }
                throw e;
            }
            this.closed = false;
        }
    }

    private void setStreams() throws IOException {
        this.is = new DataInputStream(this.serialPort.getInputStream());
        this.os = new DataOutputStream(this.serialPort.getOutputStream());
    }

    private void connectWithHandshake() throws IOException {
        char baudRateSetting;
        byte[] iec21AddressBytes = this.settings.iec21Address().trim().getBytes(StandardCharsets.US_ASCII);
        this.serialPort = SerialPortBuilder.newBuilder((String)this.settings.serialPortName()).setBaudRate(300).setDataBits(DataBits.DATABITS_7).setStopBits(StopBits.STOPBITS_1).setParity(Parity.EVEN).build();
        this.setStreams();
        this.serialPort.setSerialPortTimeout(2000);
        byte[] requestMsg = ByteBuffer.allocate(REQUEST_MSG_1.length + iec21AddressBytes.length + REQUEST_MSG_3.length).put(REQUEST_MSG_1).put(iec21AddressBytes).put(REQUEST_MSG_3).array();
        this.write(requestMsg);
        try {
            baudRateSetting = this.listenForIdentificationMessage();
        }
        catch (FatalJDlmsException e) {
            throw e;
        }
        catch (InterruptedIOException e) {
            throw new FatalJDlmsException(JDlmsException.ExceptionId.IEC_21_CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, MessageFormat.format("Send request message: {0}. Request timed out.", HexConverter.toShortHexString(requestMsg)), e);
        }
        catch (IOException e) {
            throw new FatalJDlmsException(JDlmsException.ExceptionId.IEC_21_CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, MessageFormat.format("Send request message: {0}.", HexConverter.toShortHexString(requestMsg)), e);
        }
        int baudRate = Iec21Layer.baudRateFor(baudRateSetting);
        byte[] ackClone = ACKNOWLEDGE;
        ackClone[2] = (byte)baudRateSetting;
        this.write(ackClone);
        try {
            Thread.sleep(this.settings.baudrateChangeDelay());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.serialPort.setBaudRate(baudRate);
        this.serialPort.setDataBits(DataBits.DATABITS_7);
        this.serialPort.setStopBits(StopBits.STOPBITS_1);
        this.serialPort.setParity(Parity.EVEN);
        this.listenForAck();
        this.serialPort.setDataBits(DataBits.DATABITS_8);
        this.serialPort.setParity(Parity.NONE);
    }

    private static SerialPort connectWithoutHandshake(SerialSettings settings) throws IOException {
        return SerialPortBuilder.newBuilder((String)settings.serialPortName()).setBaudRate(settings.baudrate()).setDataBits(DataBits.DATABITS_8).setStopBits(StopBits.STOPBITS_1).setParity(Parity.NONE).build();
    }

    private void write(byte[] data) throws IOException {
        this.getOutpuStream().write(data);
        this.getOutpuStream().flush();
    }

    @Override
    public void close() {
        try {
            this.serialPort.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    private static int baudRateFor(char baudCharacter) throws IOException {
        switch (baudCharacter) {
            case '0': {
                return 300;
            }
            case '1': {
                return 600;
            }
            case '2': {
                return 1200;
            }
            case '3': {
                return 2400;
            }
            case '4': {
                return 4800;
            }
            case '5': {
                return 9600;
            }
            case '6': {
                return 19200;
            }
        }
        throw new FatalJDlmsException(JDlmsException.ExceptionId.IEC_21_CONNECTION_ESTABLISH_ERROR, JDlmsException.Fault.SYSTEM, String.format("Syntax error in identification message received: unknown baud rate received. Baud character was 0x%02X or char '%s'.", (byte)baudCharacter, String.valueOf(baudCharacter)));
    }

    private void listenForAck() throws IOException {
        int ackLength;
        byte[] ackMsg = new byte[ACKNOWLEDGE.length];
        try {
            ackLength = this.getInputStream().read(ackMsg);
        }
        catch (IOException e) {
            throw new FatalJDlmsException(JDlmsException.ExceptionId.IEC_21_WRONG_BAUD_RATE_CHANGE_DELAY, JDlmsException.Fault.SYSTEM, "Failed to read ACK message.", e);
        }
        if (ackLength != ackMsg.length) {
            throw new FatalJDlmsException(JDlmsException.ExceptionId.IEC_21_UNKNOWN_ACK_MSG, JDlmsException.Fault.SYSTEM, "Received unknown ACK answer.");
        }
    }

    private char listenForIdentificationMessage() throws IOException {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            int b;
            while ((b = this.getInputStream().read()) != 13) {
                byteStream.write(b);
            }
            byteStream.write(b);
            b = this.getInputStream().read();
            byteStream.write(b);
            byte[] response = byteStream.toByteArray();
            char c = (char)response[4];
            return c;
        }
    }

    public static enum DataFlowControl {
        ENABLED,
        DISABLED;

    }
}

