/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml;

import java.util.List;
import org.openmuc.jsml.structures.EMessageBody;
import org.openmuc.jsml.structures.SmlFile;
import org.openmuc.jsml.structures.SmlMessage;
import org.openmuc.jsml.structures.requests.SmlGetListReq;
import org.openmuc.jsml.structures.requests.SmlGetProcParameterReq;
import org.openmuc.jsml.structures.requests.SmlGetProfileListReq;
import org.openmuc.jsml.structures.requests.SmlGetProfilePackReq;
import org.openmuc.jsml.structures.requests.SmlPublicCloseReq;
import org.openmuc.jsml.structures.requests.SmlPublicOpenReq;
import org.openmuc.jsml.structures.requests.SmlSetProcParameterReq;
import org.openmuc.jsml.structures.responses.SmlAttentionRes;
import org.openmuc.jsml.structures.responses.SmlGetListRes;
import org.openmuc.jsml.structures.responses.SmlGetProcParameterRes;
import org.openmuc.jsml.structures.responses.SmlGetProfileListRes;
import org.openmuc.jsml.structures.responses.SmlGetProfilePackRes;
import org.openmuc.jsml.structures.responses.SmlPublicCloseRes;
import org.openmuc.jsml.structures.responses.SmlPublicOpenRes;

public class GenericParser {
    public static void printFile(SmlFile smlFile) {
        List<SmlMessage> smlMessages = smlFile.getMessages();
        block16: for (SmlMessage smlMessage : smlMessages) {
            EMessageBody messageBody = smlMessage.getMessageBody().getTag();
            switch (messageBody) {
                case OPEN_REQUEST: {
                    GenericParser.parseOpenRequest(smlMessage);
                    continue block16;
                }
                case OPEN_RESPONSE: {
                    GenericParser.parseOpenResponse(smlMessage);
                    continue block16;
                }
                case CLOSE_REQUEST: {
                    GenericParser.parseCloseRequest(smlMessage);
                    continue block16;
                }
                case CLOSE_RESPONSE: {
                    GenericParser.parseCloseResponse(smlMessage);
                    continue block16;
                }
                case GET_PROFILE_PACK_REQUEST: {
                    GenericParser.parseGetProfilePackRequest(smlMessage);
                    continue block16;
                }
                case GET_PROFILE_PACK_RESPONSE: {
                    GenericParser.parseGetProfilePackResponse(smlMessage);
                    continue block16;
                }
                case GET_PROFILE_LIST_REQUEST: {
                    GenericParser.parseGetProfileListRequest(smlMessage);
                    continue block16;
                }
                case GET_PROFILE_LIST_RESPONSE: {
                    GenericParser.parseGetProfileListResponse(smlMessage);
                    continue block16;
                }
                case GET_PROC_PARAMETER_REQUEST: {
                    GenericParser.parseGetProcParameterRequest(smlMessage);
                    continue block16;
                }
                case GET_PROC_PARAMETER_RESPONSE: {
                    GenericParser.parseGetProcParameterResponse(smlMessage);
                    continue block16;
                }
                case SET_PROC_PARAMETER_REQUEST: {
                    GenericParser.parseSetProcParameterRequest(smlMessage);
                    continue block16;
                }
                case GET_LIST_REQUEST: {
                    GenericParser.parseGetListRequest(smlMessage);
                    continue block16;
                }
                case GET_LIST_RESPONSE: {
                    GenericParser.parseGetListResponse(smlMessage);
                    continue block16;
                }
                case ATTENTION_RESPONSE: {
                    GenericParser.parseAttentionResponse(smlMessage);
                    continue block16;
                }
            }
            GenericParser.println("type not found");
        }
    }

    private static void parseGetListResponse(SmlMessage smlMessage) {
        GenericParser.println("Got GetListResponse");
        SmlGetListRes smlListRes = (SmlGetListRes)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlListRes.toStringIndent(" "));
    }

    private static void parseAttentionResponse(SmlMessage smlMessage) {
        GenericParser.println("Got AttentionResponse");
        SmlAttentionRes smlAttentionRes = (SmlAttentionRes)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlAttentionRes.toString());
    }

    private static void parseGetProcParameterResponse(SmlMessage smlMessage) {
        GenericParser.println("Got GetProcParameterResponse");
        SmlGetProcParameterRes smlGetProcParameterRes = (SmlGetProcParameterRes)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlGetProcParameterRes.toString());
    }

    private static void parseGetProfileListResponse(SmlMessage smlMessage) {
        GenericParser.println("Got GetProfileListResponse");
        SmlGetProfileListRes smlGetProfileListRes = (SmlGetProfileListRes)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlGetProfileListRes.toString());
    }

    private static void parseOpenResponse(SmlMessage smlMessage) {
        GenericParser.println("Got OpenResponse");
        SmlPublicOpenRes smlPublicOpenRes = (SmlPublicOpenRes)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlPublicOpenRes.toString());
    }

    private static void parseCloseResponse(SmlMessage smlMessage) {
        GenericParser.println("Got CloseResponse");
        SmlPublicCloseRes smlPublicCloseRes = (SmlPublicCloseRes)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlPublicCloseRes.toString());
    }

    private static void parseGetProfilePackResponse(SmlMessage smlMessage) {
        GenericParser.println("Got GetProfilePackResponse");
        SmlGetProfilePackRes smlGetProfilePackRes = (SmlGetProfilePackRes)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlGetProfilePackRes.toString());
    }

    private static void parseOpenRequest(SmlMessage smlMessage) {
        GenericParser.println("Got OpenRequest");
        SmlPublicOpenReq smlPublicOpenReq = (SmlPublicOpenReq)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlPublicOpenReq.toString());
    }

    private static void parseCloseRequest(SmlMessage smlMessage) {
        GenericParser.println("Got CloseRequest");
        SmlPublicCloseReq smlPublicCloseRes = (SmlPublicCloseReq)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlPublicCloseRes.toString());
    }

    private static void parseGetProfileListRequest(SmlMessage smlMessage) {
        GenericParser.println("Got GetProfileListRequest");
        SmlGetProfileListReq smlGetProfileListReq = (SmlGetProfileListReq)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlGetProfileListReq.toString());
    }

    private static void parseGetProfilePackRequest(SmlMessage smlMessage) {
        GenericParser.println("Got GetProfilePackRequest");
        SmlGetProfilePackReq smlGetProfilePackReq = (SmlGetProfilePackReq)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlGetProfilePackReq.toString());
    }

    private static void parseGetProcParameterRequest(SmlMessage smlMessage) {
        GenericParser.println("Got GetProcParameterRequest");
        SmlGetProcParameterReq smlGetProcParameterReq = (SmlGetProcParameterReq)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlGetProcParameterReq.toString());
    }

    private static void parseSetProcParameterRequest(SmlMessage smlMessage) {
        GenericParser.println("Got SetProcParameterRequest");
        SmlSetProcParameterReq smlSetProcParameterReq = (SmlSetProcParameterReq)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlSetProcParameterReq.toString());
    }

    private static void parseGetListRequest(SmlMessage smlMessage) {
        GenericParser.println("Got GetListRequest");
        SmlGetListReq smlGetListReq = (SmlGetListReq)smlMessage.getMessageBody().getChoice();
        GenericParser.println(smlGetListReq.toString());
    }

    private static void println(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string);
        }
        System.out.println(sb);
    }

    private GenericParser() {
    }
}

