/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class OriginHeaderFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req;
        String header;
        if (request instanceof HttpServletRequest && (header = (req = (HttpServletRequest)request).getHeader("Origin")) != null && header.startsWith("file://")) {
            final ArrayList headerNames = new ArrayList(Collections.list(req.getHeaderNames()));
            headerNames.remove("Origin");
            HttpServletRequestWrapper newReq = new HttpServletRequestWrapper(req){

                public Enumeration<String> getHeaderNames() {
                    return Collections.enumeration(headerNames);
                }

                public Enumeration<String> getHeaders(String name) {
                    if ("origin".equalsIgnoreCase(name)) {
                        return Collections.emptyEnumeration();
                    }
                    return super.getHeaders(name);
                }

                public String getHeader(String name) {
                    if ("origin".equalsIgnoreCase(name)) {
                        return null;
                    }
                    return super.getHeader(name);
                }
            };
            chain.doFilter((ServletRequest)newReq, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

