/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class StoreRequestPropertiesFilter
implements Filter {
    private String m_servletPathAttribute;
    private String m_relativeServletPathAttribute;

    public void init(FilterConfig config) throws ServletException {
        this.m_servletPathAttribute = config.getInitParameter("servletPathAttribute");
        this.m_relativeServletPathAttribute = config.getInitParameter("relativeServletPathAttribute");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.m_servletPathAttribute != null) {
            request.setAttribute(this.m_servletPathAttribute, (Object)httpRequest.getServletPath());
        }
        if (this.m_relativeServletPathAttribute != null) {
            String servletPath = httpRequest.getServletPath();
            if (servletPath != null && servletPath.length() > 0 && servletPath.charAt(0) == '/') {
                servletPath = servletPath.substring(1);
            }
            request.setAttribute(this.m_relativeServletPathAttribute, (Object)servletPath);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

