/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.interop;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.core.json.serialization.ProvDeserialiser;
import org.openprovenance.prov.interop.DeserializerFunction;
import org.openprovenance.prov.interop.DeserializerFunction2;
import org.openprovenance.prov.interop.InteropException;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.DateTimeOption;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.interop.Formats;
import org.openprovenance.prov.model.interop.InteropMediaType;

public class Inputer
implements InteropMediaType {
    static Logger logger = LogManager.getLogger(Inputer.class);
    private final InteropFramework interopFramework;
    static String SEPARATOR = ",";
    private final ProvFactory pFactory;
    final Map<Formats.ProvFormat, DeserializerFunction> deserializerMap;
    final Map<Formats.ProvFormat, DeserializerFunction2> deserializerMap2;
    List<Formats.ProvFormat> preferredOrder = List.of(Formats.ProvFormat.PROVN, Formats.ProvFormat.JSONLD, Formats.ProvFormat.JSON, Formats.ProvFormat.PROVX);

    public Inputer(InteropFramework interopFramework, ProvFactory pFactory) {
        this.interopFramework = interopFramework;
        this.pFactory = pFactory;
        this.deserializerMap = this.createDeserializerMap();
        this.deserializerMap2 = this.createDeserializerMap2();
    }

    private Map<Formats.ProvFormat, DeserializerFunction> createDeserializerMap() {
        HashMap<Formats.ProvFormat, DeserializerFunction> deserializer = new HashMap<Formats.ProvFormat, DeserializerFunction>();
        deserializer.putAll(Map.of(Formats.ProvFormat.PROVN, () -> new org.openprovenance.prov.notation.ProvDeserialiser(this.pFactory, this.interopFramework.getConfig().dateTime, this.interopFramework.getConfig().timeZone), Formats.ProvFormat.PROVX, () -> new org.openprovenance.prov.core.xml.serialization.ProvDeserialiser(this.interopFramework.getConfig().dateTime, this.interopFramework.getConfig().timeZone), Formats.ProvFormat.JSONLD, () -> new org.openprovenance.prov.core.jsonld11.serialization.ProvDeserialiser(new ObjectMapper(), this.interopFramework.getConfig().dateTime, this.interopFramework.getConfig().timeZone), Formats.ProvFormat.JSON, () -> new ProvDeserialiser(new ObjectMapper(), this.interopFramework.getConfig().dateTime, this.interopFramework.getConfig().timeZone)));
        return deserializer;
    }

    public final Map<Formats.ProvFormat, DeserializerFunction2> createDeserializerMap2() {
        HashMap<Formats.ProvFormat, DeserializerFunction2> deserializer = new HashMap<Formats.ProvFormat, DeserializerFunction2>();
        deserializer.putAll(Map.of(Formats.ProvFormat.PROVN, (dateTime, timeZone) -> new org.openprovenance.prov.notation.ProvDeserialiser(this.pFactory, dateTime, timeZone), Formats.ProvFormat.PROVX, (dateTime, timeZone) -> new org.openprovenance.prov.core.xml.serialization.ProvDeserialiser(dateTime, timeZone), Formats.ProvFormat.JSONLD, (dateTime, timeZone) -> new org.openprovenance.prov.core.jsonld11.serialization.ProvDeserialiser(new ObjectMapper(), dateTime, timeZone), Formats.ProvFormat.JSON, (dateTime, timeZone) -> new ProvDeserialiser(new ObjectMapper(), dateTime, timeZone)));
        return deserializer;
    }

    Document deserialiseDocument(InputStream is, Formats.ProvFormat format) throws IOException {
        DeserializerFunction deserializer = this.interopFramework.getDeserializerMap().get(format);
        logger.debug("deserializer " + String.valueOf(format) + " " + String.valueOf(deserializer));
        return deserializer.apply().deserialiseDocument(is);
    }

    Document deserialiseDocument(InputStream is, Formats.ProvFormat format, DateTimeOption dateTimeOption, TimeZone timeZone) throws IOException {
        DeserializerFunction2 deserializer = this.interopFramework.getDeserializerMap2().get(format);
        logger.debug("deserializer " + String.valueOf(format) + " " + String.valueOf(deserializer));
        return deserializer.apply(dateTimeOption, timeZone).deserialiseDocument(is);
    }

    Document readDocument(String filename, String format) throws IOException {
        Document doc;
        Formats.ProvFormat informat;
        if (format != null) {
            informat = this.interopFramework.getTypeForFormat(format);
            if (informat == null) {
                throw new InteropException("Unknown format: " + format);
            }
        } else {
            informat = this.interopFramework.getTypeForFile(filename);
            if (informat == null) {
                throw new InteropException("Unknown file format for: " + filename);
            }
        }
        if (Objects.equals(filename, "-")) {
            if (informat == null) {
                throw new InteropException("File format for standard input not specified");
            }
            doc = this.deserialiseDocument(System.in, informat);
        } else {
            doc = this.deserialiseDocument(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]), informat);
        }
        return doc;
    }

    Document readDocument(ToRead something) throws IOException {
        Document doc = null;
        switch (something.kind.ordinal()) {
            case 0: {
                doc = this.deserialiseDocument(Files.newInputStream(Paths.get(something.url, new String[0]), new OpenOption[0]), something.format);
                break;
            }
            case 1: {
                doc = this.readDocumentFromURL(something.url);
            }
        }
        return doc;
    }

    Document readDocumentFromFile(String filename, DateTimeOption dateTimeOption, TimeZone timeZone) {
        Formats.ProvFormat format = this.interopFramework.getTypeForFile(filename);
        if (format == null) {
            throw new InteropException("Unknown output file format: " + filename);
        }
        try {
            return this.deserialiseDocument(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]), format, dateTimeOption, timeZone);
        }
        catch (IOException e) {
            throw new InteropException(e);
        }
    }

    Document readDocumentFromFile(String filename) {
        Formats.ProvFormat format = this.interopFramework.getTypeForFile(filename);
        if (format == null) {
            throw new InteropException("Unknown output file format: " + filename);
        }
        try {
            return this.deserialiseDocument(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]), format);
        }
        catch (IOException e) {
            throw new InteropException(e);
        }
    }

    Document readDocumentFromFileWithUnknownType(String filename) {
        for (Formats.ProvFormat format : this.preferredOrder) {
            try {
                return this.interopFramework.getDeserializerMap().get(format).apply().deserialiseDocument(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]));
            }
            catch (IOException iOException) {
            }
        }
        System.out.println("Unparseable format " + filename);
        throw new UnsupportedOperationException("Unparseable format " + filename);
    }

    Document readDocumentFromFileWithUnknownType(String filename, DateTimeOption dateTimeOption, TimeZone timeZone) {
        for (Formats.ProvFormat format : this.preferredOrder) {
            try {
                return this.interopFramework.getDeserializerMap2().get(format).apply(dateTimeOption, timeZone).deserialiseDocument(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]));
            }
            catch (IOException iOException) {
            }
        }
        System.out.println("Unparseable format " + filename);
        throw new UnsupportedOperationException("Unparseable format " + filename);
    }

    Document readDocumentFromURL(String url) {
        try {
            URL theURL = new URL(url);
            URLConnection conn = this.interopFramework.connectWithRedirect(theURL);
            if (conn == null) {
                return null;
            }
            Formats.ProvFormat format = null;
            String content_type = conn.getContentType();
            logger.debug("Content-type: " + content_type);
            if (content_type != null) {
                int end = content_type.indexOf(";");
                if (end < 0) {
                    end = content_type.length();
                }
                String actual_content_type = content_type.substring(0, end).trim();
                logger.debug("Found Content-type: " + actual_content_type);
                format = this.interopFramework.getMimeTypeRevMap().get(actual_content_type);
            }
            logger.debug("Format after Content-type: " + String.valueOf(format));
            if (format == null) {
                format = this.interopFramework.getTypeForFile(theURL.toString());
            }
            logger.debug("Format after extension: " + String.valueOf(format));
            InputStream content_stream = conn.getInputStream();
            return this.deserialiseDocument(content_stream, format);
        }
        catch (IOException e) {
            throw new InteropException(e);
        }
    }

    List<ToRead> readIndexFile(File fin) throws IOException {
        FileInputStream fis = new FileInputStream(fin);
        return this.readIndexFile(fis);
    }

    List<ToRead> readIndexFile(InputStream is) throws IOException {
        String line;
        LinkedList<ToRead> res = new LinkedList<ToRead>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            String[] parts = line.split(SEPARATOR);
            if (parts.length >= 3) {
                FileKind kind = parts[0].trim().equals("URL") ? FileKind.URL : FileKind.FILE;
                String path = parts[1].trim();
                Formats.ProvFormat format = this.interopFramework.getTypeForFormat(parts[2].trim());
                ToRead elem = new ToRead(kind, path, format);
                res.add(elem);
                continue;
            }
            if (parts.length != 1) continue;
            String filename = parts[0].trim();
            ToRead elem = new ToRead(FileKind.FILE, filename, this.interopFramework.getTypeForFile(filename));
            res.add(elem);
        }
        br.close();
        return res;
    }

    static class ToRead {
        FileKind kind;
        String url;
        Formats.ProvFormat format;

        public String toString() {
            return "[" + String.valueOf((Object)this.kind) + "," + this.url + "," + String.valueOf(this.format) + "]";
        }

        ToRead(FileKind kind, String url, Formats.ProvFormat format) {
            this.kind = kind;
            this.url = url;
            this.format = format;
        }
    }

    static enum FileKind {
        FILE,
        URL;

    }
}

