/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.util.Hashtable;
import java.util.List;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;

public class NamespaceGatherer
implements StatementAction {
    static ProvUtilities pu = new ProvUtilities();
    private final Namespace ns = new Namespace();

    public NamespaceGatherer() {
        this.ns.addKnownNamespaces();
        this.ns.setDefaultNamespace(null);
    }

    public NamespaceGatherer(Hashtable<String, String> prefixes, String defaultNamespace) {
        this.ns.getPrefixes().putAll(prefixes);
        this.ns.setDefaultNamespace(defaultNamespace);
    }

    public static Namespace accumulateAllNamespaces(Document document) {
        Namespace res = new Namespace(document.getNamespace());
        for (Bundle b : pu.getNamedBundle(document)) {
            Namespace ns = b.getNamespace();
            if (ns == null) continue;
            res.extendWith(ns);
        }
        return res;
    }

    public Namespace getNamespace() {
        return this.ns;
    }

    public void registerLocation(List<Location> locations) {
        for (Location loc : locations) {
            this.register(loc);
        }
    }

    public void registerPotentialQualifiedName(Object o) {
        if (o instanceof QualifiedName) {
            this.register((QualifiedName)o);
        }
    }

    public void register(Location loc) {
        if (loc != null) {
            this.register(loc.getType());
            Object val = loc.getValue();
            this.registerPotentialQualifiedName(val);
        }
    }

    public void registerType(List<Type> types) {
        for (Type typ : types) {
            this.register(typ);
        }
    }

    public void register(Type typ) {
        this.register(typ.getType());
        Object val = typ.getValue();
        this.registerPotentialQualifiedName(val);
    }

    public void registerRole(List<Role> roles) {
        for (Role rol : roles) {
            this.register(rol);
        }
    }

    public void register(Role rol) {
        this.register(rol.getType());
        Object val = rol.getValue();
        this.registerPotentialQualifiedName(val);
    }

    public void registerOther(List<Other> others) {
        for (Other other : others) {
            this.register(other);
        }
    }

    public void register(Other other) {
        this.register(other.getType());
        this.register(other.getElementName());
        Object val = other.getValue();
        this.registerPotentialQualifiedName(val);
    }

    public void registerValue(Value val2) {
        if (val2 != null) {
            this.register(val2.getType());
            Object val = val2.getValue();
            this.registerPotentialQualifiedName(val);
        }
    }

    void register(QualifiedName name) {
        if (name == null) {
            return;
        }
        String namespace = name.getNamespaceURI();
        String prefix = name.getPrefix();
        if (prefix == null || prefix.equals("")) {
            this.ns.registerDefault(namespace);
        } else {
            this.ns.register(prefix, namespace);
        }
    }

    @Override
    public void doAction(HadMember mem) {
        this.register(mem.getCollection());
        for (QualifiedName i : mem.getEntity()) {
            this.register(i);
        }
    }

    @Override
    public void doAction(QualifiedHadMember mem) {
        this.register(mem.getId());
        this.register(mem.getCollection());
        for (QualifiedName i : mem.getEntity()) {
            this.register(i);
        }
        this.registerType(mem.getType());
        this.registerOther(mem.getOther());
        this.registerProvExt();
    }

    @Override
    public void doAction(SpecializationOf spec) {
        this.register(spec.getGeneralEntity());
        this.register(spec.getSpecificEntity());
    }

    @Override
    public void doAction(QualifiedSpecializationOf spec) {
        this.register(spec.getId());
        this.register(spec.getGeneralEntity());
        this.register(spec.getSpecificEntity());
        this.registerType(spec.getType());
        this.registerOther(spec.getOther());
        this.registerProvExt();
    }

    @Override
    public void doAction(QualifiedAlternateOf alt) {
        this.register(alt.getId());
        this.register(alt.getAlternate1());
        this.register(alt.getAlternate2());
        this.registerType(alt.getType());
        this.registerOther(alt.getOther());
        this.registerProvExt();
    }

    public void registerProvExt() {
    }

    @Override
    public void doAction(MentionOf men) {
        this.register(men.getBundle());
        this.register(men.getGeneralEntity());
        this.register(men.getSpecificEntity());
    }

    @Override
    public void doAction(AlternateOf alt) {
        this.register(alt.getAlternate1());
        this.register(alt.getAlternate2());
    }

    @Override
    public void doAction(WasInfluencedBy inf) {
        this.register(inf.getId());
        this.register(inf.getInfluencee());
        this.register(inf.getInfluencer());
        this.registerType(inf.getType());
        this.registerOther(inf.getOther());
    }

    @Override
    public void doAction(ActedOnBehalfOf del) {
        this.register(del.getId());
        this.register(del.getDelegate());
        this.register(del.getResponsible());
        this.register(del.getActivity());
        this.registerType(del.getType());
        this.registerOther(del.getOther());
    }

    @Override
    public void doAction(WasAttributedTo attr) {
        this.register(attr.getId());
        this.register(attr.getEntity());
        this.register(attr.getAgent());
        this.registerType(attr.getType());
        this.registerOther(attr.getOther());
    }

    @Override
    public void doAction(WasAssociatedWith assoc) {
        this.register(assoc.getId());
        this.register(assoc.getActivity());
        this.register(assoc.getAgent());
        this.register(assoc.getPlan());
        this.registerRole(assoc.getRole());
        this.registerType(assoc.getType());
        this.registerOther(assoc.getOther());
    }

    @Override
    public void doAction(WasDerivedFrom der) {
        this.register(der.getId());
        this.register(der.getGeneratedEntity());
        this.register(der.getUsedEntity());
        this.register(der.getActivity());
        this.register(der.getGeneration());
        this.register(der.getUsage());
        this.registerType(der.getType());
        this.registerOther(der.getOther());
    }

    @Override
    public void doAction(WasInformedBy inf) {
        this.register(inf.getId());
        this.register(inf.getInformed());
        this.register(inf.getInformant());
        this.registerType(inf.getType());
        this.registerOther(inf.getOther());
    }

    @Override
    public void doAction(WasEndedBy end) {
        this.register(end.getId());
        this.register(end.getActivity());
        this.register(end.getEnder());
        this.register(end.getTrigger());
        this.registerLocation(end.getLocation());
        this.registerType(end.getType());
        this.registerRole(end.getRole());
        this.registerOther(end.getOther());
    }

    @Override
    public void doAction(WasStartedBy start) {
        this.register(start.getId());
        this.register(start.getActivity());
        this.register(start.getStarter());
        this.register(start.getTrigger());
        this.registerLocation(start.getLocation());
        this.registerType(start.getType());
        this.registerRole(start.getRole());
        this.registerOther(start.getOther());
    }

    @Override
    public void doAction(WasInvalidatedBy inv) {
        this.register(inv.getId());
        this.register(inv.getEntity());
        this.register(inv.getActivity());
        this.registerLocation(inv.getLocation());
        this.registerRole(inv.getRole());
        this.registerType(inv.getType());
        this.registerOther(inv.getOther());
    }

    @Override
    public void doAction(Used use) {
        this.register(use.getId());
        this.register(use.getEntity());
        this.register(use.getActivity());
        this.registerLocation(use.getLocation());
        this.registerRole(use.getRole());
        this.registerType(use.getType());
        this.registerOther(use.getOther());
    }

    @Override
    public void doAction(WasGeneratedBy gen) {
        this.register(gen.getId());
        this.register(gen.getEntity());
        this.register(gen.getActivity());
        this.registerLocation(gen.getLocation());
        this.registerRole(gen.getRole());
        this.registerType(gen.getType());
        this.registerOther(gen.getOther());
    }

    @Override
    public void doAction(Agent ag) {
        this.register(ag.getId());
        this.registerLocation(ag.getLocation());
        this.registerType(ag.getType());
        this.registerOther(ag.getOther());
    }

    @Override
    public void doAction(Activity a) {
        this.register(a.getId());
        this.registerLocation(a.getLocation());
        this.registerType(a.getType());
        this.registerOther(a.getOther());
    }

    @Override
    public void doAction(Entity e) {
        this.register(e.getId());
        this.registerLocation(e.getLocation());
        this.registerType(e.getType());
        this.registerValue(e.getValue());
        this.registerOther(e.getOther());
    }

    @Override
    public void doAction(DictionaryMembership m) {
        this.register(m.getDictionary());
        this.registerEntry(m.getKeyEntityPair());
    }

    @Override
    public void doAction(DerivedByRemovalFrom r) {
        this.register(r.getId());
        this.register(r.getNewDictionary());
        this.register(r.getOldDictionary());
        this.registerType(r.getType());
        this.registerOther(r.getOther());
        for (Key k : r.getKey()) {
            this.register(k);
        }
    }

    @Override
    public void doAction(DerivedByInsertionFrom i) {
        this.register(i.getId());
        this.register(i.getNewDictionary());
        this.register(i.getOldDictionary());
        this.registerType(i.getType());
        this.registerOther(i.getOther());
        this.registerEntry(i.getKeyEntityPair());
    }

    void registerEntry(List<Entry> keyEntityPairs) {
        for (Entry e : keyEntityPairs) {
            this.register(e.getEntity());
            Key key = e.getKey();
            this.register(key);
        }
    }

    void register(Key key) {
        this.registerPotentialQualifiedName(key.getValue());
        this.register(key.getType());
    }

    @Override
    public void doAction(Bundle bu, ProvUtilities u) {
        this.register(bu.getId());
        for (Statement s2 : bu.getStatement()) {
            u.doAction((StatementOrBundle)s2, this);
        }
    }
}

