/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.io.IOUtils;
import org.openprovenance.prov.model.DOMProcessing;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.LiteralConstructor;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.exception.ConverterException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ValueConverter {
    private final LiteralConstructor pFactory;
    private final Name name;

    public ValueConverter(ProvFactory pFactory) {
        this.pFactory = pFactory;
        this.name = pFactory.getName();
    }

    public Object convertToJava(QualifiedName datatype, String value) {
        if (datatype.equals(this.name.XSD_STRING)) {
            return value;
        }
        if (datatype.equals(this.name.XSD_INT)) {
            return Integer.parseInt(value);
        }
        if (datatype.equals(this.name.XSD_LONG)) {
            return Long.parseLong(value);
        }
        if (datatype.equals(this.name.XSD_SHORT)) {
            return Short.parseShort(value);
        }
        if (datatype.equals(this.name.XSD_DOUBLE)) {
            return Double.parseDouble(value);
        }
        if (datatype.equals(this.name.XSD_FLOAT)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (datatype.equals(this.name.XSD_DECIMAL)) {
            return new BigDecimal(value);
        }
        if (datatype.equals(this.name.XSD_BOOLEAN)) {
            return Boolean.parseBoolean(value);
        }
        if (datatype.equals(this.name.XSD_BYTE)) {
            return Byte.parseByte(value);
        }
        if (datatype.equals(this.name.XSD_UNSIGNED_INT)) {
            return Long.parseLong(value);
        }
        if (datatype.equals(this.name.XSD_UNSIGNED_SHORT)) {
            return Integer.parseInt(value);
        }
        if (datatype.equals(this.name.XSD_UNSIGNED_BYTE)) {
            return Short.parseShort(value);
        }
        if (datatype.equals(this.name.XSD_UNSIGNED_LONG)) {
            return new BigInteger(value);
        }
        if (datatype.equals(this.name.XSD_INTEGER)) {
            return new BigInteger(value);
        }
        if (datatype.equals(this.name.XSD_NON_NEGATIVE_INTEGER)) {
            return new BigInteger(value);
        }
        if (datatype.equals(this.name.XSD_NON_POSITIVE_INTEGER)) {
            return new BigInteger(value);
        }
        if (datatype.equals(this.name.XSD_POSITIVE_INTEGER)) {
            return new BigInteger(value);
        }
        if (datatype.equals(this.name.XSD_ANY_URI)) {
            return value;
        }
        if (datatype.equals(this.name.PROV_QUALIFIED_NAME)) {
            throw new ConverterException("Not conversion to xsd:QName");
        }
        if (datatype.equals(this.name.XSD_DATETIME)) {
            return this.pFactory.newISOTime(value);
        }
        if (datatype.equals(this.name.XSD_GYEAR)) {
            return this.pFactory.newGYear(new Integer(value));
        }
        if (datatype.equals(this.name.XSD_GMONTH)) {
            return this.pFactory.newGMonth(new Integer(value.substring(2)));
        }
        if (datatype.equals(this.name.XSD_GMONTH_DAY)) {
            return this.pFactory.newGMonthDay(new Integer(value.substring(2, 4)), new Integer(value.substring(5, 7)));
        }
        if (datatype.equals(this.name.XSD_GDAY)) {
            return this.pFactory.newGDay(new Integer(value.substring(3)));
        }
        if (datatype.equals(this.name.XSD_DURATION)) {
            return this.pFactory.newDuration(value);
        }
        if (datatype.equals(this.name.XSD_DAY_TIME_DURATION)) {
            return this.pFactory.newDuration(value);
        }
        if (datatype.equals(this.name.XSD_YEAR_MONTH_DURATION)) {
            return this.pFactory.newDuration(value);
        }
        if (datatype.equals(this.name.XSD_LANGUAGE)) {
            return value;
        }
        if (datatype.equals(this.name.XSD_TOKEN)) {
            return value;
        }
        if (datatype.equals(this.name.XSD_NMTOKEN)) {
            return value;
        }
        if (datatype.equals(this.name.XSD_NAME)) {
            return value;
        }
        if (datatype.equals(this.name.XSD_NCNAME)) {
            return value;
        }
        if (datatype.equals(this.name.XSD_NORMALIZED_STRING)) {
            return value;
        }
        if (datatype.equals(this.name.XSD_HEX_BINARY)) {
            return this.pFactory.hexDecoding(value);
        }
        if (datatype.equals(this.name.XSD_BASE64_BINARY)) {
            return this.pFactory.base64Decoding(value);
        }
        if (datatype.equals(this.name.RDF_LITERAL)) {
            System.out.println("WARNING: conversion from rdf:Literal to java object is not supported" + value);
            return this.convertXMLLiteral(value);
        }
        throw new UnsupportedOperationException("UNKNOWN literal type " + String.valueOf(datatype));
    }

    public Element convertXMLLiteral(String value) {
        DOMProcessing dp = new DOMProcessing((ProvFactory)this.pFactory);
        DocumentBuilder db = DOMProcessing.builder;
        Document doc = null;
        try {
            InputStream in = IOUtils.toInputStream((String)value, (String)"UTF-8");
            doc = db.parse(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        if (doc == null) {
            return null;
        }
        return doc.getDocumentElement();
    }

    public QualifiedName getXsdType(Object o) {
        if (o instanceof Integer) {
            return this.name.XSD_INT;
        }
        if (o instanceof String) {
            return this.name.XSD_STRING;
        }
        if (o instanceof LangString) {
            return this.name.XSD_STRING;
        }
        if (o instanceof BigInteger) {
            return this.name.XSD_INTEGER;
        }
        if (o instanceof Long) {
            return this.name.XSD_LONG;
        }
        if (o instanceof Short) {
            return this.name.XSD_SHORT;
        }
        if (o instanceof Double) {
            return this.name.XSD_DOUBLE;
        }
        if (o instanceof Float) {
            return this.name.XSD_FLOAT;
        }
        if (o instanceof BigDecimal) {
            return this.name.XSD_DECIMAL;
        }
        if (o instanceof Boolean) {
            return this.name.XSD_BOOLEAN;
        }
        if (o instanceof Byte) {
            return this.name.XSD_BYTE;
        }
        if (o instanceof QualifiedName) {
            return this.name.PROV_QUALIFIED_NAME;
        }
        if (o instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar cal = (XMLGregorianCalendar)o;
            QName t = cal.getXMLSchemaType();
            if (t.getLocalPart().equals(this.name.XSD_GYEAR.getLocalPart())) {
                return this.name.XSD_GYEAR;
            }
            if (t.getLocalPart().equals(this.name.XSD_DATETIME.getLocalPart())) {
                return this.name.XSD_DATETIME;
            }
            return this.name.XSD_DATETIME;
        }
        return this.name.QUALIFIED_NAME_UNKNOWN_TYPE;
    }
}

