/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.rules.SimpleMetrics;
import org.openprovenance.prov.rules.counters.ActivityCounter;
import org.openprovenance.prov.rules.counters.EntityActivityDerivationCounter;
import org.openprovenance.prov.rules.counters.EntityCounter;
import org.openprovenance.prov.vanilla.ProvUtilities;

public class Rules {
    public static final String PATTERN_METRICS = "patternMetrics";
    public static final String SIMPLE_METRICS = "simpleMetrics";
    public static final String COUNT_DERIVATIONS_AND_GENERATIONS_AND_USAGES = "countDerivationsAndGenerationsAndUsages";
    ProvUtilities u = new ProvUtilities();

    public EntityCounter countDerivationsAndGenerations(IndexedDocument indexedDocument) {
        Collection<Entity> entities = indexedDocument.getEntities();
        EntityCounter res = new EntityCounter();
        for (Entity entity : entities) {
            ++res.countEntities;
            Collection<WasGeneratedBy> wasGeneratedBy = indexedDocument.getWasGeneratedBy(entity);
            Collection<WasDerivedFrom> wasDerivedFrom = indexedDocument.getWasDerivedFromWithEffect(entity);
            if (wasGeneratedBy == null || wasGeneratedBy.isEmpty()) continue;
            res.countGeneratedBy += wasGeneratedBy.size();
            if (wasDerivedFrom == null || wasDerivedFrom.isEmpty()) continue;
            res.countDerivedFrom += wasDerivedFrom.size();
        }
        return res;
    }

    public ActivityCounter countActivitiesWithoutAgent(IndexedDocument indexedDocument) {
        Collection<Activity> activities = indexedDocument.getActivities();
        ActivityCounter res = new ActivityCounter();
        for (Activity activity : activities) {
            ++res.countActivities;
            Collection<WasAssociatedWith> wasAssociatedWith = indexedDocument.getWasAssociatedWith(activity);
            if (wasAssociatedWith != null && !wasAssociatedWith.isEmpty()) continue;
            ++res.countWithoutAgent;
        }
        return res;
    }

    public EntityActivityDerivationCounter countDerivationsAndGenerationsAndUsages(IndexedDocument indexedDocument) {
        LinkedList<List<Used>> triangle = new LinkedList<List<Used>>();
        Collection<Entity> entities = indexedDocument.getEntities();
        Collection<Activity> activities = indexedDocument.getActivities();
        for (Entity e2 : entities) {
            Collection<WasGeneratedBy> wgbCollection = indexedDocument.getWasGeneratedBy(e2);
            if (wgbCollection == null) continue;
            for (WasGeneratedBy wgb : wgbCollection) {
                Collection<Used> usedCollection;
                QualifiedName qnA = wgb.getActivity();
                Activity activity = qnA == null ? null : indexedDocument.getActivity(qnA);
                if (activity == null || (usedCollection = indexedDocument.getUsed(activity)) == null) continue;
                for (Used usd : usedCollection) {
                    Collection<WasDerivedFrom> wdfCollection;
                    QualifiedName qnE1 = usd.getEntity();
                    Entity e1 = qnE1 == null ? null : indexedDocument.getEntity(qnE1);
                    if (e1 == null || (wdfCollection = indexedDocument.getWasDerivedFromWithCause(e1)) == null) continue;
                    for (WasDerivedFrom wdf : wdfCollection) {
                        if (!e2.getId().equals(wdf.getGeneratedEntity())) continue;
                        triangle.add(List.of(activity, e1, e2, wdf, wgb, usd));
                    }
                }
            }
        }
        System.out.println("=====");
        EntityActivityDerivationCounter res = new EntityActivityDerivationCounter();
        res.triangle = triangle.size();
        res.entities = entities.stream().map(Identifiable::getId).collect(Collectors.toSet()).size();
        Set allEntityIds = entities.stream().map(Identifiable::getId).collect(Collectors.toSet());
        indexedDocument.nonRootEntities().forEach(allEntityIds::remove);
        res.rootEntities = allEntityIds.size();
        res.activities = activities.stream().map(Identifiable::getId).collect(Collectors.toSet()).size();
        res.entitiesWithTriangle = triangle.stream().map(l -> ((Entity)l.get(2)).getId()).collect(Collectors.toSet()).size();
        res.activitiesWithTriangle = triangle.stream().map(l -> ((Activity)l.get(0)).getId()).collect(Collectors.toSet()).size();
        for (List list : triangle) {
            Used usd;
            Activity a = (Activity)list.get(0);
            Entity e1 = (Entity)list.get(1);
            Entity e2 = (Entity)list.get(2);
            WasDerivedFrom wdf = (WasDerivedFrom)list.get(3);
            WasGeneratedBy wgb = (WasGeneratedBy)list.get(4);
            usd = (Used)list.get(5);
            int count = 0;
            if (Objects.equals(wdf.getActivity(), a.getId())) {
                ++res.wdf_with_activity;
                ++count;
            }
            if (wdf.getGeneration() != null && Objects.equals(wdf.getGeneration(), wgb.getId())) {
                ++res.wdf_with_wgb;
                ++count;
            }
            if (wdf.getUsage() != null && Objects.equals(wdf.getUsage(), usd.getId())) {
                ++res.wdf_with_usd;
                ++count;
            }
            switch (count) {
                case 0: {
                    ++res.count0;
                    break;
                }
                case 1: {
                    ++res.count1;
                    break;
                }
                case 2: {
                    ++res.count2;
                    break;
                }
                case 3: {
                    ++res.count3;
                }
            }
        }
        return res;
    }

    public Object computeMetrics(Document document, ProvFactory pFactory) {
        IndexedDocument indexedDocument = new IndexedDocument(pFactory, document, true);
        HashMap<String, Object> res = new HashMap<String, Object>();
        SimpleMetrics res1 = new SimpleMetrics();
        res1.countEntities = indexedDocument.getEntities().size();
        res1.countActivities = indexedDocument.getActivities().size();
        res1.countAgents = indexedDocument.getAgents().size();
        res1.countWasGeneratedBy = indexedDocument.getWasGeneratedBy().size() + indexedDocument.getNamedWasGeneratedBy().keySet().size();
        res1.countUsed = indexedDocument.getUsed().size() + indexedDocument.getNamedUsed().keySet().size();
        res1.countWasAssociatedWith = indexedDocument.getWasAssociatedWith().size() + indexedDocument.getNamedWasAssociatedWith().keySet().size();
        res1.countWasAttributedTo = indexedDocument.getWasAttributedTo().size() + indexedDocument.getNamedWasAttributedTo().keySet().size();
        res1.countWasDerivedFrom = indexedDocument.getWasDerivedFrom().size() + indexedDocument.getNamedWasDerivedFrom().keySet().size();
        res1.countWasEndedBy = indexedDocument.getWasEndedBy().size();
        res1.countWasInformedBy = indexedDocument.getWasInformedBy().size();
        res1.countWasInvalidatedBy = indexedDocument.getWasInvalidatedBy().size();
        res1.countWasStartedBy = indexedDocument.getWasStartedBy().size();
        res1.countWasInfluencedBy = indexedDocument.getWasInfluencedBy().size();
        res1.countSpecializationOf = indexedDocument.getSpecializationOf().size() + indexedDocument.getNamedSpecializationOf().keySet().size();
        res1.countAlternateOf = indexedDocument.getAlternateOf().size() + indexedDocument.getNamedAlternateOf().keySet().size();
        res1.countHadMember = indexedDocument.getHadMember().size() + indexedDocument.getNamedHadMember().keySet().size();
        res.put(SIMPLE_METRICS, res1);
        HashMap<String, Object> res2 = new HashMap<String, Object>();
        res2.put("countDerivationsAndGenerations", this.countDerivationsAndGenerations(indexedDocument));
        res2.put("countActivitiesWithoutAgent", this.countActivitiesWithoutAgent(indexedDocument));
        res2.put(COUNT_DERIVATIONS_AND_GENERATIONS_AND_USAGES, this.countDerivationsAndGenerationsAndUsages(indexedDocument));
        res.put(PATTERN_METRICS, res2);
        return res;
    }
}

