/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rules;

import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.rules.Ansi;
import org.openprovenance.prov.rules.TrafficLight;

public class TrafficLightResult
implements Ansi {
    public ResultKind kind;
    public String comment;
    public double ratio;
    public TrafficLight.TrafficLightColor color;
    public String colorAsString;
    public List<TrafficLightResult> subResults = new LinkedList<TrafficLightResult>();
    public double weight = 1.0;
    public String explanation;

    public TrafficLightResult() {
    }

    public TrafficLightResult(String comment, double ratio, TrafficLight.TrafficLightColor color, String explanation) {
        this.comment = comment;
        this.ratio = ratio;
        this.kind = ResultKind.PERCENTAGE;
        if (ratio < 0.0 || ratio > 100.0) {
            throw new IllegalArgumentException("Ratio out of range: " + ratio);
        }
        this.color = color;
        this.colorAsString = this.colorAsString(color);
        this.explanation = explanation;
    }

    public TrafficLightResult(String comment, double ratio, ResultKind kind, TrafficLight.TrafficLightColor color, String explanation) {
        this.comment = comment;
        this.ratio = ratio;
        this.kind = kind;
        this.color = color;
        this.explanation = explanation;
        this.colorAsString = this.colorAsString(color);
    }

    public TrafficLightResult(String comment, List<TrafficLightResult> subResults, String explanation) {
        double ratio;
        this.comment = comment;
        this.kind = ResultKind.COMPOSITE;
        this.ratio = ratio = subResults.stream().map(r -> (double)r.valueOf() * r.weight).reduce(0.0, Double::sum) * 1.0 / subResults.stream().map(r -> r.weight).reduce(0.0, Double::sum);
        if (ratio < 0.0 || ratio > 3.0) {
            throw new IllegalArgumentException("Ratio out of range: " + ratio);
        }
        this.color = TrafficLightResult.colorOf(ratio);
        this.colorAsString = this.colorAsString(this.color);
        this.explanation = explanation;
        this.subResults.addAll(subResults);
    }

    public TrafficLightResult(String comment, String explanation, double ratio) {
        this.comment = comment;
        this.kind = ResultKind.COMPOSITE;
        this.ratio = ratio;
        if (ratio < 0.0 || ratio > 3.0) {
            throw new IllegalArgumentException("Ratio out of range: " + ratio);
        }
        this.color = TrafficLightResult.colorOf(ratio);
        this.colorAsString = this.colorAsString(this.color);
        this.explanation = explanation;
    }

    public String colorAsString(TrafficLight.TrafficLightColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case TrafficLight.TrafficLightColor.RED -> this.red("red");
            case TrafficLight.TrafficLightColor.ORANGE -> this.orange("orange");
            case TrafficLight.TrafficLightColor.GREEN -> this.green("green");
        };
    }

    public int valueOf() {
        return switch (this.color) {
            default -> throw new IncompatibleClassChangeError();
            case TrafficLight.TrafficLightColor.RED -> 1;
            case TrafficLight.TrafficLightColor.ORANGE -> 2;
            case TrafficLight.TrafficLightColor.GREEN -> 3;
        };
    }

    public static TrafficLight.TrafficLightColor colorOf(double ratio) {
        if (ratio >= 2.6) {
            return TrafficLight.TrafficLightColor.GREEN;
        }
        if (ratio < 1.7) {
            return TrafficLight.TrafficLightColor.RED;
        }
        return TrafficLight.TrafficLightColor.ORANGE;
    }

    public static enum ResultKind {
        PERCENTAGE,
        COMPOSITE,
        ABSOLUTE;

    }
}

