/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.notation;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.DateTimeOption;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.ValueConverter;

public class TreeTraversal {
    private final ModelConstructor c;
    private final ProvFactory pFactory;
    private final Name name;
    private final ValueConverter vconv;
    private final DateTimeOption dateTimeOption;
    private final TimeZone optionalTimeZone;
    Namespace namespace;

    public TreeTraversal(ModelConstructor c, ProvFactory pFactory, DateTimeOption dateTimeOption, TimeZone optionalTimeZone) {
        this.c = c;
        this.pFactory = pFactory;
        this.name = pFactory.getName();
        this.namespace = pFactory.newNamespace();
        this.namespace.addKnownNamespaces();
        this.dateTimeOption = dateTimeOption;
        this.optionalTimeZone = optionalTimeZone;
        this.vconv = new ValueConverter(pFactory);
    }

    public String getTokenString(Tree t) {
        if (t == null) {
            return null;
        }
        if (((CommonTree)t).getToken() == null) {
            return null;
        }
        return ((CommonTree)t).getToken().getText();
    }

    public String convertToken(String token) {
        return token;
    }

    public int convertInt(String token) {
        return Integer.valueOf(token);
    }

    public String stripAmpersand(String token) {
        return token.substring(1);
    }

    public String unquoteTwice(String token) {
        return token.substring(2, token.length() - 2);
    }

    public String unquoteTrice(String token) {
        return token.substring(3, token.length() - 3);
    }

    public Object convert(Tree ast) {
        switch (ast.getType()) {
            case 27: {
                QualifiedName id = (QualifiedName)this.convert(ast.getChild(0));
                List eAttrs = (List)this.convert(ast.getChild(1));
                return this.c.newEntity(id, (Collection)eAttrs);
            }
            case 4: {
                QualifiedName id = (QualifiedName)this.convert(ast.getChild(0));
                XMLGregorianCalendar startTime = (XMLGregorianCalendar)this.convert(ast.getChild(1));
                XMLGregorianCalendar endTime = (XMLGregorianCalendar)this.convert(ast.getChild(2));
                List aAttrs = (List)this.convert(ast.getChild(3));
                return this.c.newActivity(id, startTime, endTime, (Collection)aAttrs);
            }
            case 26: 
            case 67: {
                if (ast.getChildCount() == 0) {
                    return null;
                }
                if (ast.getChild(0) == null) {
                    return null;
                }
                return this.convert(ast.getChild(0));
            }
            case 77: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                XMLGregorianCalendar time = (XMLGregorianCalendar)this.convert(ast.getChild(3));
                List rAttrs = (List)this.convert(ast.getChild(4));
                return this.c.newUsed(uid, id2, id1, time, (Collection)rAttrs);
            }
            case 83: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                XMLGregorianCalendar time = (XMLGregorianCalendar)this.convert(ast.getChild(3));
                List rAttrs = (List)this.convert(ast.getChild(4));
                return this.c.newWasGeneratedBy(uid, id2, id1, time, (Collection)rAttrs);
            }
            case 89: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                QualifiedName id3 = (QualifiedName)this.convert(ast.getChild(3));
                XMLGregorianCalendar time = (XMLGregorianCalendar)this.convert(ast.getChild(4));
                List rAttrs = (List)this.convert(ast.getChild(5));
                return this.c.newWasStartedBy(uid, id2, id1, id3, time, (Collection)rAttrs);
            }
            case 82: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                QualifiedName id3 = (QualifiedName)this.convert(ast.getChild(3));
                XMLGregorianCalendar time = (XMLGregorianCalendar)this.convert(ast.getChild(4));
                List rAttrs = (List)this.convert(ast.getChild(5));
                return this.c.newWasEndedBy(uid, id2, id1, id3, time, (Collection)rAttrs);
            }
            case 72: {
                if (ast.getChildCount() == 0) {
                    return null;
                }
                if (ast.getChild(0) == null) {
                    return null;
                }
                return this.pFactory.newISOTime(this.getTokenString(ast.getChild(0)), this.dateTimeOption, this.optionalTimeZone);
            }
            case 85: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                XMLGregorianCalendar time = (XMLGregorianCalendar)this.convert(ast.getChild(3));
                List rAttrs = (List)this.convert(ast.getChild(4));
                return this.c.newWasInvalidatedBy(uid, id2, id1, time, (Collection)rAttrs);
            }
            case 84: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                List rAttrs = (List)this.convert(ast.getChild(3));
                return this.c.newWasInformedBy(uid, id2, id1, (Collection)rAttrs);
            }
            case 5: {
                QualifiedName id = (QualifiedName)this.convert(ast.getChild(0));
                List agAttrs = (List)this.convert(ast.getChild(1));
                return this.c.newAgent(id, (Collection)agAttrs);
            }
            case 79: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                List rAttrs = (List)this.convert(ast.getChild(3));
                return this.c.newWasAttributedTo(uid, id2, id1, (Collection)rAttrs);
            }
            case 80: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)(ast.getChild(2) == null ? null : this.convert(ast.getChild(2)));
                QualifiedName pl = (QualifiedName)(ast.getChild(3) == null ? null : this.convert(ast.getChild(3)));
                List rAttrs = (List)this.convert(ast.getChild(4));
                return this.c.newWasAssociatedWith(uid, id2, id1, pl, (Collection)rAttrs);
            }
            case 7: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                QualifiedName a = (QualifiedName)(ast.getChild(3) == null ? null : this.convert(ast.getChild(3)));
                List rAttrs = (List)this.convert(ast.getChild(4));
                return this.c.newActedOnBehalfOf(uid, id2, id1, a, (Collection)rAttrs);
            }
            case 81: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                QualifiedName pe = (QualifiedName)this.convert(ast.getChild(3));
                QualifiedName q2 = (QualifiedName)this.convert(ast.getChild(4));
                QualifiedName q1 = (QualifiedName)this.convert(ast.getChild(5));
                List dAttrs = (List)this.convert(ast.getChild(6));
                return this.c.newWasDerivedFrom(uid, id2, id1, pe, q2, q1, (Collection)dAttrs);
            }
            case 37: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                List dAttrs = (List)this.convert(ast.getChild(3));
                return this.c.newWasInfluencedBy(uid, id2, id1, (Collection)dAttrs);
            }
            case 6: {
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(0));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(1));
                return this.c.newAlternateOf(id2, id1);
            }
            case 66: {
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(0));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(1));
                return this.c.newSpecializationOf(id2, id1);
            }
            case 46: {
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(0));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(1));
                LinkedList<QualifiedName> ll = new LinkedList<QualifiedName>();
                if (id1 != null) {
                    ll.add(id1);
                }
                return this.c.newHadMember(id2, ll);
            }
            case 16: {
                QualifiedName su = (QualifiedName)this.convert(ast.getChild(0));
                QualifiedName bu = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName ta = (QualifiedName)this.convert(ast.getChild(2));
                return this.c.newMentionOf(su, bu, ta);
            }
            case 17: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                List keymap = (List)this.convert(ast.getChild(3));
                List dAttrs = (List)this.convert(ast.getChild(4));
                return this.c.newDerivedByInsertionFrom(uid, id2, id1, keymap, (Collection)dAttrs);
            }
            case 18: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                QualifiedName id1 = (QualifiedName)this.convert(ast.getChild(2));
                Object keyset = this.convert(ast.getChild(3));
                List dAttrs = (List)this.convert(ast.getChild(4));
                return this.c.newDerivedByRemovalFrom(uid, id2, id1, (List)keyset, (Collection)dAttrs);
            }
            case 21: {
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                List keymap = (List)this.convert(ast.getChild(2));
                return this.c.newDictionaryMembership(id2, keymap);
            }
            case 14: {
                Tree uidTree = ast.getChild(0);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                QualifiedName id2 = (QualifiedName)this.convert(ast.getChild(1));
                Object cmemEntities = this.convert(ast.getChild(2));
                List dAttrs = (List)this.convert(ast.getChild(4));
                return null;
            }
            case 43: {
                LinkedList<Key> keys = new LinkedList<Key>();
                for (int i = 0; i < ast.getChildCount(); ++i) {
                    Object o = this.convert(ast.getChild(i));
                    if (o instanceof LangString) {
                        keys.add(this.pFactory.newKey(o, this.name.PROV_LANG_STRING));
                        continue;
                    }
                    Object[] pair = (Object[])o;
                    keys.add(this.pFactory.newKey(pair[0], (QualifiedName)pair[1]));
                }
                return keys;
            }
            case 78: {
                LinkedList<Object> values = new LinkedList<Object>();
                for (int i = 0; i < ast.getChildCount(); ++i) {
                    Object o = this.convert(ast.getChild(i));
                    values.add(o);
                }
                return values;
            }
            case 42: {
                Object keys1 = this.convert(ast.getChild(0));
                Object entities = this.convert(ast.getChild(1));
                List keys2 = (List)keys1;
                List qualifiedNames = (List)entities;
                LinkedList<Entry> entries = new LinkedList<Entry>();
                int ii = 0;
                for (Object o : keys2) {
                    QualifiedName value = (QualifiedName)qualifiedNames.get(ii);
                    Entry p = this.pFactory.newEntry((Key)o, value);
                    entries.add(p);
                    ++ii;
                }
                return entries;
            }
            case 30: {
                LinkedList<Object> listOfEntities = new LinkedList<Object>();
                for (int i = 0; i < ast.getChildCount(); ++i) {
                    Object o = this.convert(ast.getChild(i));
                    listOfEntities.add(o);
                }
                return listOfEntities;
            }
            case 32: {
                System.out.println("FOUND Extension " + String.valueOf(ast));
                Object extName = this.convert(ast.getChild(0));
                Tree uidTree = ast.getChild(1);
                if (uidTree.getChildCount() > 0) {
                    uidTree = uidTree.getChild(0);
                }
                QualifiedName uid = (QualifiedName)this.convert(uidTree);
                Object optionalAttributes = this.convert(ast.getChild(ast.getChildCount() - 1));
                LinkedList<Object> args = new LinkedList<Object>();
                for (int i = 2; i < ast.getChildCount() - 1; ++i) {
                    Object o = this.convert(ast.getChild(i));
                    args.add(o);
                }
                return this.newExtension(extName, uid, args, optionalAttributes);
            }
            case 11: 
            case 31: {
                LinkedList<Object> records = new LinkedList<Object>();
                for (int i = 0; i < ast.getChildCount(); ++i) {
                    Object o = this.convert(ast.getChild(i));
                    records.add(o);
                }
                return records;
            }
            case 22: {
                Namespace nss = (Namespace)this.convert(ast.getChild(0));
                List records2 = (List)this.convert(ast.getChild(1));
                LinkedList<Statement> records4 = new LinkedList<Statement>();
                for (Statement s : records2) {
                    if (s == null) continue;
                    records4.add(s);
                }
                List bundles = null;
                if (ast.getChild(2) != null) {
                    List tmp;
                    bundles = tmp = (List)this.convert(ast.getChild(2));
                }
                return this.c.newDocument(nss, records4, bundles);
            }
            case 10: {
                Namespace localNamespace = this.pFactory.newNamespace();
                localNamespace.addKnownNamespaces();
                localNamespace.setParent(this.namespace);
                this.namespace = localNamespace;
                this.convert(ast.getChild(1));
                QualifiedName bundleId = (QualifiedName)this.convert(ast.getChild(0));
                List records3 = (List)this.convert(ast.getChild(2));
                LinkedList<Statement> records5 = new LinkedList<Statement>();
                for (Statement s : records3) {
                    if (s == null) continue;
                    records5.add(s);
                }
                this.namespace = localNamespace.getParent();
                return this.c.newNamedBundle(bundleId, localNamespace, records5);
            }
            case 9: {
                LinkedList<Attribute> attributes = new LinkedList<Attribute>();
                for (int i = 0; i < ast.getChildCount(); ++i) {
                    attributes.add((Attribute)this.convert(ast.getChild(i)));
                }
                return attributes;
            }
            case 36: {
                return this.stringToQualifiedName(this.convertToken(this.getTokenString(ast.getChild(0))));
            }
            case 8: {
                String attr1 = this.convertToken(this.getTokenString(ast.getChild(0)));
                Object val1 = this.convert(ast.getChild(1));
                if (val1 instanceof Object[]) {
                    Object[] values2 = (Object[])val1;
                    Object theValue = values2[0];
                    QualifiedName theType = (QualifiedName)values2[1];
                    return this.pFactory.newAttribute(this.stringToQualifiedName(attr1), theValue, theType);
                }
                if (val1 instanceof LangString) {
                    return this.pFactory.newAttribute(this.stringToQualifiedName(attr1), val1, this.name.PROV_LANG_STRING);
                }
                if (val1 instanceof Integer) {
                    return this.pFactory.newAttribute(this.stringToQualifiedName(attr1), val1, this.name.XSD_INT);
                }
                if (val1 instanceof String) {
                    return this.pFactory.newAttribute(this.stringToQualifiedName(attr1), val1, this.name.XSD_STRING);
                }
                System.out.println("****** " + String.valueOf(val1));
                System.out.println("****** " + String.valueOf(val1.getClass()));
                return this.pFactory.newAttribute(this.stringToQualifiedName(attr1), val1, this.name.XSD_STRING);
            }
            case 68: {
                if (ast.getChildCount() == 1) {
                    return this.unescape(this.unwrap(this.convertToken(this.getTokenString(ast.getChild(0)))));
                }
                return this.pFactory.newInternationalizedString(this.unescape(this.unwrap(this.convertToken(this.getTokenString(ast.getChild(0))))), this.stripAmpersand(this.convertToken(this.getTokenString(ast.getChild(1)))));
            }
            case 71: {
                if (ast.getChildCount() == 1) {
                    return this.unescape(this.unquoteTrice(this.convertToken(this.getTokenString(ast.getChild(0)))));
                }
                return this.pFactory.newInternationalizedString(this.unescape(this.unquoteTrice(this.convertToken(this.getTokenString(ast.getChild(0))))), this.stripAmpersand(this.convertToken(this.getTokenString(ast.getChild(1)))));
            }
            case 38: {
                return this.convertInt(this.getTokenString(ast.getChild(0)));
            }
            case 63: {
                return this.stringToQualifiedName(this.convertToken(this.getTokenString(ast.getChild(0))));
            }
            case 40: {
                String iri = this.convertToken(this.getTokenString(ast.getChild(0)));
                return URI.create(this.unwrap(iri));
            }
            case 74: {
                String typedLiteral_string = this.convertToken(this.getTokenString(ast.getChild(0)));
                Tree tree_datatype = ast.getChild(1);
                if (tree_datatype == null) {
                    QualifiedName typedLiteral_datatype = this.name.PROV_QUALIFIED_NAME;
                    return this.convertTypedLiteral(typedLiteral_string, typedLiteral_datatype);
                }
                QualifiedName typedLiteral_datatype = (QualifiedName)this.convert(tree_datatype);
                Tree tree_langtag = ast.getChild(2);
                if (tree_langtag != null) {
                    LangString lstring = this.pFactory.newInternationalizedString(this.unescape(this.unwrap(typedLiteral_string)), this.stripAmpersand(this.convertToken(this.getTokenString(tree_langtag))));
                    return this.convertTypedLiteral(lstring, this.name.PROV_LANG_STRING);
                }
                typedLiteral_string = this.unescape(this.unwrap(typedLiteral_string));
                return this.convertTypedLiteral(typedLiteral_string, typedLiteral_datatype);
            }
            case 48: {
                String pre = (String)this.convert(ast.getChild(0));
                String iri1 = this.unwrap(this.getTokenString(ast.getChild(1)));
                if (pre != null) {
                    this.namespace.register(pre, iri1);
                }
                return null;
            }
            case 19: {
                String iri1 = this.unwrap(this.getTokenString(ast.getChild(0)));
                this.namespace.registerDefault(iri1);
                return null;
            }
            case 60: {
                String prefix = this.getTokenString(ast.getChild(0));
                return prefix;
            }
            case 49: {
                for (int i = 0; i < ast.getChildCount(); ++i) {
                    Object object = this.convert(ast.getChild(i));
                }
                return this.namespace;
            }
            case 73: {
                return true;
            }
            case 33: {
                return false;
            }
            case 76: {
                return null;
            }
        }
        System.out.println("Parsing not processed for " + ast.getType());
        return null;
    }

    public Object newExtension(Object extName, QualifiedName uid, List<Object> args, Object optionalAttributes) {
        QualifiedName ext = (QualifiedName)extName;
        if ("http://openprovenance.org/prov/extension#".equals(ext.getNamespaceURI())) {
            ModelConstructorExtension mce = (ModelConstructorExtension)this.c;
            switch (ext.getLocalPart()) {
                case "hadMember": {
                    return mce.newQualifiedHadMember(uid, (QualifiedName)args.get(0), List.of((QualifiedName)args.get(1)), (Collection)((List)optionalAttributes));
                }
                case "specializationOf": {
                    return mce.newQualifiedSpecializationOf(uid, (QualifiedName)args.get(0), (QualifiedName)args.get(1), (Collection)((List)optionalAttributes));
                }
                case "alternateOf": {
                    return mce.newQualifiedAlternateOf(uid, (QualifiedName)args.get(0), (QualifiedName)args.get(1), (Collection)((List)optionalAttributes));
                }
            }
            throw new UnsupportedOperationException("unknown " + String.valueOf(ext));
        }
        return null;
    }

    private QualifiedName stringToQualifiedName(String attr1) {
        return this.namespace.stringToQualifiedName(attr1, this.pFactory);
    }

    private String unescape(String s) {
        return ProvUtilities.unescape((String)s);
    }

    public Object convertTypedLiteral(String literal, QualifiedName datatype) {
        String value = literal;
        if (datatype.equals((Object)this.name.PROV_QUALIFIED_NAME)) {
            value = this.stringToQualifiedName(literal);
        }
        Object[] valueTypePair = new Object[]{value, datatype};
        return valueTypePair;
    }

    public Object convertTypedLiteral(LangString literal, QualifiedName datatype) {
        LangString value = literal;
        if (datatype.equals((Object)this.name.PROV_QUALIFIED_NAME)) {
            // empty if block
        }
        Object[] valueTypePair = new Object[]{value, datatype};
        return valueTypePair;
    }

    public String unwrap(String s) {
        return s.substring(1, s.length() - 1);
    }
}

