/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.scala.viz;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.scala.immutable.Attribute;
import org.openprovenance.prov.scala.immutable.Bundle;
import org.openprovenance.prov.scala.immutable.Document;
import org.openprovenance.prov.scala.immutable.HasLabel;
import org.openprovenance.prov.scala.immutable.HasOther;
import org.openprovenance.prov.scala.immutable.HasTime;
import org.openprovenance.prov.scala.immutable.Indexing;
import org.openprovenance.prov.scala.immutable.Kind$;
import org.openprovenance.prov.scala.immutable.LangString;
import org.openprovenance.prov.scala.immutable.NS$;
import org.openprovenance.prov.scala.immutable.OrderedDocument;
import org.openprovenance.prov.scala.immutable.Other;
import org.openprovenance.prov.scala.immutable.QualifiedName;
import org.openprovenance.prov.scala.immutable.Relation;
import org.openprovenance.prov.scala.immutable.SizeRange;
import org.openprovenance.prov.scala.immutable.Statement;
import org.openprovenance.prov.scala.viz.Edge;
import org.openprovenance.prov.scala.viz.GraphElement;
import org.openprovenance.prov.scala.viz.SubGraph;
import org.openprovenance.prov.scala.viz.Vertex;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Graphics$ {
    public static final Graphics$ MODULE$ = new Graphics$();
    private static final String shape = "shape";
    private static final String side = "side";
    private static final String color = "color";
    private static final String fillcolor = "fillcolor";
    private static final String fontcolor = "fontcolor";
    private static final String style = "style";
    private static final String filled = "filled";
    private static final String polygon = "polygon";
    private static final String house = "house";
    private static final String ellipse = "ellipse";
    private static final String url = "URL";
    private static final String penwidth = "penwidth";
    private static final String width = "width";
    private static final String label = "label";
    private static final String tooltip = "tooltip";
    private static final String arrowhead = "arrowhead";
    private static final String none = "none";
    private static final String point = "point";
    private static final String entityFillColor = "#FFFC87";
    private static final String entityColor = "#808080";
    private static final String entityFontColor = "#808080";
    private static final String agentFillColor = "#FDB266";
    private static final String agentColor = "#000000";
    private static final String agentFontColor = "#000000";
    private static final String activityFillColor = "#9FB1FC";
    private static final String activityColor = "#0000FF";
    private static final String activityFontColor = "#0000FF";
    private static final String edgeColor = "#000000";
    private static final String DOT_NS = "http://openprovenance.org/Toolbox/dot#";
    private static final QualifiedName colorQN = new QualifiedName("dot", "color", MODULE$.DOT_NS());
    private static final QualifiedName fillcolorQN = new QualifiedName("dot", "fillcolor", MODULE$.DOT_NS());
    private static final QualifiedName fontcolorQN = new QualifiedName("dot", "fontcolor", MODULE$.DOT_NS());
    private static final QualifiedName tooltipQN = new QualifiedName("dot", "tooltip", MODULE$.DOT_NS());
    private static final Set<QualifiedName> graphicsQNs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QualifiedName[]{MODULE$.colorQN(), MODULE$.fillcolorQN(), MODULE$.fontcolorQN(), MODULE$.tooltipQN()}));
    private static final ProvUtilities pu = new ProvUtilities();
    private static boolean useIdAsLabel = true;
    private static int bncounter = 0;
    private static final double nodeMaxWidth = 4.0;
    private static final double edgeMaxWidth = 9.0;

    public String shape() {
        return shape;
    }

    public String side() {
        return side;
    }

    public String color() {
        return color;
    }

    public String fillcolor() {
        return fillcolor;
    }

    public String fontcolor() {
        return fontcolor;
    }

    public String style() {
        return style;
    }

    public String filled() {
        return filled;
    }

    public String polygon() {
        return polygon;
    }

    public String house() {
        return house;
    }

    public String ellipse() {
        return ellipse;
    }

    public String url() {
        return url;
    }

    public String penwidth() {
        return penwidth;
    }

    public String width() {
        return width;
    }

    public String label() {
        return label;
    }

    public String tooltip() {
        return tooltip;
    }

    public String arrowhead() {
        return arrowhead;
    }

    public String none() {
        return none;
    }

    public String point() {
        return point;
    }

    public String entityFillColor() {
        return entityFillColor;
    }

    public String entityColor() {
        return entityColor;
    }

    public String entityFontColor() {
        return entityFontColor;
    }

    public String agentFillColor() {
        return agentFillColor;
    }

    public String agentColor() {
        return agentColor;
    }

    public String agentFontColor() {
        return agentFontColor;
    }

    public String activityFillColor() {
        return activityFillColor;
    }

    public String activityColor() {
        return activityColor;
    }

    public String activityFontColor() {
        return activityFontColor;
    }

    public String edgeColor() {
        return edgeColor;
    }

    public String DOT_NS() {
        return DOT_NS;
    }

    public QualifiedName colorQN() {
        return colorQN;
    }

    public QualifiedName fillcolorQN() {
        return fillcolorQN;
    }

    public QualifiedName fontcolorQN() {
        return fontcolorQN;
    }

    public QualifiedName tooltipQN() {
        return tooltipQN;
    }

    public Set<QualifiedName> graphicsQNs() {
        return graphicsQNs;
    }

    public ProvUtilities pu() {
        return pu;
    }

    public Set<GraphElement> toElements(Statement s, Function1<QualifiedName, String> idmap, SizeRange r) {
        Enumeration.Value value = s.enumType();
        Enumeration.Value value2 = Kind$.MODULE$.ent();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new Vertex((String)idmap.apply((Object)s.id()), this.addLabel(s, this.addWidth(s, r, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.url()), (Object)s.id().getUri()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.shape()), (Object)this.ellipse()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.color()), (Object)this.colorOf(s, this.entityColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fontcolor()), (Object)this.fontcolorOf(s, this.entityFontColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fillcolor()), (Object)this.fillcolorOf(s, this.entityFillColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.style()), (Object)this.filled())}))))))}));
        }
        Enumeration.Value value4 = Kind$.MODULE$.ag();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new Vertex((String)idmap.apply((Object)s.id()), this.addLabel(s, this.addWidth(s, r, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.url()), (Object)s.id().getUri()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.shape()), (Object)this.house()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.color()), (Object)this.colorOf(s, this.agentColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fontcolor()), (Object)this.fontcolorOf(s, this.agentFontColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fillcolor()), (Object)this.fillcolorOf(s, this.agentFillColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.style()), (Object)this.filled())}))))))}));
        }
        Enumeration.Value value6 = Kind$.MODULE$.act();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new Vertex((String)idmap.apply((Object)s.id()), this.addLabel(s, this.addWidth(s, r, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.url()), (Object)s.id().getUri()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.shape()), (Object)this.polygon()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.color()), (Object)this.colorOf(s, this.activityColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fontcolor()), (Object)this.fontcolorOf(s, this.activityFontColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fillcolor()), (Object)this.fillcolorOf(s, this.activityFillColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.style()), (Object)this.filled()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.side()), (Object)"4")}))))))}));
        }
        return this.toElements((Relation)s, idmap, r);
    }

    public String colorOf(Statement s, String col) {
        return this.colorOf(s, col, this.colorQN());
    }

    public String fillcolorOf(Statement s, String col) {
        return this.colorOf(s, col, this.fillcolorQN());
    }

    public String fontcolorOf(Statement s, String col) {
        return this.colorOf(s, col, this.fontcolorQN());
    }

    public String colorOf(Statement s, String col, QualifiedName colorQN) {
        Statement statement = s;
        if (statement instanceof HasOther) {
            Statement statement2 = statement;
            Option option = ((HasOther)statement2).other().get((Object)colorQN);
            if (option instanceof Some) {
                Some some = (Some)option;
                Set set = (Set)some.value();
                return ((Other)set.head()).value().toString();
            }
            if (None$.MODULE$.equals(option)) {
                return col;
            }
            throw new MatchError((Object)option);
        }
        return col;
    }

    public Set<GraphElement> toElements(Bundle s2, Function1<QualifiedName, String> idmap, SizeRange r) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new SubGraph((String)idmap.apply((Object)s2.id()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.label()), (Object)s2.id().localPart()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.url()), (Object)s2.id().getUri())}))), (Iterable<GraphElement>)((Iterable)s2.statement().flatMap((Function1 & Serializable)s -> MODULE$.toElements((Statement)s, idmap, r))))}));
    }

    public Option<Object> getSize(Statement s) {
        Option option = ((HasOther)s).other().get((Object)NS$.MODULE$.QN_SIZE());
        if (option instanceof Some) {
            Some some = (Some)option;
            Set set = (Set)some.value();
            Option option2 = set.headOption();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Other s2 = (Other)some2.value();
                return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s2.value().toString()))));
            }
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option2);
        }
        return None$.MODULE$;
    }

    public Map<String, String> addPenWidth(Relation s, SizeRange r, Map<String, String> m) {
        Option<Object> sizeAttributes = this.getSize((Statement)s);
        Option<Object> option = sizeAttributes;
        if (option instanceof Some) {
            Some some = (Some)option;
            int size = BoxesRunTime.unboxToInt((Object)some.value());
            return (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.penwidth()), (Object)Double.toString(this.edgeVisualSizeAttribute(size, r.edgeMin(), r.edgeMax()))));
        }
        if (None$.MODULE$.equals(option)) {
            return m;
        }
        throw new MatchError(option);
    }

    public Map<String, String> addWidth(Statement s, SizeRange r, Map<String, String> m) {
        Option<Object> sizeAttributes = this.getSize(s);
        Option<Object> option = sizeAttributes;
        if (option instanceof Some) {
            Some some = (Some)option;
            int size = BoxesRunTime.unboxToInt((Object)some.value());
            return (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.width()), (Object)Double.toString(this.nodeVisualSizeAttribute(size, r.nodeMin(), r.nodeMax()))));
        }
        if (None$.MODULE$.equals(option)) {
            return m;
        }
        throw new MatchError(option);
    }

    public boolean useIdAsLabel() {
        return useIdAsLabel;
    }

    public void useIdAsLabel_$eq(boolean x$1) {
        useIdAsLabel = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> addLabel(Statement s, Map<String, String> m) {
        Map map;
        Statement statement = s;
        if (statement instanceof HasLabel) {
            Statement statement2 = statement;
            Option labelOpt = ((HasLabel)statement2).label().headOption();
            Option option = labelOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                LangString str = (LangString)some.value();
                map = (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.label()), (Object)str.value()));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                map = this.useIdAsLabel() ? (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.label()), (Object)statement2.getId().getLocalPart())) : m;
            }
        } else {
            map = statement.getId() != null ? (this.useIdAsLabel() ? (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.label()), (Object)s.getId().getLocalPart())) : m) : m;
        }
        Map res = map;
        return (Map)res.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tooltip()), (Object)s.id().localPart()));
    }

    public int bncounter() {
        return bncounter;
    }

    public void bncounter_$eq(int x$1) {
        bncounter = x$1;
    }

    public Set<Attribute> usefulAttributes(Set<Attribute> attrs) {
        return (Set)attrs.filterNot((Function1 & Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)Graphics$.$anonfun$usefulAttributes$1(attr)));
    }

    public Set<GraphElement> toElements(Relation s, Function1<QualifiedName, String> idmap, SizeRange r) {
        Map mapi = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.color()), (Object)this.colorOf((Statement)s, this.edgeColor()))}));
        org.openprovenance.prov.model.Relation cast = (org.openprovenance.prov.model.Relation)s;
        List causes = this.pu().getOtherCauses(cast);
        None$ time = s instanceof HasTime ? ((HasTime)s).time() : None$.MODULE$;
        Set attrs = s.getAttributes();
        if (causes != null || attrs != null && this.usefulAttributes((Set<Attribute>)attrs).nonEmpty() || !time.equals((Object)None$.MODULE$)) {
            this.bncounter_$eq(this.bncounter() + 1);
            String bnid = new StringBuilder(2).append("bn").append(Integer.toString(this.bncounter())).toString();
            Set aset = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new Vertex(bnid, (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.label()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.shape()), (Object)this.point())}))).$plus$plus((IterableOnce)mapi))), new Edge(null, (String)idmap.apply((Object)s.getEffect()), bnid, this.addPenWidth(s, r, (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.arrowhead()), (Object)this.none())}))).$plus$plus((IterableOnce)mapi))))}));
            Set aset2 = s.getCause() != null ? (Set)aset.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge(null, bnid, (String)idmap.apply((Object)s.getCause()), this.addPenWidth(s, r, (Map<String, String>)mapi))}))) : aset;
            Set aset3 = causes != null ? (Set)aset2.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge(null, bnid, (String)idmap.apply((Object)((QualifiedName)causes.get(0))), this.addPenWidth(s, r, (Map<String, String>)mapi))}))) : aset2;
            return aset3;
        }
        if (s.getEffect() != null && s.getCause() != null) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new Edge(null, (String)idmap.apply((Object)s.getEffect()), (String)idmap.apply((Object)s.getCause()), this.addPenWidth(s, r, (Map<String, String>)mapi))}));
        }
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    public Set<GraphElement> toElements(Document doc, Function1<QualifiedName, String> idmap, SizeRange r) {
        return (Set)((IterableOnceOps)doc.statements().flatMap((Function1 & Serializable)s -> MODULE$.toElements((Statement)s, idmap, r))).toSet().$plus$plus((IterableOnce)doc.bundles().flatMap((Function1 & Serializable)s -> MODULE$.toElements((Bundle)s, idmap, r)));
    }

    public Seq<GraphElement> toElements(OrderedDocument doc, Function1<QualifiedName, String> idmap, SizeRange r) {
        return (Seq)((IterableOps)doc.orderedStatements().flatMap((Function1 & Serializable)s -> MODULE$.toElements((Statement)s, idmap, r))).$plus$plus((IterableOnce)doc.orderedBundles().flatMap((Function1 & Serializable)s -> MODULE$.toElements((Bundle)s, idmap, r)));
    }

    public void toDot(Document doc, Function1<QualifiedName, String> idmap, SizeRange r, Writer outw) {
        outw.write("digraph \"PROV\" { size=\"16,12\"; rankdir=\"BT\";\n");
        this.toElements(doc, idmap, r).foreach((Function1 & Serializable)e -> {
            e.toDot(outw);
            return BoxedUnit.UNIT;
        });
        outw.write("}\n");
        outw.close();
    }

    public void toDot(OrderedDocument doc, Function1<QualifiedName, String> idmap, SizeRange r, Writer outw) {
        outw.write("digraph \"PROV\" { size=\"16,12\"; rankdir=\"BT\";\n");
        this.toElements(doc, idmap, r).foreach((Function1 & Serializable)e -> {
            e.toDot(outw);
            return BoxedUnit.UNIT;
        });
        outw.write("}\n");
        outw.close();
    }

    public void toDot(Document doc, Function1<QualifiedName, String> idmap, SizeRange r, File outw) {
        Document document = doc;
        if (document instanceof OrderedDocument) {
            OrderedDocument orderedDocument = (OrderedDocument)document;
            this.toDot(orderedDocument, idmap, r, (Writer)new FileWriter(outw));
            return;
        }
        this.toDot(doc, idmap, r, (Writer)new FileWriter(outw));
    }

    public void toDot(Indexing ind, File outw) {
        this.toDot(ind.document(), ind.idPrinter(), ind.sizeRange(), outw);
    }

    public void dotConvert(String dot, String svg, String t) {
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec(new StringBuilder(11).append("dot -o ").append(svg).append(" -T").append(t).append(" ").append(dot).toString());
    }

    public void dotConvert(String dot, OutputStream os, String t) {
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec(new StringBuilder(7).append("dot -T").append(t).append(" ").append(dot).toString());
        InputStream in = proc.getInputStream();
        IOUtils.copy((InputStream)in, (OutputStream)os);
    }

    public double nodeMaxWidth() {
        return nodeMaxWidth;
    }

    public double edgeMaxWidth() {
        return edgeMaxWidth;
    }

    public double edgeVisualSizeAttribute(int size, int min, int max) {
        if (min == max) {
            return 1.0;
        }
        return 1.0 + this.edgeMaxWidth() * (double)(size - min) / (double)(max - min);
    }

    public double nodeVisualSizeAttribute(int size, int min, int max) {
        if (min == max) {
            return 1.0;
        }
        return 1.0 + this.nodeMaxWidth() * (double)(size - min) / (double)(max - min);
    }

    public static final /* synthetic */ boolean $anonfun$usefulAttributes$1(Attribute attr) {
        String ns;
        return attr instanceof Other && ((ns = ((Other)attr).elementName().namespaceURI()).equals(MODULE$.DOT_NS()) || ns.equals(NS$.MODULE$.SUM_NS()));
    }

    private Graphics$() {
    }
}

