/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;

public class CompilerBeanEnactor {
    private final CompilerUtil compilerUtil;

    public CompilerBeanEnactor(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    SpecificationFile generateBeanEnactor(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("BeanEnactor");
        builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        builder.addTypeVariable(ConfigProcessor.typeResult);
        ClassName queryInvokerClass = this.compilerUtil.getClass("QueryInvoker", locations);
        ClassName beanCompleterClass = this.compilerUtil.getClass("BeanCompleter", locations);
        ClassName beanProcessorClass = this.compilerUtil.getClass("BeanProcessor", locations);
        builder.addSuperinterface((TypeName)beanProcessorClass);
        TypeSpec.Builder inface = this.compilerUtil.generateInterfaceInit("EnactorImplementation");
        inface.addTypeVariable(ConfigProcessor.typeResult);
        MethodSpec.Builder method1 = MethodSpec.methodBuilder((String)"generic_enact").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.typeT, (String)"bean", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.consumerT, (String)"checker", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.biconsumerType, (String)"queryInvoker", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.biconsumerType2, (String)"completeBean", (Modifier[])new Modifier[0]).build()).addTypeVariable(ConfigProcessor.typeT).returns((TypeName)ConfigProcessor.typeT);
        inface.addMethod(method1.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.typeResult, (String)"rs", (Modifier[])new Modifier[0]).build()).returns((TypeName)beanCompleterClass);
        inface.addMethod(method2.build());
        builder.addType(inface.build());
        builder.addField((TypeName)beanProcessorClass, "checker", new Modifier[]{Modifier.FINAL, Modifier.PROTECTED});
        ParameterizedTypeName ENACTOR_IMPLEMENTATION_TYPE = ParameterizedTypeName.get((ClassName)ClassName.get((String)(locations.getFilePackage("BeanEnactor") + ".BeanEnactor"), (String)"EnactorImplementation", (String[])new String[0]), (TypeName[])new TypeName[]{ConfigProcessor.typeResult});
        builder.addField((TypeName)ENACTOR_IMPLEMENTATION_TYPE, "realiser", new Modifier[]{Modifier.FINAL, Modifier.PROTECTED});
        MethodSpec.Builder cbuilder3 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ENACTOR_IMPLEMENTATION_TYPE, "realiser", new Modifier[0]).addParameter((TypeName)beanProcessorClass, "checker", new Modifier[0]);
        this.compilerUtil.specWithComment(cbuilder3);
        cbuilder3.addStatement("this.$N = $N", new Object[]{"realiser", "realiser"}).addStatement("this.$N = $N", new Object[]{"checker", "checker"});
        builder.addMethod(cbuilder3.build());
        String packge = locations.getFilePackage(BeanDirection.COMMON);
        for (TemplateCompilerConfig config : configs.templates) {
            String beanNameClass = this.compilerUtil.commonNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)packge, (String)beanNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(ParameterSpec.builder((TypeName)className, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)className);
            this.compilerUtil.specWithComment(mspec);
            mspec.addStatement("return $N.generic_enact(bean,\n                b -> checker.process(b),\n                (sb,b) -> new $T(sb).process(b),\n                (rs,b) -> $N.beanCompleterFactory(rs).process(b))", new Object[]{"realiser", queryInvokerClass, "realiser"});
            builder.addMethod(mspec.build());
        }
        TypeSpec theLogger = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, packge, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(packge), fileName + ".java", packge);
    }
}

