/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.CompositeTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;
import org.openprovenance.prov.template.compiler.sql.CompilerSqlIntegration;

public class CompilerBeanEnactor2CompositeWithPrincipal {
    private final CompilerUtil compilerUtil;

    public CompilerBeanEnactor2CompositeWithPrincipal(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    SpecificationFile generateBeanEnactor2CompositeWithPrincipal(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("BeanEnactor4Composite");
        builder.addTypeVariable(ConfigProcessor.typeResult);
        builder.addJavadoc("Ensures that composite beans are given an ID\n", new Object[0]);
        ClassName queryInvokerClass = ClassName.get((String)locations.getFilePackage("QueryInvoker4"), (String)"QueryInvoker4", (String[])new String[0]);
        ParameterizedTypeName beanEnactor2Class = ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor4"), (String)"BeanEnactor4", (String[])new String[0]), (TypeName[])new TypeName[]{ConfigProcessor.typeResult});
        ClassName inputProcessorClass = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)"InputProcessor", (String[])new String[0]);
        builder.superclass((TypeName)beanEnactor2Class);
        builder.addField((TypeName)inputProcessorClass, "checker", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        builder.addField((TypeName)CompilerSqlIntegration.BIFUN, "postProcessing", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        ParameterizedTypeName ENACTOR_IMPLEMENTATION_TYPE = ParameterizedTypeName.get((ClassName)ClassName.get((String)(locations.getFilePackage("BeanEnactor4") + ".BeanEnactor4"), (String)"EnactorImplementation", (String[])new String[0]), (TypeName[])new TypeName[]{ConfigProcessor.typeResult});
        builder.addField((TypeName)ENACTOR_IMPLEMENTATION_TYPE, "realiser", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        MethodSpec.Builder cbuilder3 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ENACTOR_IMPLEMENTATION_TYPE, "realiser", new Modifier[0]).addParameter((TypeName)inputProcessorClass, "checker", new Modifier[0]).addParameter((TypeName)CompilerSqlIntegration.BIFUN, "postProcessing", new Modifier[0]);
        this.compilerUtil.specWithComment(cbuilder3);
        cbuilder3.addStatement("super($N,$N,$N)", new Object[]{"realiser", "checker", "postProcessing"}).addStatement("this.$N = $N", new Object[]{"realiser", "realiser"}).addStatement("this.$N = $N", new Object[]{"checker", "checker"}).addStatement("this.$N = postProcessing", new Object[]{"postProcessing"});
        builder.addMethod(cbuilder3.build());
        for (TemplateCompilerConfig config : configs.templates) {
            locations.updateWithConfig(config);
            if (!(config instanceof CompositeTemplateCompilerConfig)) continue;
            String outputNameClass = this.compilerUtil.outputsNameClass(config.name);
            String inputNameClass = this.compilerUtil.inputsNameClass(config.name);
            ClassName outputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)outputNameClass, (String[])new String[0]);
            ClassName inputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)inputNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)inputClassName, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)outputClassName);
            this.compilerUtil.specWithComment(mspec);
            mspec.addStatement("return $N.generic_enact(new $T(),bean,\n                b -> checker.process(b),\n                (sb,b) -> new $T(sb,true,$N()).process(b),\n                (rs,b) -> $N.beanCompleterFactory(rs,new Object[1],postProcessing).process(b))", new Object[]{"realiser", outputClassName, queryInvokerClass, "getPrincipal", "realiser"});
            builder.addMethod(mspec.build());
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }
}

