/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;
import org.openprovenance.prov.template.compiler.sql.CompilerSqlIntegration;

public class CompilerBeanEnactor2WithPrincipal {
    private final CompilerUtil compilerUtil;

    public CompilerBeanEnactor2WithPrincipal(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    SpecificationFile generateBeanEnactor2WithPrincipal(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        ParameterizedTypeName ENACTOR_IMPLEMENTATION_TYPE = ParameterizedTypeName.get((ClassName)ClassName.get((String)(locations.getFilePackage("BeanEnactor2") + ".BeanEnactor2"), (String)"EnactorImplementation", (String[])new String[0]), (TypeName[])new TypeName[]{ConfigProcessor.typeResult});
        ParameterizedTypeName THIS_ENACTOR_IMPLEMENTATION_TYPE = ParameterizedTypeName.get((ClassName)ClassName.get((String)(locations.getFilePackage("BeanEnactor4") + ".BeanEnactor4"), (String)"EnactorImplementation", (String[])new String[0]), (TypeName[])new TypeName[]{ConfigProcessor.typeResult});
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("BeanEnactor4");
        builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor2"), (String)"BeanEnactor2", (String[])new String[0]), (TypeName[])new TypeName[]{ConfigProcessor.typeResult}));
        builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        builder.addTypeVariable(ConfigProcessor.typeResult);
        ClassName queryInvokerClass = ClassName.get((String)locations.getFilePackage("QueryInvoker4"), (String)"QueryInvoker4", (String[])new String[0]);
        ClassName beanCompleterClass = ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0]);
        ClassName ioProcessorClass = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)"InputOutputProcessor", (String[])new String[0]);
        ClassName inputProcessorClass = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)"InputProcessor", (String[])new String[0]);
        builder.addSuperinterface((TypeName)ioProcessorClass);
        TypeSpec.Builder inface = this.compilerUtil.generateInterfaceInit("EnactorImplementation");
        inface.addSuperinterface((TypeName)ENACTOR_IMPLEMENTATION_TYPE);
        inface.addTypeVariable(ConfigProcessor.typeResult);
        MethodSpec.Builder method4 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.typeResult, (String)"rs", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Object[].class, (String)"extra", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)CompilerSqlIntegration.BIFUN, (String)"postProcessing", (Modifier[])new Modifier[0]).build()).returns((TypeName)beanCompleterClass);
        inface.addMethod(method4.build());
        MethodSpec.Builder method5 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.typeResult, (String)"rs", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)CompilerSqlIntegration.BIFUN, (String)"postProcessing", (Modifier[])new Modifier[0]).build()).returns((TypeName)beanCompleterClass);
        inface.addMethod(method5.build());
        builder.addType(inface.build());
        builder.addField((TypeName)inputProcessorClass, "checker", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        builder.addField((TypeName)CompilerSqlIntegration.BIFUN, "postProcessing", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        ParameterizedTypeName THREAD_LOCAL_STRING = ParameterizedTypeName.get((ClassName)ClassName.get(ThreadLocal.class), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        FieldSpec.Builder principalField = FieldSpec.builder((TypeName)THREAD_LOCAL_STRING, (String)"principal", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.withInitial(() ->  $S)", new Object[]{ThreadLocal.class, "unknown"});
        builder.addField(principalField.build());
        MethodSpec.Builder setPrincipal = MethodSpec.methodBuilder((String)"setPrincipal").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(String.class, "p", new Modifier[0]).addStatement("$N.set(p)", new Object[]{"principal"});
        builder.addMethod(setPrincipal.build());
        MethodSpec.Builder getPrincipal = MethodSpec.methodBuilder((String)"getPrincipal").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(String.class).addStatement("return $N.get()", new Object[]{"principal"});
        builder.addMethod(getPrincipal.build());
        builder.addField((TypeName)THIS_ENACTOR_IMPLEMENTATION_TYPE, "realiser", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        MethodSpec.Builder cbuilder3 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)THIS_ENACTOR_IMPLEMENTATION_TYPE, "realiser", new Modifier[0]).addParameter((TypeName)inputProcessorClass, "checker", new Modifier[0]).addParameter((TypeName)CompilerSqlIntegration.BIFUN, "postProcessing", new Modifier[0]);
        this.compilerUtil.specWithComment(cbuilder3);
        cbuilder3.addStatement("super($N,$N)", new Object[]{"realiser", "checker"}).addStatement("this.$N = $N", new Object[]{"realiser", "realiser"}).addStatement("this.$N = $N", new Object[]{"checker", "checker"}).addStatement("this.$N = $N", new Object[]{"postProcessing", "postProcessing"});
        builder.addMethod(cbuilder3.build());
        for (TemplateCompilerConfig config : configs.templates) {
            locations.updateWithConfig(config);
            String outputNameClass = this.compilerUtil.outputsNameClass(config.name);
            String inputNameClass = this.compilerUtil.inputsNameClass(config.name);
            ClassName outputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)outputNameClass, (String[])new String[0]);
            ClassName inputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)inputNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)inputClassName, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)outputClassName);
            this.compilerUtil.specWithComment(mspec);
            mspec.addStatement("return $N.generic_enact(new $T(),bean,\n                b -> checker.process(b),\n                (sb,b) -> new $T(sb,$N.get()).process(b),\n                (rs,b) -> $N.beanCompleterFactory(rs,postProcessing).process(b))", new Object[]{"realiser", outputClassName, queryInvokerClass, "principal", "realiser"});
            builder.addMethod(mspec.build());
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }
}

