/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.CompositeTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerQueryInvokerWithPrincipal {
    public static final String sbVar = "sb";
    public static final String linkingVar = "linking";
    public static final String principalVar = "principal";
    public static final String queryInvokerVar = "queryInvoker";
    private final CompilerUtil compilerUtil;

    public CompilerQueryInvokerWithPrincipal(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public SpecificationFile generateQueryInvokerWithPrincipal(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("QueryInvoker4");
        builder.addSuperinterface((TypeName)ClassName.get((String)locations.getFilePackage("InputProcessor"), (String)"InputProcessor", (String[])new String[0]));
        ClassName queryInvoke2Class = ClassName.get((String)locations.getFilePackage("QueryInvoker2"), (String)"QueryInvoker2", (String[])new String[0]);
        builder.addField(StringBuilder.class, sbVar, new Modifier[]{Modifier.FINAL});
        builder.addField(Boolean.TYPE, linkingVar, new Modifier[]{Modifier.FINAL});
        builder.addField(String.class, principalVar, new Modifier[]{Modifier.FINAL});
        builder.addField((TypeName)queryInvoke2Class, queryInvokerVar, new Modifier[]{Modifier.FINAL});
        MethodSpec.Builder cbuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(StringBuilder.class, sbVar, new Modifier[0]).addParameter(String.class, principalVar, new Modifier[0]).addStatement("this.$N = $N", new Object[]{sbVar, sbVar}).addStatement("this.$N = false", new Object[]{linkingVar}).addStatement("this.$N = $N", new Object[]{principalVar, principalVar}).addStatement("this.$N = new $T($N,$N)", new Object[]{queryInvokerVar, queryInvoke2Class, sbVar, linkingVar});
        builder.addMethod(cbuilder.build());
        MethodSpec.Builder cbuilder2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(StringBuilder.class, sbVar, new Modifier[0]).addParameter(Boolean.TYPE, linkingVar, new Modifier[0]).addParameter(String.class, principalVar, new Modifier[0]).addStatement("this.$N = $N", new Object[]{sbVar, sbVar}).addStatement("this.$N = $N", new Object[]{linkingVar, linkingVar}).addStatement("this.$N = $N", new Object[]{principalVar, principalVar}).addStatement("this.$N = new $T($N,$N)", new Object[]{queryInvokerVar, queryInvoke2Class, sbVar, linkingVar});
        builder.addMethod(cbuilder2.build());
        HashSet<String> foundSpecialTypes = new HashSet<String>();
        for (TemplateCompilerConfig config : configs.templates) {
            String beanNameClass = this.compilerUtil.commonNameClass(config.name);
            String inputsNameClass = this.compilerUtil.inputsNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)beanNameClass, (String[])new String[0]);
            ClassName inputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)inputsNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            this.compilerUtil.specWithComment(mspec);
            mspec.addParameter(ParameterSpec.builder((TypeName)inputClassName, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)inputClassName);
            if (config instanceof SimpleTemplateCompilerConfig) {
                this.simpleQueryInvoker(configs, config, foundSpecialTypes, sbVar, mspec, "bean");
                mspec.addStatement("return $N", new Object[]{"bean"});
            } else {
                this.compositeQueryInvoker(configs, locations, config, foundSpecialTypes, sbVar, mspec, "bean", false);
                mspec.addStatement("return $N", new Object[]{"bean"});
            }
            builder.addMethod(mspec.build());
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    private void simpleQueryInvoker(TemplatesProjectConfiguration configs, TemplateCompilerConfig config, Set<String> foundSpecialTypes, String sbVar, MethodSpec.Builder mspec, String variableBean) {
        TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema((SimpleTemplateCompilerConfig)config);
        String startCallString = "insert_" + config.name + " (";
        this.compilerUtil.specWithComment(mspec);
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "WITH \n    insertion_result AS (select * from "});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, startCallString});
        boolean first = true;
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
            if (!ConfigProcessor.descriptorUtils.isInput(key, bindingsSchema)) continue;
            Class<?> cl = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
            if (first) {
                first = false;
            } else {
                mspec.addStatement("$N.append($S)", new Object[]{sbVar, ","});
            }
            String sqlType = ConfigProcessor.descriptorUtils.getSqlType(key, bindingsSchema);
            if (sqlType != null) {
                String fun = this.converterForSpecialType(sqlType);
                if (fun != null) {
                    mspec.addStatement("$N.append($N($N.$N))", new Object[]{sbVar, fun, variableBean, key});
                    foundSpecialTypes.add(sqlType);
                    continue;
                }
                mspec.addStatement("$N.append($N.$N)", new Object[]{sbVar, variableBean, key});
                continue;
            }
            mspec.addStatement("$N.append($N.$N)", new Object[]{sbVar, variableBean, key});
        }
        String endCallString = "))";
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, endCallString});
        this.insertAccessControlSimple(config, sbVar, mspec, bindingsSchema);
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, ";\n"});
    }

    private void insertAccessControlSimple(TemplateCompilerConfig config, String sbVar, MethodSpec.Builder mspec, TemplateBindingsSchema bindingsSchema) {
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "\nINSERT INTO record_index(key,table_name,principal)\n"});
        mspec.addStatement("$N.append($S).append($S).append($N($S))", new Object[]{sbVar, "VALUES ((SELECT id FROM insertion_result)", ",\n", "queryInvoker.convertToNonNullableTEXT", config.name});
        mspec.addStatement("$N.append($S).append($N($N))", new Object[]{sbVar, ",\n", "queryInvoker.convertToNonNullableTEXT", principalVar});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, ")\nRETURNING (SELECT ID FROM insertion_result) as id\n"});
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
            if (!ConfigProcessor.descriptorUtils.isOutput(key, bindingsSchema)) continue;
            Class<?> cl = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
            mspec.addStatement("$N.append($S)", new Object[]{sbVar, ","});
            mspec.addStatement("$N.append($S)", new Object[]{sbVar, "(SELECT " + key + " FROM insertion_result)"});
        }
    }

    private void insertAccessControlComposite(TemplateCompilerConfig config, String sbVar, MethodSpec.Builder mspec, SimpleTemplateCompilerConfig composee, TemplateBindingsSchema bindingsSchema) {
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "insertion_result2 AS ("});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "\n   INSERT INTO record_index(key,table_name,principal)\n"});
        mspec.addStatement("$N.append($S).append($S).append($N($S))", new Object[]{sbVar, "   SELECT id", ",", "queryInvoker.convertToNonNullableTEXT", composee.name});
        mspec.addStatement("$N.append($S).append($N($N))", new Object[]{sbVar, ",", "queryInvoker.convertToNonNullableTEXT", principalVar});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "\n   FROM insertion_result\n"});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "   returning *),\n"});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "insertion_result3 AS ("});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "\n   INSERT INTO record_index(key,table_name,principal)\n"});
        mspec.addStatement("$N.append($S).append($S).append($N($S))", new Object[]{sbVar, "   SELECT distinct(parent) as key", ",", "queryInvoker.convertToNonNullableTEXT", config.name});
        mspec.addStatement("$N.append($S).append($N($N))", new Object[]{sbVar, ",", "queryInvoker.convertToNonNullableTEXT", principalVar});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "\n   from insertion_result)\n"});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "select * from insertion_result\n"});
    }

    private void simpleQueryInvokerEmbedded(TemplatesProjectConfiguration configs, TemplateCompilerConfig config, Set<String> foundSpecialTypes, String sbVar, MethodSpec.Builder mspec, String variableBean, List<String> sharing) {
        TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema((SimpleTemplateCompilerConfig)config);
        String startCallString = "insert_" + config.name + " (";
        this.compilerUtil.specWithComment(mspec);
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "( "});
        boolean first = true;
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
            boolean doProcess = true;
            if (!doProcess) continue;
            Class<?> cl = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
            if (first) {
                first = false;
            } else {
                mspec.addStatement("$N.append($S)", new Object[]{sbVar, ","});
            }
            if (ConfigProcessor.descriptorUtils.isInput(key, bindingsSchema) || sharing != null && sharing.contains(key)) {
                String sqlType;
                String comment = "";
                if (sharing != null && sharing.contains(key)) {
                    comment = "/* sharing */";
                }
                if ((sqlType = ConfigProcessor.descriptorUtils.getSqlType(key, bindingsSchema)) != null) {
                    String fun = this.converterForSpecialType(sqlType);
                    if (fun != null) {
                        mspec.addStatement("$N.append($N($N.$N)) $L", new Object[]{sbVar, fun, variableBean, key, comment});
                        foundSpecialTypes.add(sqlType);
                        continue;
                    }
                    mspec.addStatement("$N.append($N.$N) $L", new Object[]{sbVar, variableBean, key, comment});
                    continue;
                }
                mspec.addStatement("$N.append($N.$N) $L", new Object[]{sbVar, variableBean, key, comment});
                continue;
            }
            mspec.addStatement("$N.append($S) /* output */", new Object[]{sbVar, "null"});
        }
        String endCallString = ") :: " + config.name + "_type";
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, endCallString});
    }

    public void compositeQueryInvoker(TemplatesProjectConfiguration configs, Locations locations, TemplateCompilerConfig config, Set<String> foundSpecialTypes, String sbVar, MethodSpec.Builder mspec, String variableBean, boolean withBean) {
        CompositeTemplateCompilerConfig compositeConfig = (CompositeTemplateCompilerConfig)config;
        this.compilerUtil.specWithComment(mspec);
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "---- query invoker for  " + compositeConfig.name + " (with Principal)\n\n"});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "WITH \n    insertion_result AS ("});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "select * from "});
        mspec.beginControlFlow("if ($N)", new Object[]{linkingVar});
        String startCallString = "insert_" + config.name + "_and_linker (";
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, startCallString});
        mspec.nextControlFlow("else", new Object[0]);
        String startCallString2 = "insert_" + config.name + "_array (";
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, startCallString2});
        mspec.endControlFlow();
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "ARRAY[\n"});
        String variableBean1 = variableBean + "_1";
        mspec.addStatement("boolean first=true", new Object[0]);
        SimpleTemplateCompilerConfig composee = null;
        for (TemplateCompilerConfig c : configs.templates) {
            if (!compositeConfig.consistsOf.equals(c.name)) continue;
            composee = (SimpleTemplateCompilerConfig)c;
        }
        mspec.beginControlFlow("for ($T $N: $N.$N)", new Object[]{withBean ? ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)this.compilerUtil.commonNameClass(compositeConfig.consistsOf), (String[])new String[0]) : ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)this.compilerUtil.beanNameClass(compositeConfig.consistsOf, BeanDirection.INPUTS, "_1"), (String[])new String[0]), variableBean1, variableBean, "__elements"});
        mspec.beginControlFlow("if (first)", new Object[0]).addStatement("first=false", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("$N.append($S)", new Object[]{sbVar, ",\n     "}).endControlFlow();
        if (composee == null) {
            throw new IllegalStateException("No composee found " + compositeConfig.consistsOf);
        }
        this.simpleQueryInvokerEmbedded(configs, composee, foundSpecialTypes, sbVar, mspec, variableBean1, compositeConfig.sharing);
        mspec.endControlFlow();
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "])),\n"});
        this.insertAccessControlComposite(config, sbVar, mspec, composee, this.compilerUtil.getBindingsSchema(composee));
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, ";\n"});
    }

    public String converterForSpecialType(String specialType) {
        switch (specialType) {
            case "date": {
                return "queryInvoker.convertToDate";
            }
            case "timestamptz": {
                return "queryInvoker.convertToTimestamptz";
            }
            case "nullableTEXT": {
                return "queryInvoker.convertToNullableTEXT";
            }
            case "nonNullableTEXT": {
                return "queryInvoker.convertToNonNullableTEXT";
            }
            case "json": {
                return "queryInvoker.convertToJsonTEXT";
            }
        }
        return null;
    }
}

