/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashMap;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;

public class CompilerTableConfiguratorForTypes {
    public static final String PREFIX = "_b_";
    private final CompilerUtil compilerUtil;

    public CompilerTableConfiguratorForTypes(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    SpecificationFile generateTableConfigurator(TemplatesProjectConfiguration configs, Locations locations, String l2p_src_dir) {
        return this.generateTableConfigurator(configs, false, locations, l2p_src_dir);
    }

    SpecificationFile generateCompositeTableConfigurator(TemplatesProjectConfiguration configs, Locations locations, String l2p_src_dir) {
        return this.generateTableConfigurator(configs, true, locations, l2p_src_dir);
    }

    SpecificationFile generateTableConfigurator(TemplatesProjectConfiguration configs, boolean compositeOnly, Locations locations, String l2p_src_dir) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        String originalTableClassName = compositeOnly ? "CompositeTableConfigurator" : "TableConfigurator";
        String tableClassName = originalTableClassName + "ForTypesWithMap";
        String directory = locations.convertToDirectory(l2p_src_dir, "configurator");
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit(tableClassName);
        builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage(originalTableClassName), (String)originalTableClassName, (String[])new String[0]), (TypeName[])new TypeName[]{CompilerUtil.mapString2StringSetType}));
        builder.addField(CompilerUtil.mapString2StringType, "map", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField(CompilerUtil.mapString2StringArrayType, "propertyOrder", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField((TypeName)CompilerUtil.fileBuilderMapType, "documentBuilderDispatcher", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addParameter(CompilerUtil.mapString2StringType, "map", new Modifier[0]).addParameter(CompilerUtil.mapString2StringArrayType, "propertyOrder", new Modifier[0]).addParameter((TypeName)CompilerUtil.fileBuilderMapType, "documentBuilderDispatcher", new Modifier[0]).addParameter(ProvFactory.class, "pf", new Modifier[0]).addStatement("this.map=map", new Object[0]).addStatement("this.$N=$N", new Object[]{"propertyOrder", "propertyOrder"}).addStatement("this.$N=$N", new Object[]{"documentBuilderDispatcher", "documentBuilderDispatcher"}).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (TemplateCompilerConfig config : configs.templates) {
            String templateNameClass = this.compilerUtil.templateNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)templateNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec_builder = MethodSpec.methodBuilder((String)config.name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)className, (String)"builder", (Modifier[])new Modifier[0]).build()).returns(CompilerUtil.mapString2StringSetType);
            if (config instanceof SimpleTemplateCompilerConfig) {
                SimpleTemplateCompilerConfig simpleConfig = (SimpleTemplateCompilerConfig)config;
                ClassName builderClass = ClassName.get((String)locations.getFileBackendPackage("ignoreMe"), (String)this.compilerUtil.templateNameClass(config.name), (String[])new String[0]);
                mspec_builder.addStatement("$T $N=$N.get($S)", new Object[]{CompilerUtil.stringArrayType, "properties", "propertyOrder", config.name});
                mspec_builder.addStatement("$T $N = ($T) $N.get($S)", new Object[]{builderClass, "templateBuilder", builderClass, "documentBuilderDispatcher", config.name});
                mspec_builder.addStatement("$T $N=$N.make($N.getTypedRecord())", new Object[]{Object[].class, "record2", "templateBuilder", "templateBuilder"});
                mspec_builder.addStatement("$T knownTypeMap=new $T<>()", new Object[]{CompilerUtil.mapQualifiedName2StringSetType, HashMap.class});
                mspec_builder.addStatement("$N.make($N.getTypeManager(knownTypeMap, new $T<>(), new $T<>(), new $T<>(), new $T<>()))", new Object[]{"templateBuilder", "templateBuilder", HashMap.class, HashMap.class, HashMap.class, HashMap.class});
                mspec_builder.addStatement("$T $N=new $T<>()", new Object[]{CompilerUtil.mapString2StringSetType, "propertyMap", HashMap.class});
                mspec_builder.beginControlFlow("for (int i=0; i<$N.length; i++)", new Object[]{"record2"});
                mspec_builder.addStatement("$T property=$N[i]", new Object[]{String.class, "properties"});
                mspec_builder.addStatement("$T value=$N[i]", new Object[]{Object.class, "record2"});
                mspec_builder.beginControlFlow("if (value instanceof $T)", new Object[]{QualifiedName.class});
                mspec_builder.addStatement("$N.put(property, knownTypeMap.get((QualifiedName) value))", new Object[]{"propertyMap"});
                mspec_builder.endControlFlow();
                mspec_builder.endControlFlow();
                mspec_builder.addStatement("return $N", new Object[]{"propertyMap"});
            } else {
                mspec_builder.addStatement("return null", new Object[0]);
            }
            MethodSpec mspec = mspec_builder.build();
            builder.addMethod(mspec);
        }
        builder.addMethod(constructor.build());
        TypeSpec theLogger = builder.build();
        String myPackage = configs.root_package + ".configurator";
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, directory, tableClassName + ".java", myPackage);
    }
}

