/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;
import org.openprovenance.prov.template.descriptors.AttributeDescriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerTypeConverter {
    private final CompilerUtil compilerUtil;
    Map<String, String> mapper = new HashMap<String, String>(){
        {
            this.put("string", "getString");
            this.put("int", "getObject");
            this.put("integer", "getObject");
            this.put("double precision", "getObject");
            this.put("timestamptz", "getTimestamp");
        }
    };

    public CompilerTypeConverter(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    SpecificationFile generateTypeConverter(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        ParameterizedTypeName getterOfT = ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("TypeConverter"), (String)"TypeConverter.Getter", (String[])new String[0]), (TypeName[])new TypeName[]{CompilerUtil.typeT});
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("TypeConverter");
        builder.addTypeVariable(CompilerUtil.typeT);
        TypeSpec.Builder inface = this.compilerUtil.generateInterfaceInit("Getter");
        inface.addTypeVariable(CompilerUtil.typeT);
        inface.addMethod(MethodSpec.methodBuilder((String)"getString").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter(String.class, "col", new Modifier[0]).returns((TypeName)CompilerUtil.typeT).build());
        inface.addMethod(MethodSpec.methodBuilder((String)"getObject").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter(String.class, "col", new Modifier[0]).returns((TypeName)CompilerUtil.typeT).build());
        inface.addMethod(MethodSpec.methodBuilder((String)"getTimestamp").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter(String.class, "col", new Modifier[0]).returns((TypeName)CompilerUtil.typeT).build());
        builder.addType(inface.build());
        builder.addField((TypeName)getterOfT, "getter", new Modifier[]{Modifier.FINAL});
        MethodSpec.Builder cbuilder3 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)getterOfT, "getter", new Modifier[0]).addStatement("this.getter = getter", new Object[0]);
        builder.addMethod(cbuilder3.build());
        for (TemplateCompilerConfig config : configs.templates) {
            if (!(config instanceof SimpleTemplateCompilerConfig)) continue;
            TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema((SimpleTemplateCompilerConfig)config);
            String templateNameClass = this.compilerUtil.templateNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName templateClass = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)templateNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = this.createProcessMethod(bindingsSchema, templateClass);
            builder.addMethod(mspec.build());
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }

    private MethodSpec.Builder createProcessMethod(TemplateBindingsSchema bindingsSchema, ClassName outputClassName) {
        MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)outputClassName, (String)"builder", (Modifier[])new Modifier[0]).build()).returns(CompilerUtil.mapTypeT);
        this.compilerUtil.specWithComment(mspec);
        mspec.addStatement("$T m=new $T()", new Object[]{CompilerUtil.mapTypeT, CompilerUtil.hashMapTypeT});
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
            Class<?> cl = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
            String sqlType = ConfigProcessor.descriptorUtils.getFromDescriptor(bindingsSchema.getVar().get(key).get(0), AttributeDescriptor::getSqlType, nd -> null);
            mspec.addStatement("m.put($S, getter.$N($S))", new Object[]{key, this.convertToMethod(cl.getSimpleName(), sqlType), key});
        }
        mspec.addStatement("return m", new Object[0]);
        return mspec;
    }

    private String convertToMethod(String simpleClassName, String sqlName) {
        String res = null;
        if (sqlName != null) {
            res = this.mapper.get(sqlName.toLowerCase());
        }
        if (res == null) {
            res = this.mapper.get(simpleClassName.toLowerCase());
        }
        if (res == null) {
            throw new IllegalStateException("Unexpected value: " + simpleClassName);
        }
        return res;
    }
}

