/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.openprovenance.prov.template.emitter.minilanguage.Comment;
import org.openprovenance.prov.template.emitter.minilanguage.Field;
import org.openprovenance.prov.template.emitter.minilanguage.Method;
import org.openprovenance.prov.template.emitter.minilanguage.MethodCall;
import org.openprovenance.prov.template.emitter.minilanguage.Symbol;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Class {
    private final String name;
    private final List<Comment> comments = new LinkedList<Comment>();
    public final List<Field> fields = new LinkedList<Field>();
    private final List<Method> methods = new LinkedList<Method>();
    private final List<String> interfaces = new LinkedList<String>();
    public List<Field> fieldsForClassInitialiser = new LinkedList<Field>();

    public Class(String name, List<String> interfaces, List<Field> fields, List<Method> methods, List<Comment> comments) {
        this.name = name;
        this.interfaces.addAll(interfaces);
        this.fields.addAll(fields);
        this.methods.addAll(methods);
        this.comments.addAll(comments);
    }

    public void emit(Python emitter) {
        emitter.emitBeginLine("class " + this.name + ":");
        emitter.emitNewline();
        emitter.indent();
        boolean noComment = true;
        for (Comment c : this.comments) {
            if (c == null || c.comment == null || c.comment.trim().isEmpty()) continue;
            emitter.emitLine("\"\"\"" + c.comment + "\"\"\"");
            noComment = false;
        }
        if (!noComment) {
            emitter.emitNewline();
        }
        List<String> classVariables = this.fields.stream().map(x -> x.name).collect(Collectors.toList());
        HashSet<String> staticMethods = new HashSet<String>();
        for (Method m : this.methods) {
            if (m.isStatic()) {
                staticMethods.add(m.name);
                m.emit(emitter, classVariables, new LinkedList<String>());
                continue;
            }
            m.emit(emitter, new LinkedList<String>(), classVariables);
        }
        for (Field f : this.fields) {
            if (this.belongingClassInitialiser(f, staticMethods)) {
                this.fieldsForClassInitialiser.add(f);
                continue;
            }
            f.emit(emitter);
        }
    }

    public boolean belongingClassInitialiser(Field f, Collection<String> staticMethods) {
        if (f.initialiser == null) {
            return false;
        }
        if (f.initialiser instanceof MethodCall) {
            MethodCall mc = (MethodCall)f.initialiser;
            if (mc.object instanceof Symbol) {
                Symbol s = (Symbol)mc.object;
                if (s.symbol.equals(this.name)) {
                    return true;
                }
            }
            if (staticMethods.contains(mc.methodName)) {
                return true;
            }
        }
        return false;
    }

    public void emitClassInitialiser(Python emitter, int indent) {
        if (this.fieldsForClassInitialiser.isEmpty()) {
            return;
        }
        emitter.indent = indent;
        emitter.emitLine("# class initialiser for " + this.name);
        for (Field f : this.fieldsForClassInitialiser) {
            emitter.indent = indent;
            emitter.emitBeginLine(this.name + ".");
            ((MethodCall)f.initialiser).object = new Symbol(this.name, null);
            f.emit(emitter);
        }
    }
}

