/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.List;
import org.openprovenance.prov.template.emitter.Element;
import org.openprovenance.prov.template.emitter.Pair;
import org.openprovenance.prov.template.emitter.Token;
import org.openprovenance.prov.template.emitter.minilanguage.Statement;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Comment
extends Statement {
    String comment = "";

    public Comment(List<Element> elements) {
        super(elements);
        for (Element e : elements) {
            if (e instanceof Token) {
                this.comment = this.comment + ((Token)e).token;
                continue;
            }
            if (e instanceof Pair) {
                this.comment = this.comment + Pair.getArg(e).toString();
                continue;
            }
            throw new UnsupportedOperationException("Cannot handle " + String.valueOf(e.getClass()));
        }
    }

    public Comment(String comment) {
        super(null);
        this.comment = comment;
    }

    @Override
    public String toString() {
        return "Comment{elements=" + String.valueOf(this.elements) + "}";
    }

    @Override
    public void emit(Python emitter, List<String> classVariables, List<String> instanceVariables) {
        emitter.emitBeginLine("# " + this.comment.substring(2).trim());
        emitter.emitNewline();
    }
}

