/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.List;
import org.openprovenance.prov.template.emitter.Element;
import org.openprovenance.prov.template.emitter.minilanguage.Expression;
import org.openprovenance.prov.template.emitter.minilanguage.Parameter;
import org.openprovenance.prov.template.emitter.minilanguage.Statement;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Lambda
extends Expression {
    final List<Parameter> parameters;
    final List<Statement> body;

    public Lambda(List<Parameter> parameters, List<Statement> body, List<Element> elements1) {
        super(elements1);
        this.body = body;
        this.parameters = parameters;
    }

    @Override
    public String toString() {
        return "Lambda{parameters=" + String.valueOf(this.parameters) + ", body=" + String.valueOf(this.body) + "}";
    }

    @Override
    public void emit(Python emitter, boolean continueLine, List<String> classVariables, List<String> instanceVariables) {
        emitter.emitLine("lambda ", continueLine);
        boolean first = true;
        for (Parameter p : this.parameters) {
            if (!first) {
                emitter.emitContinueLine(",");
            }
            first = false;
            emitter.emitContinueLine(p.name);
        }
        emitter.emitContinueLine(": ");
        for (Statement s : this.body) {
            s.emit(emitter, classVariables, instanceVariables);
        }
    }
}

