/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import com.squareup.javapoet.ClassName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openprovenance.prov.template.emitter.Element;
import org.openprovenance.prov.template.emitter.minilanguage.Expression;
import org.openprovenance.prov.template.emitter.minilanguage.Symbol;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class MethodCall
extends Expression {
    public Expression object;
    final String methodName;
    private final List<?> arguments;
    static Map<String, String> table = new HashMap<String, String>(){
        {
            this.put("org.openprovenance.apache.commons.lang.StringEscapeUtils", "StringEscapeUtils");
        }
    };

    public MethodCall(Object object, String methodName, List<?> arguments, List<Element> elements) {
        super(elements);
        this.methodName = methodName;
        this.arguments = arguments;
        if (object == null) {
            this.object = null;
        } else if (object instanceof String) {
            this.object = new Symbol((String)object, elements);
        } else if (object instanceof ClassName) {
            this.object = new Symbol(object.toString(), elements);
        } else if (object instanceof MethodCall) {
            this.object = (MethodCall)object;
        } else {
            System.out.println("#### object " + String.valueOf(object) + "  " + String.valueOf(object.getClass()));
            throw new UnsupportedOperationException("Cannot handle " + String.valueOf(object.getClass()));
        }
    }

    @Override
    public String toString() {
        return "MethodCall{object=" + String.valueOf(this.object) + ", methodName=" + this.methodName + ", arguments=" + String.valueOf(this.arguments) + "}";
    }

    @Override
    public void emit(Python emitter, boolean continueLine, List<String> classVariables, List<String> instanceVariables) {
        if ("put".equals(this.methodName) && this.arguments != null && this.arguments.size() == 2) {
            this.object.emit(emitter, continueLine, classVariables, instanceVariables);
            emitter.emitContinueLine("[");
            ((Expression)this.arguments.get(0)).emit(emitter, true, classVariables, instanceVariables);
            emitter.emitContinueLine("]");
            emitter.emitContinueLine("=");
            ((Expression)this.arguments.get(1)).emit(emitter, true, classVariables, instanceVariables);
            emitter.emitNewline();
        } else if ("get".equals(this.methodName) && this.arguments != null && this.arguments.size() == 1) {
            this.object.emit(emitter, continueLine, classVariables, instanceVariables);
            emitter.emitContinueLine("[");
            ((Expression)this.arguments.get(0)).emit(emitter, true, classVariables, instanceVariables);
            emitter.emitContinueLine("]");
        } else {
            if (this.object != null) {
                if (this.object instanceof Symbol && ((Symbol)this.object).symbol.equals("sb") && this.methodName.equals("toString")) {
                    emitter.emitLine("''.join(str(e) for e in sb)", continueLine);
                    return;
                }
                this.object.emit(emitter, continueLine, classVariables, instanceVariables);
            }
            if (!this.methodName.equals("process")) {
                if (this.object != null) {
                    emitter.emitContinueLine(".");
                }
                if (this.methodName.equals("toBean")) {
                    emitter.emitContinueLine("cls.");
                }
                emitter.emitContinueLine(this.methodName);
            }
            if (this.arguments == null) {
                if (!continueLine) {
                    emitter.emitNewline();
                }
                return;
            }
            emitter.emitContinueLine("(");
            boolean first = true;
            for (Object argument : this.arguments) {
                if (first) {
                    first = false;
                } else {
                    emitter.emitContinueLine(",");
                }
                if (argument instanceof Expression) {
                    ((Expression)argument).emit(emitter, true, classVariables, instanceVariables);
                    continue;
                }
                emitter.emitContinueLine(MethodCall.localized(argument.toString(), classVariables, instanceVariables));
            }
            emitter.emitContinueLine(")");
            if (!continueLine) {
                emitter.emitNewline();
            }
        }
    }

    public static String convertName(String string, List<String> classVariables, List<String> instanceVariables) {
        if (table.containsKey(string)) {
            return table.get(string);
        }
        return MethodCall.localized(string, classVariables, instanceVariables);
    }
}

