/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.validation.matrix.Pair;
import org.openprovenance.prov.validation.matrix.SparseMatrix;

public class EventMatrix {
    static Logger logger = LogManager.getLogger(EventMatrix.class);
    public final SparseMatrix m;
    final SparseMatrix next;
    final int size;
    final Vector<String> eventKinds;
    public static final double epsilon = 0.001;
    public static final double minus_one = -1.0;

    public EventMatrix(int size, Vector<String> eventKinds) {
        this.size = size;
        this.eventKinds = eventKinds;
        this.m = new SparseMatrix(size, size);
        this.next = new SparseMatrix(size, size);
        logger.debug("created matrix");
    }

    public void floydWarshall() {
        this.m.floydWarshall(this.next);
    }

    public String displayMatrix2() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        for (i = 0; i < this.size; ++i) {
            sb.append(this.eventKinds.get(i));
        }
        sb.append("\n");
        for (i = 0; i < this.size; ++i) {
            sb.append(this.eventKinds.get(i));
            for (int j = 0; j < this.size; ++j) {
                Pair p = this.m.g(i, j);
                if (p != null) {
                    if (p.getValue() > 0) {
                        sb.append("X");
                        continue;
                    }
                    if (i == j) {
                        sb.append("\\");
                        continue;
                    }
                    sb.append(".");
                    continue;
                }
                if (i == j) {
                    sb.append("\\");
                    continue;
                }
                sb.append(".");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String displayMatrix3() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        for (i = 0; i < this.size; ++i) {
            sb.append(this.eventKinds.get(i));
        }
        sb.append("\n");
        for (i = 0; i < this.size; ++i) {
            sb.append(this.eventKinds.get(i));
            for (int j = 0; j < this.size; ++j) {
                Pair p = this.m.g(i, j);
                if (p != null) {
                    int vv = p.getValue();
                    if (vv > 0) {
                        if (vv < 10) {
                            sb.append(vv);
                            continue;
                        }
                        sb.append("X");
                        continue;
                    }
                    if (i == j) {
                        sb.append("\\");
                        continue;
                    }
                    sb.append(".");
                    continue;
                }
                if (i == j) {
                    sb.append("\\");
                    continue;
                }
                sb.append(".");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void generateImage1(String filename) throws IOException {
        logger.debug("--- generatedImage1 ");
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        ImageWriter writer = writers.next();
        File f = new File(filename);
        ImageOutputStream ios = ImageIO.createImageOutputStream(f);
        writer.setOutput(ios);
        this.generateImage(writer, ios);
    }

    public void generateImage1(OutputStream os) throws IOException {
        logger.debug("--- generatedImage1 ");
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        writer.setOutput(ios);
        this.generateImage(writer, ios);
    }

    public void generateImage(ImageWriter writer, ImageOutputStream ios) throws IOException {
        if (this.size <= 1) {
            return;
        }
        BufferedImage bi = new BufferedImage(this.size, this.size, 1);
        int maxValue = 6;
        logger.debug("--- generatedImage1 ");
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                Pair p = this.m.g(i, j);
                if (p != null && p.getValue() > 0) {
                    int val = p.getValue();
                    bi.setRGB(j, i, 255 * (maxValue + 1 - val) / maxValue * 256 * 256 + 255 * (val - 1) / maxValue);
                    continue;
                }
                if (i == j) {
                    bi.setRGB(j, i, 17920);
                    continue;
                }
                bi.setRGB(j, i, 0);
            }
        }
        logger.debug("--- generatedImage1 ");
        writer.write(bi);
        ios.flush();
        ios.close();
        logger.debug("--- generatedImage1 (end) ");
    }

    public List<Object> diagonal() {
        LinkedList<Object> res = new LinkedList<Object>();
        for (int i = 0; i < this.size; ++i) {
            Pair p = this.m.g(i, i);
            res.add(p == null ? null : Integer.valueOf(p.getValue()));
        }
        return res;
    }

    public List<Integer> getPath(int i, int j) {
        try {
            List<Integer> result = this.getPath2(i, j);
            if (result != null) {
                result.add(0, i);
                result.add(j);
                return result;
            }
            return new LinkedList<Integer>();
        }
        catch (UnsupportedOperationException e) {
            return new LinkedList<Integer>();
        }
    }

    private List<Integer> getPath2(int i, int j) {
        Pair pair_i_j = this.m.g(i, j);
        if (pair_i_j != null) {
            int v_i_j = pair_i_j.getValue();
            int r_i_j = this.m.roundedOrder(v_i_j);
            if (r_i_j == 2) {
                return new LinkedList<Integer>();
            }
            for (Pair pair_i_k : this.m.getRow(i)) {
                List<Integer> path2;
                List<Integer> path1;
                int v_k_j;
                int r_k_j;
                int k = pair_i_k.getSecond();
                int v_i_k = pair_i_k.getValue();
                int r_i_k = this.m.roundedOrder(v_i_k);
                Pair pair_k_j = this.m.g(k, j);
                if (pair_k_j == null || r_i_k + (r_k_j = this.m.roundedOrder(v_k_j = pair_k_j.getValue())) != r_i_j || (path1 = this.getPath2(i, k)) == null || (path2 = this.getPath2(k, j)) == null) continue;
                LinkedList<Integer> result = new LinkedList<Integer>();
                result.addAll(path1);
                result.add(k);
                result.addAll(path2);
                return result;
            }
        }
        return null;
    }

    public List<Integer> getPath2_old(int i, int j) {
        if (i == j) {
            return new LinkedList<Integer>();
        }
        if (this.m.g(i, j) == null || this.m.g(i, j).getValue() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (this.next.g(i, j) == null) {
            return new LinkedList<Integer>();
        }
        Pair p = this.next.g(i, j);
        int intermediate = p.getValue();
        if (intermediate == -1) {
            return new LinkedList<Integer>();
        }
        List<Integer> result = this.getPath2(i, intermediate);
        result.add(intermediate);
        result.addAll(this.getPath2(intermediate, j));
        return result;
    }

    public List<Integer> orderEvents() {
        LinkedList<Integer> res = new LinkedList<Integer>();
        for (int i = 0; i < this.size; ++i) {
            res.add(i);
        }
        res.sort(new EventComparator());
        return res;
    }

    public int getMaximum() {
        return this.m.getMaximum();
    }

    public class EventComparator
    implements Comparator<Integer> {
        @Override
        public int compare(Integer i1, Integer i2) {
            if (Objects.equals(i1, i2)) {
                return 0;
            }
            Pair p_1_2 = EventMatrix.this.m.g(i1, i2);
            if (p_1_2 == null && EventMatrix.this.m.g(i1, i2) == null) {
                return 0;
            }
            if (EventMatrix.this.m.g(i1, i2) == null) {
                return -1;
            }
            if (p_1_2 == null) {
                return 1;
            }
            return i1.compareTo(i2);
        }
    }
}

